/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.indexer;

import com.luna.insight.admin.DisplayDialog;
import com.luna.insight.admin.InsightAdministrator;
import com.luna.insight.admin.collserver.task.CcTaskItem;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import com.luna.insight.server.indexer.TrinityIndexer;
import com.luna.insight.server.indexer.TrinityIndexerProgressListener;
import com.luna.insight.server.inscribe.EntityIndexer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollBar;
import javax.swing.Timer;

public class CsTasksIndexerDisplayDialog
extends DisplayDialog
implements TrinityIndexerProgressListener,
ActionListener {
    private JFrame mainFrame = null;
    private CcTaskItem taskItem;
    private JLabel valueIndexingFieldLabel = new JLabel("Indexing Value Field: ");
    private JLabel valueIndexingField = new JLabel("Not Started");
    private JLabel valueReadProgressLabel = new JLabel("Read Progress: ");
    private JLabel valueWriteProgressLabel = new JLabel("Write Progress: ");
    private JLabel valueTotalValueLabel = new JLabel("Value Indexing Progress:");
    private JProgressBar valuePb1 = new JProgressBar(0, 0, 100);
    private JProgressBar valuePb2 = new JProgressBar(0, 0, 100);
    private JProgressBar valuePb3 = new JProgressBar();
    private JLabel termIndexingFieldLabel = new JLabel("Indexing Term Field: ");
    private JLabel termIndexingField = new JLabel("Not Started");
    private JLabel termReadProgressLabel = new JLabel("Read Progress: ");
    private JLabel termWriteProgressLabel = new JLabel("Write Progress: ");
    private JLabel termTotalValueLabel = new JLabel("Term Indexing Progress: ");
    private JProgressBar termPb1 = new JProgressBar(0, 0, 100);
    private JProgressBar termPb2 = new JProgressBar(0, 0, 100);
    private JProgressBar termPb3 = new JProgressBar();
    private JLabel incrementalIndexingStatusLabel = new JLabel("Incremental Indexing: ");
    private JLabel incrementalIndexingStatus = new JLabel("Not Started");
    private JLabel incrementalProgressLabel = new JLabel("Incremental Indexing Progress: ");
    private JProgressBar incrementalPb1 = new JProgressBar();
    private JLabel browserLabel = new JLabel("Browser Indexing: ");
    private JLabel browserStatus = new JLabel("Not Started");
    private JLabel browserReadingObjectValues = new JLabel("Reading Object Values: ");
    private JLabel browserSortingRecords = new JLabel("Sorting Flat Object Records: ");
    private JLabel browserWritingRecords = new JLabel("Writing Flat Object Records: ");
    private JProgressBar browserPb1 = new JProgressBar();
    private JProgressBar browserPb2 = new JProgressBar();
    private JProgressBar browserPb3 = new JProgressBar();
    private JLabel hierarchyLabel = new JLabel("Indexing Hierarchies: ");
    private JLabel hierarchyStatus = new JLabel("Not Started");
    private JLabel hierarchyLoadingNames = new JLabel("Loading Hierarchy Names: ");
    private JLabel hierarchyPopulatingTables = new JLabel("Populating Hierarchy Tables: ");
    private JLabel hierarchyCreatingMappings = new JLabel("Creating Hierarchy Mappings: ");
    private JProgressBar hierarchyPb1 = new JProgressBar();
    private JProgressBar hierarchyPb2 = new JProgressBar();
    private JProgressBar hierarchyPb3 = new JProgressBar();
    private JLabel destinationTablesLabel = new JLabel("Updating Destination Tables: ");
    private JLabel destinationTablesStatus = new JLabel("Not Started");
    private JLabel destinationIndexingStatus = new JLabel("Destination Update Progress: ");
    private JProgressBar destinationPb1 = new JProgressBar();
    private JLabel mpdIndexingLabel = new JLabel("Indexing Multi-page Document: ");
    private JLabel mpdIndexingField = new JLabel();
    private JLabel mpdProgressLabel = new JLabel("MPD Indexing Progress: ");
    private JProgressBar mpdPb1 = new JProgressBar();
    private JLabel fdIndexingLabel = new JLabel("Indexing Fuzzy Dates: ");
    private JLabel fdIndexingStatus = new JLabel("Not Started");
    private JLabel fdIndexingProgressLabel = new JLabel("Fuzzy Date Indexing Progress: ");
    private JProgressBar fdPb1 = new JProgressBar();
    private JLabel updateLabel = new JLabel("Update Thumbnail Caches: ");
    private JLabel updateStatusLabel = new JLabel("Update Progress: ");
    private JLabel updateStatus = new JLabel("Not Started");
    private JProgressBar utcPb1 = new JProgressBar();
    private Timer timer = null;
    private Timer remainingTimeTimer = null;
    private long timeSpent = 0L;
    private long startTime = 0L;
    private long startPause = 0L;
    private long endPause = 0L;
    private long totalPause = 0L;
    private JLabel valueElapsedTimeLabel = new JLabel("Elapsed Time: ");
    private JLabel valueElapsedTime = new JLabel();
    private JLabel valueRemainingTimeLabel = new JLabel("Remaining Time: ");
    private JLabel valueRemainingTime = new JLabel();
    private JLabel spaceLabel1 = new JLabel("");
    private JPanel spacePanel1 = new JPanel();
    private JPanel spacePanel2 = new JPanel();
    private JPanel spacePanel3 = new JPanel();
    private JPanel spacePanel4 = new JPanel();
    private JPanel spacePanel5 = new JPanel();
    private JPanel spacePanel6 = new JPanel();
    private JPanel spacePanel7 = new JPanel();
    private JPanel spacePanel8 = new JPanel();
    private JPanel spacePanel9 = new JPanel();
    private TrinityIndexer ti = null;
    private EntityIndexer mei = null;
    private boolean valueIndexing = false;
    private boolean termIndexing = false;
    private boolean incrementalIndexing = false;
    private boolean browserIndexing = false;
    private int maxChars;
    private boolean hierarchyIndexing = false;
    private boolean multipageDocumentIndexing = false;
    private boolean fuzzyDateIndexing = false;
    private boolean updateThumbnailCaches = false;
    private boolean cancelled = false;
    private int reportTimeIncrement = 0;
    private long field1StartTime = 0L;
    private long field2StartTime = 0L;
    private long field4StartTime = 0L;
    private int numberOfFields = 0;
    private long expectedTotalTime = 0L;
    private long timeRemaining = 0L;
    private int weightValue = 0;
    private int weightTerm = 0;
    private int weightDest = 0;
    private int weightBrowser = 0;
    private int weightHierarchy = 0;
    private int weightMpd = 0;
    private int weightFuzzyDate = 0;
    private int weightUtc = 0;

    public CsTasksIndexerDisplayDialog(JFrame jFrame, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, boolean bl5, boolean bl6, boolean bl7, boolean bl8, TrinityIndexer trinityIndexer, EntityIndexer entityIndexer) {
        super(jFrame, "Indexer Progress", true);
        this.mainFrame = jFrame;
        this.valueIndexing = bl;
        this.termIndexing = bl2;
        this.incrementalIndexing = bl3;
        this.browserIndexing = bl4;
        this.maxChars = n;
        this.hierarchyIndexing = bl5;
        this.multipageDocumentIndexing = bl6;
        this.fuzzyDateIndexing = bl7;
        this.updateThumbnailCaches = bl8;
        if (bl3) {
            bl = false;
            bl2 = false;
        }
        this.ti = trinityIndexer;
        this.mei = entityIndexer;
        this.startTime = System.currentTimeMillis();
        this.totalPause = 0L;
        this.timer = new Timer(1000, this);
        this.timer.start();
        this.spacePanel1.add(this.spaceLabel1);
        this.spacePanel2.add(this.spaceLabel1);
        this.spacePanel3.add(this.spaceLabel1);
        this.spacePanel4.add(this.spaceLabel1);
        this.spacePanel5.add(this.spaceLabel1);
        this.spacePanel6.add(this.spaceLabel1);
        this.spacePanel7.add(this.spaceLabel1);
        this.spacePanel8.add(this.spaceLabel1);
        this.initComponents();
        Dimension dimension = this.getPreferredSize();
        int n2 = new JScrollBar().getPreferredSize().width;
        this.setPreferredSize(new Dimension(dimension.width + n2, dimension.height + n2));
        this.show();
    }

    public void setTaskItem(CcTaskItem ccTaskItem) {
        this.taskItem = ccTaskItem;
    }

    public void cancel() {
        this.cancelled = true;
        if (this.mei != null) {
            this.mei.setIndexCancelled(true);
        }
        if (this.ti != null) {
            this.ti.setIndexCancelled(true);
        }
        this.closeDialog(null);
        if (this.taskItem != null) {
            this.taskItem.setTaskItemCancelled();
        }
    }

    protected void handleCancellation() {
        if (this.cancelled) {
            // empty if block
        }
    }

    public void indexerFailure(String string) {
        if (!this.cancelled) {
            InsightAdministrator.getInsightAdministrator().showWarningDialog(string, "Indexer Failure");
        }
        if (this.mei != null) {
            this.mei.setIndexCancelled(true);
        }
        if (this.ti != null) {
            this.ti.setIndexCancelled(true);
        }
    }

    public String getDisplayWindowTitle() {
        return new String("Indexer Progress");
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/collection-creation-indexer-icon.gif");
    }

    public void initComponents() {
        this.fieldsPanel.setBorder(BorderFactory.createTitledBorder("Starting Indexer"));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.fieldsPanel.setLayout(gridBagLayout);
        int n = 0;
        int n2 = 0;
        gridBagConstraints.anchor = 17;
        if (this.valueIndexing) {
            gridBagConstraints.gridx = n;
            gridBagConstraints.gridy = n2++;
            gridBagConstraints.gridwidth = 2;
            this.fieldsPanel.add((Component)this.valueIndexingFieldLabel, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridwidth = 2;
            this.fieldsPanel.add((Component)this.valueIndexingField, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n2++;
            gridBagConstraints.gridwidth = 2;
            this.fieldsPanel.add((Component)this.valueReadProgressLabel, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            this.fieldsPanel.add((Component)this.valuePb1, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n2++;
            gridBagConstraints.gridwidth = 2;
            this.fieldsPanel.add((Component)this.valueWriteProgressLabel, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            this.fieldsPanel.add((Component)this.valuePb2, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n2++;
            gridBagConstraints.gridwidth = 2;
            this.fieldsPanel.add((Component)this.valueTotalValueLabel, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            this.fieldsPanel.add((Component)this.valuePb3, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n2++;
            this.fieldsPanel.add((Component)this.spacePanel1, gridBagConstraints);
        }
        if (this.termIndexing) {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n2++;
            gridBagConstraints.gridwidth = 2;
            this.fieldsPanel.add((Component)this.termIndexingFieldLabel, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridwidth = 2;
            this.fieldsPanel.add((Component)this.termIndexingField, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n2++;
            gridBagConstraints.gridwidth = 2;
            this.fieldsPanel.add((Component)this.termReadProgressLabel, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            this.fieldsPanel.add((Component)this.termPb1, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n2++;
            gridBagConstraints.gridwidth = 2;
            this.fieldsPanel.add((Component)this.termWriteProgressLabel, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            this.fieldsPanel.add((Component)this.termPb2, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n2++;
            gridBagConstraints.gridwidth = 2;
            this.fieldsPanel.add((Component)this.termTotalValueLabel, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            this.fieldsPanel.add((Component)this.termPb3, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n2++;
            this.fieldsPanel.add((Component)this.spacePanel2, gridBagConstraints);
        }
        if (this.incrementalIndexing) {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n2++;
            gridBagConstraints.gridwidth = 2;
            this.fieldsPanel.add((Component)this.incrementalIndexingStatusLabel, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            this.fieldsPanel.add((Component)this.incrementalIndexingStatus, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n2++;
            gridBagConstraints.gridwidth = 2;
            this.fieldsPanel.add((Component)this.incrementalProgressLabel, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            this.fieldsPanel.add((Component)this.incrementalPb1, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n2++;
            this.fieldsPanel.add((Component)this.spacePanel3, gridBagConstraints);
        }
        if (this.browserIndexing) {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n2++;
            gridBagConstraints.gridwidth = 2;
            this.fieldsPanel.add((Component)this.browserLabel, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            this.fieldsPanel.add((Component)this.browserStatus, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n2++;
            gridBagConstraints.gridwidth = 2;
            this.fieldsPanel.add((Component)this.browserReadingObjectValues, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridwidth = 2;
            this.fieldsPanel.add((Component)this.browserPb1, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n2++;
            gridBagConstraints.gridwidth = 2;
            this.fieldsPanel.add((Component)this.browserWritingRecords, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            this.fieldsPanel.add((Component)this.browserPb3, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n2++;
            this.fieldsPanel.add((Component)this.spacePanel9, gridBagConstraints);
        }
        if (this.hierarchyIndexing) {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n2++;
            gridBagConstraints.gridwidth = 2;
            this.fieldsPanel.add((Component)this.hierarchyLabel, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            this.fieldsPanel.add((Component)this.hierarchyStatus, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n2++;
            gridBagConstraints.gridwidth = 2;
            this.fieldsPanel.add((Component)this.hierarchyLoadingNames, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridwidth = 2;
            this.fieldsPanel.add((Component)this.hierarchyPb1, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n2++;
            gridBagConstraints.gridwidth = 2;
            this.fieldsPanel.add((Component)this.hierarchyPopulatingTables, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            this.fieldsPanel.add((Component)this.hierarchyPb2, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n2++;
            gridBagConstraints.gridwidth = 2;
            this.fieldsPanel.add((Component)this.hierarchyCreatingMappings, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            this.fieldsPanel.add((Component)this.hierarchyPb3, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n2++;
            this.fieldsPanel.add((Component)this.spacePanel4, gridBagConstraints);
        }
        if (this.valueIndexing || this.termIndexing || this.incrementalIndexing) {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n2++;
            gridBagConstraints.gridwidth = 2;
            this.fieldsPanel.add((Component)this.destinationTablesLabel, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            this.fieldsPanel.add((Component)this.destinationTablesStatus, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n2++;
            this.fieldsPanel.add((Component)this.destinationIndexingStatus, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            this.fieldsPanel.add((Component)this.destinationPb1, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n2++;
            this.fieldsPanel.add((Component)this.spacePanel5, gridBagConstraints);
        }
        if (this.updateThumbnailCaches) {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n2++;
            gridBagConstraints.gridwidth = 2;
            this.fieldsPanel.add((Component)this.updateLabel, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridwidth = 2;
            this.fieldsPanel.add((Component)this.updateStatus, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n2++;
            gridBagConstraints.gridwidth = 2;
            this.fieldsPanel.add((Component)this.updateStatusLabel, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            this.fieldsPanel.add((Component)this.utcPb1, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n2++;
            this.fieldsPanel.add((Component)this.spacePanel8, gridBagConstraints);
        }
        if (this.fuzzyDateIndexing) {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n2++;
            gridBagConstraints.gridwidth = 2;
            this.fieldsPanel.add((Component)this.fdIndexingLabel, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridwidth = 2;
            this.fieldsPanel.add((Component)this.fdIndexingStatus, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n2++;
            gridBagConstraints.gridwidth = 2;
            this.fieldsPanel.add((Component)this.fdIndexingProgressLabel, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            this.fieldsPanel.add((Component)this.fdPb1, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n2++;
            this.fieldsPanel.add((Component)this.spacePanel7, gridBagConstraints);
        }
        if (this.multipageDocumentIndexing) {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n2++;
            gridBagConstraints.gridwidth = 2;
            this.fieldsPanel.add((Component)this.mpdIndexingLabel, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridwidth = 2;
            this.fieldsPanel.add((Component)this.mpdIndexingField, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n2++;
            gridBagConstraints.gridwidth = 2;
            this.fieldsPanel.add((Component)this.mpdProgressLabel, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            this.fieldsPanel.add((Component)this.mpdPb1, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n2++;
            this.fieldsPanel.add((Component)this.spacePanel6, gridBagConstraints);
        }
        if (this.valueIndexing || this.termIndexing) {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n2++;
            gridBagConstraints.gridwidth = 1;
            this.fieldsPanel.add((Component)this.valueElapsedTimeLabel, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            this.fieldsPanel.add((Component)this.valueElapsedTime, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            this.fieldsPanel.add((Component)this.valueRemainingTimeLabel, gridBagConstraints);
            gridBagConstraints.gridx = 3;
            this.fieldsPanel.add((Component)this.valueRemainingTime, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n2++;
        }
    }

    public JPanel getFieldsPanel() {
        return this.fieldsPanel;
    }

    public void setBorderTitle(String string) {
        this.fieldsPanel.setBorder(BorderFactory.createTitledBorder(string));
    }

    public int showJOptionPaneConfirmDialog(String string, String string2) {
        return JOptionPane.showConfirmDialog(this.mainFrame, string, string2, 0, 3);
    }

    public void setValueIndexingFieldText(String string) {
        this.handleCancellation();
        this.valueIndexingField.setText(string);
    }

    public void setValuePb3Maximum(int n) {
        this.handleCancellation();
        this.valuePb3.setMaximum(n);
    }

    public void setValuePb1Value(int n) {
        this.handleCancellation();
        this.valuePb1.setValue(n);
    }

    public void setValuePb1Maximum(int n) {
        this.handleCancellation();
        this.valuePb1.setMaximum(n);
    }

    public void setValuePb2Value(int n) {
        this.handleCancellation();
        this.valuePb2.setValue(n);
    }

    public void setValuePb3Value(int n) {
        this.handleCancellation();
        this.valuePb3.setValue(n);
    }

    public void setTermIndexingFieldText(String string) {
        this.handleCancellation();
        this.termIndexingField.setText(string);
    }

    public void setTermPb3Maximum(int n) {
        this.handleCancellation();
        this.termPb3.setMaximum(n);
    }

    public void setTermPb1Value(int n) {
        this.handleCancellation();
        this.termPb1.setValue(n);
    }

    public void setTermPb2Value(int n) {
        this.handleCancellation();
        this.termPb2.setValue(n);
    }

    public void setTermPb3Value(int n) {
        this.handleCancellation();
        this.termPb3.setValue(n);
    }

    public void setDestinationTablesStatusText(String string) {
        this.handleCancellation();
        this.destinationTablesStatus.setText(string);
    }

    public void setDestinationPb1Value(int n) {
        this.handleCancellation();
        this.destinationPb1.setValue(n);
    }

    public void setDestinationPb1Maximum(int n) {
        this.handleCancellation();
        this.destinationPb1.setMaximum(n);
    }

    public void setBrowserStatusText(String string) {
        this.handleCancellation();
        this.browserStatus.setText(string);
    }

    public void setBrowserPb1Maximum(int n) {
        this.handleCancellation();
        this.browserPb1.setMaximum(n);
    }

    public void setBrowserPb2Maximum(int n) {
        this.handleCancellation();
        this.browserPb2.setMaximum(n);
    }

    public void setBrowserPb3Maximum(int n) {
        this.handleCancellation();
        this.browserPb3.setMaximum(n);
    }

    public void setBrowserPb1Value(int n) {
        this.handleCancellation();
        this.browserPb1.setValue(n);
    }

    public void setBrowserPb2Value(int n) {
        this.handleCancellation();
        this.browserPb2.setValue(n);
    }

    public void setBrowserPb3Value(int n) {
        this.handleCancellation();
        this.browserPb3.setValue(n);
    }

    public String getBrowserStatusText() {
        this.handleCancellation();
        return this.browserStatus.getText();
    }

    public void setHierarchyStatusText(String string) {
        this.handleCancellation();
        this.hierarchyStatus.setText(string);
    }

    public void setHierarchyPb1Maximum(int n) {
        this.handleCancellation();
        this.hierarchyPb1.setMaximum(n);
    }

    public void setHierarchyPb2Maximum(int n) {
        this.handleCancellation();
        this.hierarchyPb2.setMaximum(n);
    }

    public void setHierarchyPb3Maximum(int n) {
        this.handleCancellation();
        this.hierarchyPb3.setMaximum(n);
    }

    public void setHierarchyPb1Value(int n) {
        this.handleCancellation();
        this.hierarchyPb1.setValue(n);
    }

    public void setHierarchyPb2Value(int n) {
        this.handleCancellation();
        this.hierarchyPb2.setValue(n);
    }

    public void setHierarchyPb3Value(int n) {
        this.handleCancellation();
        this.hierarchyPb3.setValue(n);
    }

    public String getHierarchyStatusText() {
        this.handleCancellation();
        return this.hierarchyStatus.getText();
    }

    public int getHierarchyPb2Value() {
        this.handleCancellation();
        return this.hierarchyPb2.getValue();
    }

    public int getHierarchyPb3Value() {
        this.handleCancellation();
        return this.hierarchyPb3.getValue();
    }

    public void setMpdIndexingFieldText(String string) {
        this.handleCancellation();
        this.mpdIndexingField.setText(string);
    }

    public void setMpdPb1Maximum(int n) {
        this.handleCancellation();
        this.mpdPb1.setMaximum(n);
    }

    public void setMpdPb1Value(int n) {
        this.handleCancellation();
        this.mpdPb1.setValue(n);
    }

    public void setFdIndexingStatusText(String string) {
        this.handleCancellation();
        this.fdIndexingStatus.setText(string);
    }

    public void setFdPb1Value(int n) {
        this.handleCancellation();
        this.fdPb1.setValue(n);
    }

    public void setFdPb1Maximum(int n) {
        this.handleCancellation();
        this.fdPb1.setMaximum(n);
    }

    public String getFdIndexingStatusText() {
        this.handleCancellation();
        return this.fdIndexingStatus.getText();
    }

    public void setUpdateStatusText(String string) {
        this.handleCancellation();
        this.updateStatus.setText(string);
    }

    public void setUtcPb1Maximum(int n) {
        this.handleCancellation();
        this.utcPb1.setMaximum(n);
    }

    public void setUtcPb1Value(int n) {
        this.handleCancellation();
        this.utcPb1.setValue(n);
    }

    public String getUpdateStatusText() {
        this.handleCancellation();
        return this.updateStatus.getText();
    }

    public void setIncrementalIndexingText(String string) {
        this.handleCancellation();
        this.incrementalIndexingStatus.setText(string);
    }

    public void setIncrementalPb1Maximum(int n) {
        this.handleCancellation();
        this.incrementalPb1.setMaximum(n);
    }

    public void setIncrementalPb1Value(int n) {
        this.handleCancellation();
        this.incrementalPb1.setValue(n);
    }

    public void setCancelButtonText(String string) {
        this.handleCancellation();
        this.cancelButton.setText(string);
        if (this.taskItem != null) {
            this.taskItem.setTaskItemComplete();
        }
    }

    public void stopTimer() {
        this.handleCancellation();
        if (this.timer != null && this.timer.isRunning()) {
            this.timer.stop();
        }
    }

    public void stopRemainingTimeTimer() {
        this.handleCancellation();
        if (this.remainingTimeTimer != null && this.remainingTimeTimer.isRunning()) {
            this.remainingTimeTimer.stop();
        }
    }

    public void pauseTimer() {
        this.handleCancellation();
        this.startPause = System.currentTimeMillis();
        if (this.timer != null && this.timer.isRunning()) {
            this.timer.stop();
        }
    }

    public void restartTimer() {
        this.handleCancellation();
        this.endPause = System.currentTimeMillis();
        this.totalPause += this.endPause - this.startPause;
        if (this.timer != null && !this.timer.isRunning()) {
            this.timer.start();
        }
    }

    public void pauseRemainingTimeTimer() {
        this.handleCancellation();
        if (this.remainingTimeTimer != null && this.remainingTimeTimer.isRunning()) {
            this.remainingTimeTimer.stop();
        }
    }

    public void restartRemainingTimeTimer() {
        this.handleCancellation();
        if (this.remainingTimeTimer != null && !this.remainingTimeTimer.isRunning()) {
            this.remainingTimeTimer.start();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.timer)) {
            this.timeSpent = System.currentTimeMillis() - this.startTime - this.totalPause;
            this.valueElapsedTime.setText(this.elapsedTime(this.timeSpent));
        }
        if (actionEvent.getSource().equals(this.remainingTimeTimer)) {
            this.timeRemaining = this.startTime + this.expectedTotalTime - System.currentTimeMillis() + this.totalPause;
            this.valueRemainingTime.setText(this.elapsedTime(this.timeRemaining));
        }
    }

    public boolean isTimeRemainingEstimated() {
        return this.timeRemaining != 0L;
    }

    public void reportTime(long l, int n) {
        this.handleCancellation();
        this.numberOfFields = n;
        if (this.reportTimeIncrement == 0) {
            this.field1StartTime = l;
            ++this.reportTimeIncrement;
        } else if (this.reportTimeIncrement == 1) {
            this.field2StartTime = l;
            ++this.reportTimeIncrement;
            this.estimateTimeToCompletionRound1();
        } else {
            ++this.reportTimeIncrement;
        }
    }

    private void estimateTimeToCompletionRound1() {
        this.assignWeights();
        long l = this.field2StartTime - this.field1StartTime;
        long l2 = l * (long)this.numberOfFields;
        double d = 0.0;
        if (this.valueIndexing) {
            d = (double)this.weightValue / 100.0;
        }
        if (!this.valueIndexing && this.termIndexing) {
            d = (double)this.weightTerm / 100.0;
        }
        this.expectedTotalTime = (int)((double)l2 / d);
        this.timeRemaining = this.startTime + this.expectedTotalTime - System.currentTimeMillis();
        this.remainingTimeTimer = new Timer(1000, this);
        this.remainingTimeTimer.start();
    }

    private void assignWeights() {
        if (this.valueIndexing) {
            this.weightValue = 25;
        }
        if (this.termIndexing) {
            this.weightTerm = 25;
        }
        if (this.valueIndexing || this.termIndexing) {
            this.weightDest = 10;
        }
        if (this.browserIndexing) {
            this.weightBrowser = 5;
        }
        if (this.hierarchyIndexing) {
            this.weightHierarchy = 25;
        }
        if (this.multipageDocumentIndexing) {
            this.weightMpd = 5;
        }
        if (this.fuzzyDateIndexing) {
            this.weightFuzzyDate = 5;
        }
        if (this.updateThumbnailCaches) {
            this.weightUtc = 5;
        }
        if (this.sumOfWeights() < 100) {
            this.performWeightCalculation();
        }
    }

    private int sumOfWeights() {
        int n = this.weightValue + this.weightTerm + this.weightDest + this.weightBrowser + this.weightHierarchy + this.weightMpd + this.weightFuzzyDate + this.weightUtc;
        return n;
    }

    private void performWeightCalculation() {
        int n = this.sumOfWeights();
        int n2 = 100 - n;
        int n3 = (this.weightValue == 0 ? 0 : 1) + (this.weightTerm == 0 ? 0 : 1) + (this.weightDest == 0 ? 0 : 1) + (this.weightBrowser == 0 ? 0 : 1) + (this.weightHierarchy == 0 ? 0 : 1) + (this.weightMpd == 0 ? 0 : 1) + (this.weightFuzzyDate == 0 ? 0 : 1) + (this.weightUtc == 0 ? 0 : 1);
        if (this.valueIndexing) {
            this.weightValue += n2 / n3;
        }
        if (this.termIndexing) {
            this.weightTerm += n2 / n3;
        }
        this.weightDest += n2 / n3;
        if (this.browserIndexing) {
            this.weightBrowser += n2 / n3;
        }
        if (this.hierarchyIndexing) {
            this.weightHierarchy += n2 / n3;
        }
        if (this.multipageDocumentIndexing) {
            this.weightMpd += n2 / n3;
        }
        if (this.fuzzyDateIndexing) {
            this.weightFuzzyDate += n2 / n3;
        }
        if (this.updateThumbnailCaches) {
            this.weightUtc += n2 / n3;
        }
    }

    protected String elapsedTime(long l) {
        int n = (int)(l / 1000L);
        return TrinityIndexer.formatTimeString(n);
    }

    public static void debugOut(String string) {
        CsTasksIndexerDisplayDialog.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CsTasksIndexerDisplayDialog: " + string, n);
    }
}

