/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.fieldstd;

import com.luna.insight.admin.AdministeredServerNode;
import com.luna.insight.admin.TableDisplayControlPanelNode;
import com.luna.insight.admin.collserver.CollectionServerNode;
import com.luna.insight.admin.collserver.fieldstd.CsFieldStandard;
import com.luna.insight.admin.collserver.fieldstd.CsFieldStandardField;
import com.luna.insight.admin.collserver.fieldstd.CsFieldStandardNode;
import com.luna.insight.admin.collserver.fieldstd.TypeCodeConverter;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import com.luna.insight.server.SimpleDate;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;

public class CsFieldStandardsNode
extends TableDisplayControlPanelNode {
    protected CollectionServerNode serverNode = null;
    protected Hashtable childNodes = new Hashtable();

    public CsFieldStandardsNode(CollectionServerNode collectionServerNode) {
        super(collectionServerNode.getCollectionServer().getInsightAdministrator(), "Field Standards", true);
        this.serverNode = collectionServerNode;
        this.columnNames = new Object[]{"Standard Name", "Order", "Standard Type", "Description URL", "Created"};
    }

    public void updateInformationDisplay() {
        Vector vector = this.serverNode.getCollectionServer().getFieldStandards();
        this.tableModel.setDataVector(this.getTableData(vector), this.columnNames);
        this.addFieldStandardChildren(vector);
    }

    public void updateFieldStandardParentNode(CsFieldStandardField csFieldStandardField) {
        try {
            ((CsFieldStandardNode)this.childNodes.get(csFieldStandardField.fieldStandard)).updateInformationDisplay();
        }
        catch (Exception exception) {
            CsFieldStandardsNode.debugOut("Exception occurred updating Field Standard Parent Node: " + exception);
        }
    }

    private Object[][] getTableData(Vector vector) {
        Object[][] objectArray = new Object[vector.size()][this.columnNames.length];
        for (int i = 0; vector != null && i < vector.size(); ++i) {
            CsFieldStandard csFieldStandard = (CsFieldStandard)vector.elementAt(i);
            objectArray[i][0] = csFieldStandard;
            objectArray[i][1] = csFieldStandard.orderPosition < 0 ? "" : "" + new Integer(csFieldStandard.orderPosition);
            objectArray[i][2] = TypeCodeConverter.convertFieldStandardType(csFieldStandard.type);
            objectArray[i][3] = csFieldStandard.descriptionUrl;
            objectArray[i][4] = new SimpleDate(csFieldStandard.createdTimestamp).getFull();
        }
        return objectArray;
    }

    public void addFieldStandardChildren() {
        this.addFieldStandardChildren(this.serverNode.getCollectionServer().getFieldStandards());
    }

    private void addFieldStandardChildren(Vector vector) {
        CsFieldStandardsNode.debugOut("in addFieldStandardChildren(" + vector + ")");
        if (vector != null) {
            this.removeAllChildren();
            this.childNodes = new Hashtable();
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                CsFieldStandard csFieldStandard = (CsFieldStandard)iterator.next();
                if (csFieldStandard.getType() == 4) continue;
                CsFieldStandardNode csFieldStandardNode = new CsFieldStandardNode(this.serverNode, csFieldStandard);
                CsFieldStandardsNode.debugOut("Adding node: " + csFieldStandardNode.fieldStandard);
                this.childNodes.put(csFieldStandardNode.fieldStandard, csFieldStandardNode);
                this.add(csFieldStandardNode);
            }
            this.serverNode.getCollectionServer().getInsightAdministrator().treeModelStructureChanged(this);
        }
    }

    public JPopupMenu getPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.serverNode.getAdminAccount().createPermittedServerMenuItem("New field standard", "New Field Standard Command", this.serverNode));
        jPopupMenu.add(this.serverNode.getAdminAccount().createPermittedServerMenuItem("Manage field standard relations", "Editmap-field-standard-fields", this.serverNode));
        return jPopupMenu;
    }

    public boolean hasReadPermission() {
        return this.serverNode.getAdministeredServer().getAdminAccount().hasServerPermission(1);
    }

    public ImageIcon getIcon() {
        if (this.treeIcon == null) {
            this.treeIcon = IconMaker.createImage("images/collection-server-field-standards-node-icon.gif");
        }
        return this.treeIcon;
    }

    public JPopupMenu getDisplayPopupMenu(ActionListener actionListener, int n) {
        return AdministeredServerNode.createServerNodePopupMenu(actionListener, n, this.serverNode.getAdminAccount(), "New field standard", "New Field Standard Command", "Edit field standard", "Edit Field Standard Command", "Delete field standard" + (n > 1 ? "s" : ""), "Delete Field Standard Command");
    }

    public void actionPerformed(String string, Vector vector) {
        CsFieldStandardsNode.debugOut("Received action: " + string);
        if (string.equals("New Field Standard Command")) {
            this.serverNode.createNewFieldStandard();
        } else if (string.equals("Delete Field Standard Command")) {
            if (vector != null && vector.size() > 0) {
                this.serverNode.removeFieldStandards(vector);
            }
        } else if (string.equals("Edit Field Standard Command") && vector != null && vector.size() == 1) {
            this.serverNode.editFieldStandard((CsFieldStandard)vector.firstElement());
        }
    }

    public void defaultItemAction(Object object) {
        if (object != null) {
            this.serverNode.editFieldStandard((CsFieldStandard)object);
        }
    }

    public static void debugOut(String string) {
        CsFieldStandardsNode.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CsFieldStandardsNode: " + string, n);
    }
}

