/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.fieldstd;

import com.luna.insight.admin.TableDisplayControlPanelNode;
import com.luna.insight.admin.collserver.CollectionServerNode;
import com.luna.insight.admin.collserver.fieldstd.CsFieldStandard;
import com.luna.insight.admin.collserver.fieldstd.CsFieldStandardField;
import com.luna.insight.admin.collserver.fieldstd.TypeCodeConverter;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;

public class CsFieldStandardNode
extends TableDisplayControlPanelNode
implements ActionListener {
    protected CollectionServerNode serverNode = null;
    protected CsFieldStandard fieldStandard = null;

    public static void debugOut(String string) {
        CsFieldStandardNode.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CsFieldStandardNode: " + string, n);
    }

    public CsFieldStandardNode(CollectionServerNode collectionServerNode, CsFieldStandard csFieldStandard) {
        super(collectionServerNode.getCollectionServer().getInsightAdministrator(), csFieldStandard.getName(), false);
        this.serverNode = collectionServerNode;
        this.fieldStandard = csFieldStandard;
        this.columnNames = new Object[]{"Name", "Display Name", "Order", "Type", "String type", "Description URL", "Is selectable as thumbnail caption?", "Is sortable?", "Is data field searchable?", "Search Pick Field", "Fuzzy Date Field"};
    }

    public void updateInformationDisplay() {
        this.tableModel.setDataVector(this.getTableData(this.serverNode.getCollectionServer().getFieldStandardFields(this.fieldStandard)), this.columnNames);
    }

    private Object[][] getTableData(Vector vector) {
        Object[][] objectArray = new Object[vector.size()][this.columnNames.length];
        for (int i = 0; vector != null && i < vector.size(); ++i) {
            CsFieldStandardField csFieldStandardField = (CsFieldStandardField)vector.elementAt(i);
            objectArray[i][0] = csFieldStandardField;
            objectArray[i][1] = csFieldStandardField.getFieldDisplayName();
            objectArray[i][2] = new Integer(csFieldStandardField.getDisplayOrder());
            objectArray[i][3] = TypeCodeConverter.convertFieldType(csFieldStandardField.getFieldType());
            objectArray[i][4] = TypeCodeConverter.convertStringType(csFieldStandardField.getStringType());
            objectArray[i][5] = csFieldStandardField.getDescriptionUrl();
            objectArray[i][6] = new Boolean(csFieldStandardField.isDisplayedInThumbnail());
            objectArray[i][7] = new Boolean(csFieldStandardField.isSortable());
            objectArray[i][8] = new Boolean(csFieldStandardField.isDataFieldSearchable());
            objectArray[i][9] = new Boolean(csFieldStandardField.isPicked());
            objectArray[i][10] = new Boolean(csFieldStandardField.isDate());
        }
        return objectArray;
    }

    public JPopupMenu getPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.serverNode.getAdminAccount().createPermittedServerMenuItem("New field standard", "New Field Standard Command", this));
        jPopupMenu.add(this.serverNode.getAdminAccount().createPermittedServerMenuItem("Edit field standard", "Edit Field Standard Command", this));
        jPopupMenu.add(this.serverNode.getAdminAccount().createPermittedServerMenuItem("Delete field standard", "Delete Field Standard Command", this));
        jPopupMenu.add(this.serverNode.getAdminAccount().createPermittedServerMenuItem("Add field to standard", "New-field-standard-field", this));
        return jPopupMenu;
    }

    public boolean hasReadPermission() {
        return this.serverNode.getAdministeredServer().getAdminAccount().hasServerPermission(1);
    }

    public ImageIcon getIcon() {
        if (this.treeIcon == null) {
            this.treeIcon = IconMaker.createImage("images/collection-server-field-standards-node-icon.gif");
        }
        return this.treeIcon;
    }

    public JPopupMenu getDisplayPopupMenu(ActionListener actionListener, int n) {
        return CollectionServerNode.createServerNodePopupMenu(actionListener, n, this.serverNode.getAdminAccount(), "New field", "New-field-standard-field", "Edit field", "Edit-field-standard-field", "Delete field" + (n > 1 ? "s" : ""), "Delete-field-standard-field");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Vector<CsFieldStandard> vector = new Vector<CsFieldStandard>(1);
        vector.add(this.fieldStandard);
        this.actionPerformed(actionEvent.getActionCommand(), vector);
    }

    public void actionPerformed(String string, Vector vector) {
        CsFieldStandardNode.debugOut("Received action: " + string);
        if (string.equals("New Field Standard Command")) {
            this.serverNode.createNewFieldStandard();
        } else if (string.equals("Delete Field Standard Command")) {
            if (vector != null && vector.size() > 0) {
                this.serverNode.removeFieldStandards(vector);
            }
        } else if (string.equals("Edit Field Standard Command")) {
            if (vector != null && vector.size() == 1) {
                this.serverNode.editFieldStandard((CsFieldStandard)vector.firstElement());
            }
        } else if (string.equals("New-field-standard-field")) {
            this.serverNode.createNewFieldStandardField(this.fieldStandard);
        } else if (string.equals("Delete-field-standard-field")) {
            if (vector != null && vector.size() > 0) {
                this.serverNode.removeFieldStandardFields(this, vector);
            }
        } else if (string.equals("Edit-field-standard-field") && vector != null && vector.size() == 1) {
            CsFieldStandardNode.debugOut("actionObjects.firstElement(): " + vector.firstElement());
            this.serverNode.editFieldStandardField((CsFieldStandardField)vector.firstElement());
        }
    }

    public void defaultItemAction(Object object) {
        if (object != null) {
            this.serverNode.editFieldStandardField((CsFieldStandardField)object);
        }
    }
}

