/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.field;

import com.luna.insight.admin.AdministeredServerConnector;
import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.DatabaseRecordHandler;
import com.luna.insight.admin.collserver.CollectionServer;
import com.luna.insight.admin.collserver.field.CollectionServerField;
import com.luna.insight.admin.collserver.field.CollectionServerFieldTableInfo;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.backend.DatabaseConnector;
import com.luna.insight.server.backend.SqlQueryGenerator;
import java.util.HashSet;
import java.util.Vector;

public class CollectionServerFieldRecordHandler
extends DatabaseRecordHandler {
    public static final int JOIN_TYPE_INSIGHT = 1;
    public static final int JOIN_TYPE_INSCRIBE = 2;
    protected Vector tableNames = null;
    protected Vector insightJoinTables = null;
    protected Vector inscribeJoinTables = null;
    Vector hierarchyValues = new Vector();
    Vector fieldGroupNames = new Vector();
    Vector entityTypeNames = new Vector();

    public void clearTableNames() {
        this.tableNames = null;
    }

    public void clearJoinNames(int n) {
        if (n == 2) {
            this.inscribeJoinTables = null;
        } else if (n == 1) {
            this.insightJoinTables = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getJoinNames(int n) {
        if (n == 2 && this.inscribeJoinTables != null) {
            return this.inscribeJoinTables;
        }
        if (n == 1 && this.insightJoinTables != null) {
            return this.insightJoinTables;
        }
        DatabaseConnector databaseConnector = null;
        Vector<CollectionServerFieldTableInfo> vector = new Vector<CollectionServerFieldTableInfo>();
        try {
            databaseConnector = this.getDatabaseConnector();
            String string = "SELECT J.*, T1.TableName AS StartTableName, T2.TableName AS EndTableName FROM ISJOINS J, ISTABLES T1, ISTABLES T2 WHERE (J.StartTableID = T1.TableID AND J.EndTableID=T2.TableID AND J.JoinType=" + n + ")";
            databaseConnector.setQuery(string);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                while (databaseConnector.more()) {
                    int n2 = databaseConnector.getIntegerFieldByName("JoinID");
                    StringBuffer stringBuffer = new StringBuffer(databaseConnector.getFieldByName("StartTableName"));
                    stringBuffer = stringBuffer.append(" => ");
                    stringBuffer = stringBuffer.append(databaseConnector.getFieldByName("EndTableName"));
                    CollectionServerFieldTableInfo collectionServerFieldTableInfo = new CollectionServerFieldTableInfo(n2, stringBuffer.toString());
                    vector.addElement(collectionServerFieldTableInfo);
                    databaseConnector.next();
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
        if (n == 2) {
            this.inscribeJoinTables = vector;
        } else if (n == 1) {
            this.insightJoinTables = vector;
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getTableNames() {
        if (this.tableNames != null) {
            return this.tableNames;
        }
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            this.tableNames = new Vector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("ISTABLES", null, new String[]{"TableName", "TableID"});
            sqlQueryGenerator.addOrderBy("ISTABLES", "TableID");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            databaseConnector.runQuery();
            HashSet<CollectionServerFieldTableInfo> hashSet = new HashSet<CollectionServerFieldTableInfo>();
            if (databaseConnector.more()) {
                while (databaseConnector.more()) {
                    String string;
                    int n = databaseConnector.getIntegerFieldByName("TableID");
                    CollectionServerFieldTableInfo collectionServerFieldTableInfo = new CollectionServerFieldTableInfo(n, string = databaseConnector.getFieldByName("TableName"));
                    if (hashSet.add(collectionServerFieldTableInfo)) {
                        this.tableNames.addElement(collectionServerFieldTableInfo);
                    }
                    databaseConnector.next();
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
        return this.tableNames;
    }

    public CollectionServerFieldRecordHandler(AdministeredServerConnector administeredServerConnector) {
        super(administeredServerConnector);
        this.COMPONENT_CODE = "CollectionServerFieldRecordHandler";
    }

    public void doInsert(DatabaseRecord databaseRecord) {
        this.debugOut("in doInsert()");
        CollectionServerField collectionServerField = (CollectionServerField)databaseRecord;
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            StringBuffer stringBuffer = new StringBuffer("");
            stringBuffer.append("INSERT INTO IRFIELDS ");
            stringBuffer.append("( FieldID, FieldGroupID, DisplayName, ");
            if (collectionServerField.getPreferredFieldName() != null && !collectionServerField.getPreferredFieldName().equals("")) {
                stringBuffer.append("PreferredFieldName, ");
            }
            stringBuffer.append("FieldType, FieldName, TableID, JoinPath, ");
            if (collectionServerField.getGroupingTableId() != 0 && !collectionServerField.getGroupingFieldName().equals("")) {
                stringBuffer.append("GroupingTableId, GroupingFieldName , ");
            }
            stringBuffer.append("DelimiterType, DisplayOrder, ");
            stringBuffer.append("DataFieldSearchable, ");
            stringBuffer.append("KeywordSearchable, DisplayedInData, ");
            stringBuffer.append("SearchPick, LongString, IsDate, HierarchyMode");
            stringBuffer.append(", HierarchyID");
            stringBuffer.append(", SelectListBehavior");
            stringBuffer.append(")");
            stringBuffer.append(" VALUES(");
            stringBuffer.append(collectionServerField.getFieldId() + ", ");
            stringBuffer.append(collectionServerField.getFieldGroupId() + ", ");
            stringBuffer.append("'" + collectionServerField.getDisplayName() + "', ");
            if (collectionServerField.getPreferredFieldName() != null && !collectionServerField.getPreferredFieldName().equals("")) {
                stringBuffer.append("'" + collectionServerField.getPreferredFieldName() + "', ");
            }
            stringBuffer.append(collectionServerField.getFieldType() + ", ");
            stringBuffer.append("'" + collectionServerField.getFieldName() + "', ");
            stringBuffer.append(collectionServerField.getTableId() + ", ");
            stringBuffer.append(collectionServerField.getJoinId() + ", ");
            if (collectionServerField.getGroupingTableId() != 0 && !collectionServerField.getGroupingFieldName().equals("")) {
                stringBuffer.append(collectionServerField.getGroupingTableId() + ", ");
                stringBuffer.append("'" + collectionServerField.getGroupingFieldName() + "', ");
            }
            stringBuffer.append(collectionServerField.getDelimiterType() + ", ");
            stringBuffer.append(collectionServerField.getDisplayOrder() + ", ");
            stringBuffer.append(this.convertToInt(collectionServerField.getDataFieldSearchable()) + ", ");
            stringBuffer.append(this.convertToInt(collectionServerField.getSearchable()) + ", ");
            stringBuffer.append(this.convertToInt(collectionServerField.getDisplayedInData()) + ", ");
            stringBuffer.append(this.convertToInt(collectionServerField.getSearchPick()) + ", ");
            stringBuffer.append(collectionServerField.getStringType() + ", ");
            stringBuffer.append(this.convertToInt(collectionServerField.getIsDate()) + ", ");
            stringBuffer.append(collectionServerField.getHierarchyMode() + "");
            if (collectionServerField.getHierarchyMode() != 0) {
                stringBuffer.append(", " + collectionServerField.getHierarchyId());
            } else {
                stringBuffer.append(", 0");
            }
            stringBuffer.append(", " + collectionServerField.selectListSetting);
            stringBuffer.append(")");
            databaseConnector.setQuery(stringBuffer.toString());
            this.debugOut("insertField DML statement: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
            if (collectionServerField.isNewField) {
                databaseConnector = this.getDatabaseConnector();
                StringBuffer stringBuffer2 = new StringBuffer();
                StringBuffer stringBuffer3 = new StringBuffer();
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGeneratorUtil();
                sqlQueryGenerator.appendFieldAndValue(stringBuffer2, "EntityTypeID", 2, stringBuffer3, collectionServerField.getEntityTypeId());
                sqlQueryGenerator.appendFieldAndValue(stringBuffer2, "FieldID", 2, stringBuffer3, collectionServerField.getFieldId());
                sqlQueryGenerator.appendFieldAndValue(stringBuffer2, "FieldTableID", 2, stringBuffer3, collectionServerField.getTableId());
                sqlQueryGenerator.appendFieldAndValue(stringBuffer2, "JoinID", 2, stringBuffer3, collectionServerField.getJoinId());
                String string = "INSERT INTO ISENTITYFIELDS (" + stringBuffer2 + ") VALUES (" + stringBuffer3 + ")";
                databaseConnector.setQuery(string);
                this.debugOut("insertEntityField DML statement: \n" + databaseConnector.getQuery(), 3);
                databaseConnector.runUpdateQuery();
                databaseConnector.close();
                collectionServerField.isNewField = false;
            } else {
                databaseConnector = this.getDatabaseConnector();
                databaseConnector.setQuery("UPDATE ISENTITYFIELDS SET FieldTableID = " + collectionServerField.getTableId() + ", JoinID = " + collectionServerField.getJoinId() + " WHERE FieldID = " + collectionServerField.getFieldId());
                databaseConnector.runUpdateQuery();
                databaseConnector.close();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in doInsert(): " + exception);
        }
    }

    public void doDelete(DatabaseRecord databaseRecord) {
        this.debugOut("in doDelete()");
        CollectionServerField collectionServerField = (CollectionServerField)databaseRecord;
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            String string = "DELETE FROM IRFIELDS WHERE FieldID = " + collectionServerField.getIndex();
            databaseConnector.setQuery(string);
            this.debugOut("deleteField DML: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
            if (collectionServerField.getDeleteMode() == CollectionServerField.DELETE_MODE_DELETE) {
                String string2 = "DELETE FROM ISENTITYFIELDS WHERE FieldID = " + collectionServerField.getIndex();
                databaseConnector = this.getDatabaseConnector();
                databaseConnector.setQuery(string2);
                this.debugOut("deleteEntityFieldQuery query: \n" + databaseConnector.getQuery(), 3);
                databaseConnector.runUpdateQuery();
                databaseConnector.close();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in doDelete(): " + exception);
        }
    }

    public Vector getRecords() {
        return this.getRecords(null);
    }

    public Vector getRecords(Integer n) {
        CollectionServerFieldTableInfo collectionServerFieldTableInfo;
        String string;
        int n2;
        SqlQueryGenerator sqlQueryGenerator;
        this.debugOut("in getRecords()");
        Vector<CollectionServerField> vector = new Vector<CollectionServerField>();
        int n3 = -1;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        int n10 = -1;
        int n11 = -1;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        int n12 = -1;
        int n13 = -1;
        String string5 = "";
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            this.hierarchyValues = new Vector();
            sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("ISHIERARCHIES", null, new String[]{"HierarchyName", "HierarchyID"});
            sqlQueryGenerator.addOrderBy("ISHIERARCHIES", "HierarchyID");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Hierarchies query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                while (databaseConnector.more()) {
                    n2 = databaseConnector.getIntegerFieldByName("HierarchyID");
                    string = databaseConnector.getFieldByName("HierarchyName");
                    collectionServerFieldTableInfo = new CollectionServerFieldTableInfo(n2, string);
                    this.hierarchyValues.addElement(collectionServerFieldTableInfo);
                    databaseConnector.next();
                }
            }
        }
        catch (Exception exception) {
            this.debugOut("Caught exception: " + exception);
        }
        databaseConnector.close();
        databaseConnector = this.getDatabaseConnector();
        try {
            this.entityTypeNames = new Vector();
            sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("ISENTITYTYPES", null, "*");
            sqlQueryGenerator.addJoin("ISENTITYTYPES", "ISTEMPLATEENTITYTYPEMAP", "EntityTypeID", 0);
            sqlQueryGenerator.appendToWhere("ISTEMPLATEENTITYTYPEMAP.TemplateID = " + n);
            sqlQueryGenerator.addOrderBy("ISENTITYTYPES", "EntityTypeID");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Record types query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                while (databaseConnector.more()) {
                    n2 = databaseConnector.getIntegerFieldByName("EntityTypeID");
                    string = databaseConnector.getFieldByName("EntityTypeDisplayName");
                    collectionServerFieldTableInfo = new CollectionServerFieldTableInfo(n2, string);
                    this.entityTypeNames.addElement(collectionServerFieldTableInfo);
                    databaseConnector.next();
                }
            }
        }
        catch (Exception exception) {
            this.debugOut("Caught exception: " + exception);
        }
        databaseConnector.close();
        databaseConnector = this.getDatabaseConnector();
        try {
            this.fieldGroupNames = new Vector();
            sqlQueryGenerator = this.getQueryGenerator();
            String string6 = "SELECT * FROM IRFIELDGROUPS WHERE (FieldGroupID NOT IN (SELECT DISTINCT FieldGroupID FROM IRFIELDS)) OR (FieldGroupID IN (SELECT DISTINCT FieldGroupID FROM IRFIELDS, ISENTITYFIELDS, ISTEMPLATEENTITYTYPEMAP WHERE IRFIELDS.FieldID = ISENTITYFIELDS.FieldID AND ISENTITYFIELDS.EntityTypeID = ISTEMPLATEENTITYTYPEMAP.EntityTypeID AND TemplateID = " + n + ")) ORDER BY " + "IRFIELDGROUPS" + ".FieldGroupID";
            databaseConnector.setQuery(string6);
            this.debugOut("FieldGroups query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                while (databaseConnector.more()) {
                    int n14 = databaseConnector.getIntegerFieldByName("FieldGroupID");
                    string3 = databaseConnector.getFieldByName("DisplayName");
                    n12 = databaseConnector.getIntegerFieldByName("DisplayOrder");
                    collectionServerFieldTableInfo = new CollectionServerFieldTableInfo(n14, string3);
                    collectionServerFieldTableInfo.setDisplayOrder(n12);
                    this.fieldGroupNames.addElement(collectionServerFieldTableInfo);
                    databaseConnector.next();
                }
            }
        }
        catch (Exception exception) {
            this.debugOut("Caught exception: " + exception);
        }
        databaseConnector.close();
        databaseConnector = this.getDatabaseConnector();
        try {
            sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("IRFIELDS", null, "*");
            sqlQueryGenerator.addIsolatedSelection("IRFIELDS.FieldID AS ofid");
            sqlQueryGenerator.addJoin("IRFIELDS", "ISENTITYFIELDS", "FieldID", 0);
            sqlQueryGenerator.addJoin("ISENTITYFIELDS", "ISTEMPLATEENTITYTYPEMAP", "EntityTypeID", 0);
            sqlQueryGenerator.appendToWhere("ISTEMPLATEENTITYTYPEMAP.TemplateID = " + n);
            String string7 = "SELECT * FROM (SELECT IRFIELDS.*, FieldID as ofid FROM IRFIELDS WHERE (FieldID NOT IN (SELECT FieldID FROM ISENTITYFIELDS)) UNION " + sqlQueryGenerator.getQuery() + ") MaxUnion ORDER BY ofid";
            databaseConnector.setQuery(string7);
            this.debugOut("Fields query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                while (databaseConnector.more()) {
                    CollectionServerField collectionServerField = null;
                    int n15 = 0;
                    try {
                        n3 = databaseConnector.getIntegerFieldByName("FieldID");
                        string2 = databaseConnector.getFieldByName("FieldName");
                        string3 = databaseConnector.getFieldByName("DisplayName");
                        try {
                            string4 = databaseConnector.getFieldByName("PreferredFieldName");
                        }
                        catch (Exception exception) {
                            string4 = "";
                        }
                        n4 = databaseConnector.getIntegerFieldByName("FieldGroupID");
                        n5 = databaseConnector.getIntegerFieldByName("DelimiterType");
                        n6 = databaseConnector.getIntegerFieldByName("LongString");
                        n7 = databaseConnector.getIntegerFieldByName("TableID");
                        n8 = databaseConnector.getIntegerFieldByName("JoinPath");
                        n9 = databaseConnector.getIntegerFieldByName("HierarchyMode");
                        n10 = databaseConnector.getIntegerFieldByName("HierarchyID");
                        bl = this.convertToBoolean(databaseConnector.getIntegerFieldByName("KeywordSearchable"));
                        bl2 = this.convertToBoolean(databaseConnector.getIntegerFieldByName("DisplayedInData"));
                        bl3 = this.convertToBoolean(databaseConnector.getIntegerFieldByName("SearchPick"));
                        n11 = databaseConnector.getIntegerFieldByName("FieldType");
                        bl5 = this.convertToBoolean(databaseConnector.getIntegerFieldByName("DataFieldSearchable"));
                        bl6 = this.convertToBoolean(databaseConnector.getIntegerFieldByName("IsDate"));
                        n12 = databaseConnector.getIntegerFieldByName("DisplayOrder");
                        try {
                            n13 = databaseConnector.getIntegerFieldByName("GroupingTableID");
                            string5 = databaseConnector.getFieldByName("GroupingFieldName");
                        }
                        catch (Exception exception) {
                            this.debugOut("GroupingTableID and GroupingFieldName do not exist");
                        }
                        n15 = databaseConnector.getIntegerFieldByName("SelectListBehavior");
                    }
                    catch (Exception exception) {
                        this.debugOut("Exception in get record: " + exception);
                    }
                    collectionServerField = new CollectionServerField(((CollectionServer)this.serverConnector.getAdministeredServer()).getServerNode().getCatalogTemplateNode(n).getTemplate(), n3, string2, string3, string4, n4, n5, n6, n7, n8, n9, n10, bl, bl2, bl3, bl4, n11, bl5, bl6, n12, n13, string5, this.getTableNames(), this.hierarchyValues, this.getJoinNames(1), this.fieldGroupNames);
                    collectionServerField.setSelectListSettings(n15);
                    if (collectionServerField != null) {
                        vector.addElement(collectionServerField);
                    }
                    databaseConnector.next();
                }
            }
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getRecord, and end of method");
        }
        return vector;
    }

    public DatabaseRecord getRecord(DatabaseRecord databaseRecord) {
        this.debugOut("in getRecord(record)");
        int n = -1;
        String string = "";
        String string2 = "";
        String string3 = "";
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = 0;
        int n8 = -1;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n9 = -1;
        boolean bl5 = false;
        boolean bl6 = false;
        int n10 = -1;
        int n11 = -1;
        String string4 = "";
        int n12 = 0;
        CollectionServerField collectionServerField = null;
        n = databaseRecord.getIndex();
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
        sqlQueryGenerator.addTable("IRFIELDS", null, "*");
        sqlQueryGenerator.appendToWhere("FieldID = " + ((CollectionServerField)databaseRecord).getFieldId());
        sqlQueryGenerator.addOrderBy("IRFIELDS", "FieldID");
        databaseConnector.setQuery(sqlQueryGenerator.getQuery());
        this.debugOut("CollectionServer field query: \n" + databaseConnector.getQuery(), 3);
        databaseConnector.runQuery();
        if (databaseConnector.more() && collectionServerField == null) {
            try {
                n = databaseConnector.getIntegerFieldByName("FieldID");
                string = databaseConnector.getFieldByName("FieldName");
                string2 = databaseConnector.getFieldByName("DisplayName");
                try {
                    string3 = databaseConnector.getFieldByName("PreferredFieldName");
                }
                catch (Exception exception) {
                    string3 = "";
                }
                n2 = databaseConnector.getIntegerFieldByName("FieldGroupID");
                n3 = databaseConnector.getIntegerFieldByName("DelimiterType");
                n4 = databaseConnector.getIntegerFieldByName("LongString");
                n5 = databaseConnector.getIntegerFieldByName("TableID");
                n6 = databaseConnector.getIntegerFieldByName("JoinPath");
                n7 = databaseConnector.getIntegerFieldByName("HierarchyMode");
                n8 = databaseConnector.getIntegerFieldByName("HierarchyID");
                bl = this.convertToBoolean(databaseConnector.getIntegerFieldByName("KeywordSearchable"));
                bl2 = this.convertToBoolean(databaseConnector.getIntegerFieldByName("DisplayedInData"));
                bl3 = this.convertToBoolean(databaseConnector.getIntegerFieldByName("SearchPick"));
                n9 = databaseConnector.getIntegerFieldByName("FieldType");
                bl5 = this.convertToBoolean(databaseConnector.getIntegerFieldByName("DataFieldSearchable"));
                bl6 = this.convertToBoolean(databaseConnector.getIntegerFieldByName("IsDate"));
                n10 = databaseConnector.getIntegerFieldByName("DisplayOrder");
                try {
                    n11 = databaseConnector.getIntegerFieldByName("GroupingTableID");
                    string4 = databaseConnector.getFieldByName("GroupingFieldName");
                }
                catch (Exception exception) {
                    this.debugOut("GroupingTableID and GroupingFieldName do not exist");
                }
                n12 = databaseConnector.getIntegerFieldByName("SelectListBehavior");
            }
            catch (Exception exception) {
                this.debugOut("Caught exception in getRecord(record)");
            }
            collectionServerField = new CollectionServerField(((CollectionServerField)databaseRecord).getTemplate(), n, string, string2, string3, n2, n3, n4, n5, n6, n7, n8, bl, bl2, bl3, bl4, n9, bl5, bl6, n10, n11, string4, this.getTableNames(), this.hierarchyValues, this.getJoinNames(1), this.fieldGroupNames);
            collectionServerField.setSelectListSettings(n12);
        }
        databaseConnector.close();
        return collectionServerField;
    }

    public Vector getHierarchyValues() {
        return this.hierarchyValues;
    }

    public Vector getFieldGroupNames() {
        return this.fieldGroupNames;
    }

    public Vector getEntityTypeNames() {
        return this.entityTypeNames;
    }

    public String getNextValidIDQuery() {
        return "SELECT " + AdministeredServerConnector.CANDIDATE_INDEX_NAME + " FROM (SELECT FieldGroupID AS " + AdministeredServerConnector.CANDIDATE_INDEX_NAME + " FROM " + "IRFIELDGROUPS" + " UNION SELECT EntityTypeID AS " + AdministeredServerConnector.CANDIDATE_INDEX_NAME + " FROM " + "ISENTITYTYPES" + " UNION SELECT FieldID AS " + AdministeredServerConnector.CANDIDATE_INDEX_NAME + " FROM " + "IRFIELDS" + " UNION SELECT FieldID AS " + AdministeredServerConnector.CANDIDATE_INDEX_NAME + " FROM " + "ISENTITYFIELDS" + ") MaxUnion ORDER BY " + AdministeredServerConnector.CANDIDATE_INDEX_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMaxIDValue(long l) {
        DatabaseConnector databaseConnector = null;
        try {
            databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("IRMAXIDS", null, new String[]{"MaxFieldID"});
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            databaseConnector.runQuery();
            int n = 0;
            if (databaseConnector.more()) {
                n = databaseConnector.getIntegerField("MaxFieldID", 0);
            }
            databaseConnector.close();
            if (l > (long)n && n != 0) {
                databaseConnector = this.getDatabaseConnector();
                databaseConnector.setQuery("UPDATE IRMAXIDS SET MaxFieldID = " + l);
                databaseConnector.runUpdateQuery();
                databaseConnector.close();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in updateMaxIDValue():\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
    }
}

