/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.field;

import com.luna.insight.admin.AdministeredServerNode;
import com.luna.insight.admin.TableDisplayControlPanelNode;
import com.luna.insight.admin.catalog.CatalogTemplateNode;
import com.luna.insight.admin.collserver.field.CollectionServerFieldGroup;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;

public class CollectionServerFieldGroupsNode
extends TableDisplayControlPanelNode {
    protected CatalogTemplateNode catalogTemplateNode = null;

    public CollectionServerFieldGroupsNode(CatalogTemplateNode catalogTemplateNode) {
        super(catalogTemplateNode.getCollectionServerNode().getCollectionServer().getInsightAdministrator(), "Field Groups", false);
        this.catalogTemplateNode = catalogTemplateNode;
        this.columnNames = new Object[]{"Display Name", "Field Group Type", "Display Order"};
    }

    public void updateInformationDisplay() {
        Integer n = this.catalogTemplateNode.getTemplate().getTemplateID();
        this.tableModel.setDataVector(this.getTableData(this.catalogTemplateNode.getCollectionServerNode().getCollectionServer().getFieldGroups(n)), this.columnNames);
    }

    private Object[][] getTableData(Vector vector) {
        Object[][] objectArray = new Object[vector.size()][this.columnNames.length];
        for (int i = 0; i < vector.size(); ++i) {
            CollectionServerFieldGroup collectionServerFieldGroup = (CollectionServerFieldGroup)vector.elementAt(i);
            objectArray[i][0] = collectionServerFieldGroup;
            objectArray[i][1] = "" + collectionServerFieldGroup.fieldGroupType;
            objectArray[i][2] = new Integer(collectionServerFieldGroup.displayOrder);
        }
        return objectArray;
    }

    public JPopupMenu getPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.catalogTemplateNode.getCollectionServerNode().getAdminAccount().createPermittedServerMenuItem("New...", "New Field Group Command", this.catalogTemplateNode));
        return jPopupMenu;
    }

    public boolean hasReadPermission() {
        return this.catalogTemplateNode.getCollectionServerNode().getAdministeredServer().getAdminAccount().hasServerPermission(1);
    }

    public ImageIcon getIcon() {
        if (this.treeIcon == null) {
            this.treeIcon = IconMaker.createImage("images/collection-server-field-groups-node-icon.gif");
        }
        return this.treeIcon;
    }

    public JPopupMenu getDisplayPopupMenu(ActionListener actionListener, int n) {
        return AdministeredServerNode.createServerNodePopupMenu(actionListener, n, this.catalogTemplateNode.getCollectionServerNode().getAdminAccount(), "New Field Group Command", "Edit Field Group Command", "Delete Field Group Command");
    }

    public void actionPerformed(String string, Vector vector) {
        if (string.equals("New Field Group Command")) {
            this.catalogTemplateNode.getCollectionServerNode().createNewFieldGroup(this.catalogTemplateNode.getTemplate().getTemplateID());
        } else if (string.equals("Delete Field Group Command")) {
            if (vector != null && vector.size() > 0) {
                this.catalogTemplateNode.getCollectionServerNode().removeFieldGroups(vector);
            }
        } else if (string.equals("Edit Field Group Command") && vector != null && vector.size() == 1) {
            this.catalogTemplateNode.getCollectionServerNode().editFieldGroup((CollectionServerFieldGroup)vector.firstElement());
        }
    }

    public void defaultItemAction(Object object) {
        if (object != null) {
            this.catalogTemplateNode.getCollectionServerNode().editFieldGroup((CollectionServerFieldGroup)object);
        }
    }

    public static void debugOut(String string) {
        CollectionServerFieldGroupsNode.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CollectionServerFieldGroupsNode: " + string, n);
    }
}

