/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.config;

import com.luna.insight.admin.AdministeredServerNode;
import com.luna.insight.admin.TableDisplayControlPanelNode;
import com.luna.insight.admin.collserver.collection.CollectionNode;
import com.luna.insight.admin.collserver.config.CollectionServerConfiguration;
import com.luna.insight.admin.collserver.field.CollectionServerField;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import com.luna.insight.server.SimpleDate;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;

public class CollectionServerConfigurationNode
extends TableDisplayControlPanelNode {
    protected CollectionNode collectionNode;

    public CollectionServerConfigurationNode(CollectionNode collectionNode) {
        super(collectionNode.getCollectionServerNode().getCollectionServer().getInsightAdministrator(), "Collection Configuration", false);
        this.collectionNode = collectionNode;
        this.columnNames = new Object[]{"Institution ID", "Collection ID", "VC ID", "Collection Name", "Initial Activity", "Initial Group Open", "Display Artist Stories", "Vertical Bar X", "Horizontal Bar Y", "BG Color R", "BG Color G", "BG Color B", "User Collection", "Large Thumbnail Threshold", "Default View Resolution", "Group Top Inset", "Group Left Inset", "Group Spacing H", "Group Spacing V", "Menu X Position", "Max Windows", "Interwindow Spacing", "Min Image Window Width", "Min Image Window Height", "Drag Speed Coefficient", "Default Sort Field 1", "Default Sort Field 2", "Default Sort Field 3", "Default Sort Field 4", "Iniital Group ROnly", "Help Group", "Help Image", "Simultaneous IW Loads", "Simultaneous GW Loads", "Mac Width Adjustment", "Thumb Data Field 1", "Thumb Data Field 2", "Thumb Data Field 3", "Thumb Data Field 4", "BG URL", "Fast Scaling", "Short Description", "Long Description URL", "Browser RTL URL", "Browser RTL Image", "Web Initiated JVA URL", "Web Initiated JVA HTML Template", "Thumb Cache Profile ID", "Created"};
    }

    public void updateInformationDisplay() {
        Integer n = this.collectionNode.getCollection().getUniqueCollectionID();
        this.tableModel.setDataVector(this.getTableData(this.collectionNode.getCollectionServerNode().getCollectionServer().getConfigurations(n, false)), this.columnNames);
        try {
            this.collectionNode.getCollectionServerNode().profileNode.refreshChildNodes();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Object[][] getTableData(Vector vector) {
        Object[][] objectArray = new Object[vector.size()][this.columnNames.length];
        Vector vector2 = this.collectionNode.getCollectionServerNode().getCollectionServer().getFields(this.collectionNode.getCollection().getTemplateID());
        for (int i = 0; i < vector.size(); ++i) {
            CollectionServerConfiguration collectionServerConfiguration = (CollectionServerConfiguration)vector.elementAt(i);
            objectArray[i][0] = collectionServerConfiguration;
            objectArray[i][1] = collectionServerConfiguration.collectionID;
            objectArray[i][2] = collectionServerConfiguration.vcID;
            objectArray[i][3] = collectionServerConfiguration.collectionName;
            objectArray[i][4] = "" + collectionServerConfiguration.initialActivity;
            objectArray[i][5] = collectionServerConfiguration.initialGroupOpen;
            objectArray[i][6] = collectionServerConfiguration.displayArtistStories == 1 ? new Boolean(true) : new Boolean(false);
            objectArray[i][7] = "" + collectionServerConfiguration.getVerticalBarX();
            objectArray[i][8] = "" + collectionServerConfiguration.getHorizontalBarY();
            objectArray[i][9] = "" + collectionServerConfiguration.getBackgroundColorR();
            objectArray[i][10] = "" + collectionServerConfiguration.getBackgroundColorG();
            objectArray[i][11] = "" + collectionServerConfiguration.getBackgroundColorB();
            objectArray[i][12] = "" + collectionServerConfiguration.getUserCollection();
            objectArray[i][13] = "" + collectionServerConfiguration.largeThumbnailThreshold;
            objectArray[i][14] = "" + collectionServerConfiguration.getDefaultViewResolution();
            objectArray[i][15] = "" + collectionServerConfiguration.getGroupTopInset();
            objectArray[i][16] = "" + collectionServerConfiguration.getGroupLeftInset();
            objectArray[i][17] = "" + collectionServerConfiguration.getGroupSpacingH();
            objectArray[i][18] = "" + collectionServerConfiguration.getGroupSpacingV();
            objectArray[i][19] = "" + collectionServerConfiguration.getMenuXPosition();
            objectArray[i][20] = "" + collectionServerConfiguration.getMaximumWindows();
            objectArray[i][21] = "" + collectionServerConfiguration.getInterWindowSpacing();
            objectArray[i][22] = "" + collectionServerConfiguration.getMinImageWindowSizeWidth();
            objectArray[i][23] = "" + collectionServerConfiguration.getMinImageWindowSizeHeight();
            objectArray[i][24] = "" + collectionServerConfiguration.dragSpeedCoefficient;
            objectArray[i][25] = "";
            objectArray[i][26] = "";
            objectArray[i][27] = "";
            objectArray[i][28] = "";
            objectArray[i][35] = "";
            objectArray[i][36] = "";
            objectArray[i][37] = "";
            objectArray[i][38] = "";
            for (int j = 0; j < vector2.size(); ++j) {
                CollectionServerField collectionServerField = (CollectionServerField)vector2.elementAt(j);
                int n = collectionServerField.getFieldId();
                String string = collectionServerField.getFieldName();
                if (collectionServerConfiguration.getSort1FieldID() == n) {
                    objectArray[i][25] = string;
                }
                if (collectionServerConfiguration.getSort2FieldID() == n) {
                    objectArray[i][26] = string;
                }
                if (collectionServerConfiguration.getSort3FieldID() == n) {
                    objectArray[i][27] = string;
                }
                if (collectionServerConfiguration.getSort4FieldID() == n) {
                    objectArray[i][28] = string;
                }
                if (collectionServerConfiguration.getThumbnail1FieldID() == n) {
                    objectArray[i][35] = string;
                }
                if (collectionServerConfiguration.getThumbnail2FieldID() == n) {
                    objectArray[i][36] = string;
                }
                if (collectionServerConfiguration.getThumbnail3FieldID() == n) {
                    objectArray[i][37] = string;
                }
                if (collectionServerConfiguration.getThumbnail4FieldID() != n) continue;
                objectArray[i][38] = string;
            }
            objectArray[i][29] = collectionServerConfiguration.initialGroupROnly == 1 ? new Boolean(true) : new Boolean(false);
            objectArray[i][30] = collectionServerConfiguration.helpGroup;
            objectArray[i][31] = collectionServerConfiguration.helpImage;
            objectArray[i][32] = "" + collectionServerConfiguration.simultaneousIWLoads;
            objectArray[i][33] = "" + collectionServerConfiguration.simultaneousGWLoads;
            objectArray[i][34] = "" + collectionServerConfiguration.getMacWidthAdjustment();
            objectArray[i][39] = "" + collectionServerConfiguration.getBgUrl();
            objectArray[i][40] = collectionServerConfiguration.fastScaling == 1 ? new Boolean(true) : new Boolean(false);
            objectArray[i][41] = collectionServerConfiguration.shortDescription;
            objectArray[i][42] = collectionServerConfiguration.longDescriptionUrl;
            objectArray[i][43] = collectionServerConfiguration.getRtlUrl();
            objectArray[i][44] = collectionServerConfiguration.getRtlImage();
            objectArray[i][45] = "" + collectionServerConfiguration.remoteLaunchBaseURL;
            objectArray[i][46] = "" + collectionServerConfiguration.remoteLaunchHyperlinkTemplate;
            objectArray[i][47] = "" + collectionServerConfiguration.getThumbCacheProfileId();
            objectArray[i][48] = new SimpleDate(collectionServerConfiguration.createdTimestamp).getFull();
        }
        return objectArray;
    }

    public JPopupMenu getPopup() {
        if (this.collectionNode.getCollection().isPersonalCollection()) {
            return null;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.collectionNode.getCollectionServerNode().getAdminAccount().createPermittedServerMenuItem("New...", "New Configuration Command", this.collectionNode));
        return jPopupMenu;
    }

    public boolean hasReadPermission() {
        return this.collectionNode.getCollectionServerNode().getAdministeredServer().getAdminAccount().hasServerPermission(1);
    }

    public ImageIcon getIcon() {
        if (this.treeIcon == null) {
            this.treeIcon = IconMaker.createImage("images/collection-server-configurations-node-icon.gif");
        }
        return this.treeIcon;
    }

    public JPopupMenu getDisplayPopupMenu(ActionListener actionListener, int n) {
        boolean bl = this.collectionNode.getCollection().isPersonalCollection();
        return AdministeredServerNode.createServerNodePopupMenu(actionListener, n, this.collectionNode.getCollectionServerNode().getAdminAccount(), bl ? "Convert to institutional collection" : "New", bl ? "New Configuration Conversion Command" : "New Configuration Command", "Edit", "Edit Configuration Command", "Delete", "Delete Configuration Command");
    }

    public void actionPerformed(String string, Vector vector) {
        if (string.equals("New Configuration Command")) {
            this.collectionNode.getCollectionServerNode().createNewConfiguration(this.collectionNode.getCollection().getUniqueCollectionID());
        } else if (string.equals("Delete Configuration Command")) {
            if (vector != null && vector.size() > 0) {
                this.collectionNode.getCollectionServerNode().removeConfigurations(vector);
            }
        } else if (string.equals("Edit Configuration Command")) {
            if (vector != null && vector.size() == 1) {
                this.collectionNode.getCollectionServerNode().editConfiguration((CollectionServerConfiguration)vector.firstElement());
            }
        } else if (string.equals("New Configuration Conversion Command") && vector != null && vector.size() == 1) {
            this.collectionNode.getCollectionServerNode().convertPersonalToInstitutionalCollection((CollectionServerConfiguration)vector.firstElement());
        }
    }

    public void defaultItemAction(Object object) {
        if (object != null) {
            this.collectionNode.getCollectionServerNode().editConfiguration((CollectionServerConfiguration)object);
        }
    }

    public static void debugOut(String string) {
        CollectionServerConfigurationNode.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CollectionServerConfigurationNode: " + string, n);
    }
}

