/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.config;

import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.IndexedObject;
import com.luna.insight.admin.collserver.config.CollectionServerConfiguration;
import com.luna.insight.admin.collserver.config.CollectionServerConfigurationBrowserEditComponent;
import com.luna.insight.admin.collserver.field.CollectionServerField;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;

public class CollectionServerConfigurationBrowserAttributes
extends EditableDataObject
implements IndexedObject,
DatabaseRecord {
    public CollectionServerConfiguration collectionServerConfiguration;
    protected int thumbnail1FieldID = 0;
    protected int thumbnail2FieldID = 0;
    protected int thumbnail3FieldID = 0;
    protected int thumbnail4FieldID = 0;
    protected int sort1FieldID = 0;
    protected int sort2FieldID = 0;
    protected int sort3FieldID = 0;
    protected int sort4FieldID = 0;
    protected String rtlUrl = "";
    protected String rtlImage = "";
    protected String bgLoading = "";
    protected String bgMenu = "";
    protected String bgProgressOn = "";
    protected String bgProgressOff = "";
    protected String bgGroupLeft = "";
    protected String bgGroupLeftNS = "";
    protected String bgGroupRight = "";
    protected String bgGWBottom = "";
    protected String bgGWTop = "";
    protected String bgGroupLeftHtml = "";
    protected boolean browserSecurity = false;
    protected CollectionServerConfigurationBrowserEditComponent editComponent = null;

    public CollectionServerConfigurationBrowserAttributes(CollectionServerConfiguration collectionServerConfiguration) {
        this.collectionServerConfiguration = collectionServerConfiguration;
    }

    public CollectionServerConfigurationBrowserAttributes(CollectionServerConfiguration collectionServerConfiguration, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, boolean bl) {
        this.collectionServerConfiguration = collectionServerConfiguration;
        this.thumbnail1FieldID = n;
        this.thumbnail2FieldID = n2;
        this.thumbnail3FieldID = n3;
        this.thumbnail4FieldID = n4;
        this.sort1FieldID = n5;
        this.sort2FieldID = n6;
        this.sort3FieldID = n7;
        this.sort4FieldID = n8;
        this.rtlUrl = string;
        this.rtlImage = string2;
        this.bgLoading = string3;
        this.bgMenu = string4;
        this.bgProgressOn = string5;
        this.bgProgressOff = string6;
        this.bgGroupLeft = string7;
        this.bgGroupLeftNS = string8;
        this.bgGroupRight = string9;
        this.bgGWBottom = string10;
        this.bgGWTop = string11;
        this.bgGroupLeftHtml = string12;
        this.browserSecurity = bl;
    }

    public void setBrowserAttributes(Hashtable hashtable) {
        this.thumbnail1FieldID = hashtable.get("thumbnail1FieldID") != null ? (Integer)hashtable.get("thumbnail1FieldID") : 0;
        this.thumbnail2FieldID = hashtable.get("thumbnail2FieldID") != null ? (Integer)hashtable.get("thumbnail2FieldID") : 0;
        this.thumbnail3FieldID = hashtable.get("thumbnail3FieldID") != null ? (Integer)hashtable.get("thumbnail3FieldID") : 0;
        this.thumbnail4FieldID = hashtable.get("thumbnail4FieldID") != null ? (Integer)hashtable.get("thumbnail4FieldID") : 0;
        this.sort1FieldID = hashtable.get("sort1FieldID") != null ? (Integer)hashtable.get("sort1FieldID") : 0;
        this.sort2FieldID = hashtable.get("sort2FieldID") != null ? (Integer)hashtable.get("sort2FieldID") : 0;
        this.sort3FieldID = hashtable.get("sort3FieldID") != null ? (Integer)hashtable.get("sort3FieldID") : 0;
        this.sort4FieldID = hashtable.get("sort4FieldID") != null ? (Integer)hashtable.get("sort4FieldID") : 0;
        this.rtlUrl = hashtable.get("rtlUrl") != null ? (String)hashtable.get("rtlUrl") : "";
        this.rtlImage = hashtable.get("rtlImage") != null ? (String)hashtable.get("rtlImage") : "";
        this.bgLoading = hashtable.get("bgLoading") != null ? (String)hashtable.get("bgLoading") : "";
        this.bgMenu = hashtable.get("bgMenu") != null ? (String)hashtable.get("bgMenu") : "";
        this.bgProgressOn = hashtable.get("bgProgressOn") != null ? (String)hashtable.get("bgProgressOn") : "";
        this.bgProgressOff = hashtable.get("bgProgressOff") != null ? (String)hashtable.get("bgProgressOff") : "";
        this.bgGroupLeft = hashtable.get("bgGroupLeft") != null ? (String)hashtable.get("bgGroupLeft") : "";
        this.bgGroupLeftNS = hashtable.get("bgGroupLeftNS") != null ? (String)hashtable.get("bgGroupLeftNS") : "";
        this.bgGroupRight = hashtable.get("bgGroupRight") != null ? (String)hashtable.get("bgGroupRight") : "";
        this.bgGWBottom = hashtable.get("bgGWBottom") != null ? (String)hashtable.get("bgGWBottom") : "";
        this.bgGWTop = hashtable.get("bgGWTop") != null ? (String)hashtable.get("bgGWTop") : "";
        this.bgGroupLeftHtml = hashtable.get("bgGroupLeftHtml") != null ? (String)hashtable.get("bgGroupLeftHtml") : "";
        this.browserSecurity = hashtable.get("browserSecurity") != null ? (Boolean)hashtable.get("browserSecurity") : false;
    }

    public String toString() {
        return this.collectionServerConfiguration != null ? this.collectionServerConfiguration.institutionID : "";
    }

    public String getName() {
        return this.collectionServerConfiguration != null ? this.collectionServerConfiguration.collectionName : "";
    }

    public int getIndex() {
        int n = 0;
        try {
            n = Integer.parseInt(this.collectionServerConfiguration.collectionID);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    public String getUniqueIdentifier() {
        if (this.collectionServerConfiguration != null) {
            return this.collectionServerConfiguration.institutionID + "-" + this.collectionServerConfiguration.collectionID + "-" + this.collectionServerConfiguration.vcID + "-B";
        }
        return "";
    }

    public EditComponent getEditComponent() {
        this.editComponent = new CollectionServerConfigurationBrowserEditComponent();
        Vector vector = this.collectionServerConfiguration.getCollection().getServer().getFields(new Integer(this.collectionServerConfiguration.nativeStandardID));
        for (int i = 0; i < vector.size(); ++i) {
            CollectionServerField collectionServerField = (CollectionServerField)vector.elementAt(i);
            int n = collectionServerField.getFieldId();
            String string = collectionServerField.getFieldName();
            this.editComponent.getSort1ComboBox().addItem(collectionServerField);
            this.editComponent.getSort2ComboBox().addItem(collectionServerField);
            this.editComponent.getSort3ComboBox().addItem(collectionServerField);
            this.editComponent.getSort4ComboBox().addItem(collectionServerField);
            if (this.sort1FieldID == n) {
                this.editComponent.getSort1ComboBox().setSelectedItem(collectionServerField);
            }
            if (this.sort2FieldID == n) {
                this.editComponent.getSort2ComboBox().setSelectedItem(collectionServerField);
            }
            if (this.sort3FieldID == n) {
                this.editComponent.getSort3ComboBox().setSelectedItem(collectionServerField);
            }
            if (this.sort4FieldID == n) {
                this.editComponent.getSort4ComboBox().setSelectedItem(collectionServerField);
            }
            this.editComponent.getThumbnail1ComboBox().addItem(collectionServerField);
            this.editComponent.getThumbnail2ComboBox().addItem(collectionServerField);
            this.editComponent.getThumbnail3ComboBox().addItem(collectionServerField);
            this.editComponent.getThumbnail4ComboBox().addItem(collectionServerField);
            if (this.thumbnail1FieldID == n) {
                this.editComponent.getThumbnail1ComboBox().setSelectedItem(collectionServerField);
            }
            if (this.thumbnail2FieldID == n) {
                this.editComponent.getThumbnail2ComboBox().setSelectedItem(collectionServerField);
            }
            if (this.thumbnail3FieldID == n) {
                this.editComponent.getThumbnail3ComboBox().setSelectedItem(collectionServerField);
            }
            if (this.thumbnail4FieldID != n) continue;
            this.editComponent.getThumbnail4ComboBox().setSelectedItem(collectionServerField);
        }
        this.editComponent.getRtlUrlField().setText(this.rtlUrl);
        this.editComponent.getRtlImageField().setText(this.rtlImage);
        this.editComponent.getBgLoadingField().setText(this.bgLoading);
        this.editComponent.getBgMenuField().setText(this.bgMenu);
        this.editComponent.getBgProgressOnField().setText(this.bgProgressOn);
        this.editComponent.getBgProgressOffField().setText(this.bgProgressOff);
        this.editComponent.getBgGroupLeftField().setText(this.bgGroupLeft);
        this.editComponent.getBgGroupLeftNSField().setText(this.bgGroupLeftNS);
        this.editComponent.getBgGroupRightField().setText(this.bgGroupRight);
        this.editComponent.getBgGWBottomField().setText(this.bgGWBottom);
        this.editComponent.getBgGWTopField().setText(this.bgGWTop);
        this.editComponent.getBgGroupLeftHtmlField().setText(this.bgGroupLeftHtml);
        this.editComponent.getSecurityCheckBox().setSelected(this.browserSecurity);
        this.editComponent.getSort1ComboBox().requestFocus();
        return this.editComponent;
    }

    public void save() {
        int n;
        CollectionServerConfigurationBrowserAttributes.debugOut("Save...", 3);
        this.requiresCommit = false;
        try {
            n = ((CollectionServerField)this.editComponent.getSort1ComboBox().getSelectedItem()).getFieldId();
            if (this.hasChanged(this.sort1FieldID, n)) {
                this.sort1FieldID = n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            n = ((CollectionServerField)this.editComponent.getSort2ComboBox().getSelectedItem()).getFieldId();
            if (this.hasChanged(this.sort2FieldID, n)) {
                this.sort2FieldID = n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            int n2 = ((CollectionServerField)this.editComponent.getSort3ComboBox().getSelectedItem()).getFieldId();
            if (this.hasChanged(this.sort3FieldID, n2)) {
                this.sort3FieldID = n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            int n3 = ((CollectionServerField)this.editComponent.getSort4ComboBox().getSelectedItem()).getFieldId();
            if (this.hasChanged(this.sort4FieldID, n3)) {
                this.sort4FieldID = n3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            int n4 = ((CollectionServerField)this.editComponent.getThumbnail1ComboBox().getSelectedItem()).getFieldId();
            if (this.hasChanged(this.thumbnail1FieldID, n4)) {
                this.thumbnail1FieldID = n4;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            int n5 = ((CollectionServerField)this.editComponent.getThumbnail2ComboBox().getSelectedItem()).getFieldId();
            if (this.hasChanged(this.thumbnail2FieldID, n5)) {
                this.thumbnail2FieldID = n5;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            int n6 = ((CollectionServerField)this.editComponent.getThumbnail3ComboBox().getSelectedItem()).getFieldId();
            if (this.hasChanged(this.thumbnail3FieldID, n6)) {
                this.thumbnail3FieldID = n6;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            int n7 = ((CollectionServerField)this.editComponent.getThumbnail4ComboBox().getSelectedItem()).getFieldId();
            if (this.hasChanged(this.thumbnail4FieldID, n7)) {
                this.thumbnail4FieldID = n7;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.hasChanged(this.rtlUrl, this.editComponent.getRtlUrlField().getText())) {
            this.rtlUrl = this.editComponent.getRtlUrlField().getText();
        }
        if (this.hasChanged(this.rtlImage, this.editComponent.getRtlImageField().getText())) {
            this.rtlImage = this.editComponent.getRtlImageField().getText();
        }
        if (this.hasChanged(this.bgLoading, this.editComponent.getBgLoadingField().getText())) {
            this.bgLoading = this.editComponent.getBgLoadingField().getText();
        }
        if (this.hasChanged(this.bgMenu, this.editComponent.getBgMenuField().getText())) {
            this.bgMenu = this.editComponent.getBgMenuField().getText();
        }
        if (this.hasChanged(this.bgProgressOn, this.editComponent.getBgProgressOnField().getText())) {
            this.bgProgressOn = this.editComponent.getBgProgressOnField().getText();
        }
        if (this.hasChanged(this.bgProgressOff, this.editComponent.getBgProgressOffField().getText())) {
            this.bgProgressOff = this.editComponent.getBgProgressOffField().getText();
        }
        if (this.hasChanged(this.bgGroupLeft, this.editComponent.getBgGroupLeftField().getText())) {
            this.bgGroupLeft = this.editComponent.getBgGroupLeftField().getText();
        }
        if (this.hasChanged(this.bgGroupLeftNS, this.editComponent.getBgGroupLeftNSField().getText())) {
            this.bgGroupLeftNS = this.editComponent.getBgGroupLeftNSField().getText();
        }
        if (this.hasChanged(this.bgGroupRight, this.editComponent.getBgGroupRightField().getText())) {
            this.bgGroupRight = this.editComponent.getBgGroupRightField().getText();
        }
        if (this.hasChanged(this.bgGWBottom, this.editComponent.getBgGWBottomField().getText())) {
            this.bgGWBottom = this.editComponent.getBgGWBottomField().getText();
        }
        if (this.hasChanged(this.bgGWTop, this.editComponent.getBgGWTopField().getText())) {
            this.bgGWTop = this.editComponent.getBgGWTopField().getText();
        }
        if (this.hasChanged(this.bgGroupLeftHtml, this.editComponent.getBgGroupLeftHtmlField().getText())) {
            this.bgGroupLeftHtml = this.editComponent.getBgGroupLeftHtmlField().getText();
        }
        if (this.hasChanged(this.browserSecurity, this.editComponent.getSecurityCheckBox().isSelected())) {
            this.browserSecurity = this.editComponent.getSecurityCheckBox().isSelected();
        }
        this.creationCompleted = true;
        if (this.requiresCommit) {
            this.collectionServerConfiguration.getCollection().getServer().commitDataObject(this);
        } else {
            this.collectionServerConfiguration.getCollection().getServer().cancelEdit(this);
        }
    }

    public void cancel() {
        CollectionServerConfigurationBrowserAttributes.debugOut("Cancel...", 3);
        this.editComponent = null;
        this.collectionServerConfiguration.getCollection().getServer().cancelEdit(this);
    }

    public String getEditWindowTitle() {
        return (this.collectionServerConfiguration != null ? this.collectionServerConfiguration.collectionName : "") + " - Browser Insight Attributes";
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/collection-server-configurations-node-icon.gif");
    }

    public boolean equals(Object object) {
        if (object instanceof CollectionServerConfigurationBrowserAttributes) {
            CollectionServerConfigurationBrowserAttributes collectionServerConfigurationBrowserAttributes = (CollectionServerConfigurationBrowserAttributes)object;
            return this.collectionServerConfiguration.equals(collectionServerConfigurationBrowserAttributes.collectionServerConfiguration);
        }
        return super.equals(object);
    }

    public boolean equalsRecord(DatabaseRecord databaseRecord) {
        if (databaseRecord instanceof CollectionServerConfigurationBrowserAttributes) {
            CollectionServerConfigurationBrowserAttributes collectionServerConfigurationBrowserAttributes = (CollectionServerConfigurationBrowserAttributes)databaseRecord;
            return this.thumbnail1FieldID == collectionServerConfigurationBrowserAttributes.thumbnail1FieldID && this.thumbnail2FieldID == collectionServerConfigurationBrowserAttributes.thumbnail2FieldID && this.thumbnail3FieldID == collectionServerConfigurationBrowserAttributes.thumbnail3FieldID && this.thumbnail4FieldID == collectionServerConfigurationBrowserAttributes.thumbnail4FieldID && this.sort1FieldID == collectionServerConfigurationBrowserAttributes.sort1FieldID && this.sort2FieldID == collectionServerConfigurationBrowserAttributes.sort2FieldID && this.sort3FieldID == collectionServerConfigurationBrowserAttributes.sort3FieldID && this.sort4FieldID == collectionServerConfigurationBrowserAttributes.sort4FieldID && CollectionServerConfigurationBrowserAttributes.stringsAreEqual(this.rtlUrl, collectionServerConfigurationBrowserAttributes.rtlUrl) && CollectionServerConfigurationBrowserAttributes.stringsAreEqual(this.rtlImage, collectionServerConfigurationBrowserAttributes.rtlImage) && CollectionServerConfigurationBrowserAttributes.stringsAreEqual(this.bgLoading, collectionServerConfigurationBrowserAttributes.bgLoading) && CollectionServerConfigurationBrowserAttributes.stringsAreEqual(this.bgMenu, collectionServerConfigurationBrowserAttributes.bgMenu) && CollectionServerConfigurationBrowserAttributes.stringsAreEqual(this.bgProgressOn, collectionServerConfigurationBrowserAttributes.bgProgressOn) && CollectionServerConfigurationBrowserAttributes.stringsAreEqual(this.bgProgressOff, collectionServerConfigurationBrowserAttributes.bgProgressOff) && CollectionServerConfigurationBrowserAttributes.stringsAreEqual(this.bgGroupLeft, collectionServerConfigurationBrowserAttributes.bgGroupLeft) && CollectionServerConfigurationBrowserAttributes.stringsAreEqual(this.bgGroupLeftNS, collectionServerConfigurationBrowserAttributes.bgGroupLeftNS) && CollectionServerConfigurationBrowserAttributes.stringsAreEqual(this.bgGroupRight, collectionServerConfigurationBrowserAttributes.bgGroupRight) && CollectionServerConfigurationBrowserAttributes.stringsAreEqual(this.bgGWBottom, collectionServerConfigurationBrowserAttributes.bgGWBottom) && CollectionServerConfigurationBrowserAttributes.stringsAreEqual(this.bgGWTop, collectionServerConfigurationBrowserAttributes.bgGWTop) && CollectionServerConfigurationBrowserAttributes.stringsAreEqual(this.bgGroupLeftHtml, collectionServerConfigurationBrowserAttributes.bgGroupLeftHtml) && this.browserSecurity == collectionServerConfigurationBrowserAttributes.browserSecurity;
        }
        return false;
    }

    public static void debugOut(String string) {
        CollectionServerConfigurationBrowserAttributes.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CollectionServerConfigurationBrowserAttributes: " + string, n);
    }
}

