/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.collection;

import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.collserver.collection.PersonalCollectionAccessSettingsConfigurationEditComponent;
import com.luna.insight.admin.collserver.collection.PersonalCollectionSettingsNode;
import com.luna.insight.admin.collserver.config.CollectionServerConfiguration;

public class PersonalCollectionAccessSettingsConfiguration
extends CollectionServerConfiguration {
    private CollectionServerConfiguration config;
    private PersonalCollectionSettingsNode settingsNode;
    public PersonalCollectionAccessSettingsConfigurationEditComponent editComponent = null;

    public PersonalCollectionAccessSettingsConfiguration(CollectionServerConfiguration collectionServerConfiguration, PersonalCollectionSettingsNode personalCollectionSettingsNode) {
        this.config = collectionServerConfiguration;
        this.settingsNode = personalCollectionSettingsNode;
    }

    public int getPcOwnerID() {
        return this.config.getPcOwnerID();
    }

    public int getPcOwnerUserGroupID() {
        return this.config.getPcOwnerUserGroupID();
    }

    public int getPcUserGroupMemberPrivs() {
        return this.config.getPcUserGroupMemberPrivs();
    }

    public int getPcNonUserGroupMemberPrivs() {
        return this.config.getPcNonUserGroupMemberPrivs();
    }

    public String getUniqueIdentifier() {
        return "PC-ACCESS-SETTINGS" + this.config.getUniqueIdentifier();
    }

    public String getOriginalUniqueIdentifier() {
        return "PC-ACCESS-SETTINGS" + this.config.getOriginalUniqueIdentifier();
    }

    public EditComponent getEditComponent() {
        this.editComponent = new PersonalCollectionAccessSettingsConfigurationEditComponent(this);
        this.editComponent.setUserGroups(this.settingsNode.getPersonalCollectionUserGroups(), this.settingsNode.getCurrentGroupIndex());
        this.editComponent.setUsers(this.settingsNode.getCollectionServerUsers(), this.settingsNode.getCurrentUserIndex());
        this.editComponent.setPermissions(this.getPcUserGroupMemberPrivs(), this.getPcNonUserGroupMemberPrivs());
        return this.editComponent;
    }

    public void cancel() {
        PersonalCollectionAccessSettingsConfiguration.debugOut("Cancel...", 3);
        this.editComponent = null;
        this.config.getCollection().getServer().cancelEdit(this);
    }

    public void save() {
        PersonalCollectionAccessSettingsConfiguration.debugOut("Save...", 3);
        this.requiresCommit = false;
        if (this.hasChanged(this.getPcOwnerID(), this.editComponent.getSelectedOwnerId())) {
            this.config.setPcOwnerID(this.editComponent.getSelectedOwnerId());
        }
        if (this.hasChanged(this.getPcOwnerUserGroupID(), this.editComponent.getSelectedGroupId())) {
            this.config.setPcOwnerUserGroupID(this.editComponent.getSelectedGroupId());
        }
        if (this.hasChanged(this.getPcUserGroupMemberPrivs(), this.editComponent.getGroupPrivs())) {
            this.config.setPcUserGroupMemberPrivs(this.editComponent.getGroupPrivs());
        }
        if (this.hasChanged(this.getPcNonUserGroupMemberPrivs(), this.editComponent.getOtherPrivs())) {
            this.config.setPcNonUserGroupMemberPrivs(this.editComponent.getOtherPrivs());
        }
        this.creationCompleted = true;
        boolean bl = this.requiresCommit;
        if (bl) {
            this.config.getCollection().getServer().commitDataObject(this.config);
        }
        this.config.getCollection().getServer().cancelEdit(this);
        if (bl) {
            try {
                this.config.getCollection().getServer().updateParentNode(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public PersonalCollectionSettingsNode getSettingsNode() {
        return this.settingsNode;
    }

    public String getEditWindowTitle() {
        return "Access Settings";
    }
}

