/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver;

import com.luna.insight.admin.AdminAccount;
import com.luna.insight.admin.AdminAccountsNode;
import com.luna.insight.admin.AdministeredServerNode;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditDialog;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.GroupingNode;
import com.luna.insight.admin.SaveCancelDialog;
import com.luna.insight.admin.catalog.CatalogTemplate;
import com.luna.insight.admin.catalog.CatalogTemplateNode;
import com.luna.insight.admin.collserver.CollectionServer;
import com.luna.insight.admin.collserver.CollectionServerConnector;
import com.luna.insight.admin.collserver.collection.Collection;
import com.luna.insight.admin.collserver.collection.CollectionNode;
import com.luna.insight.admin.collserver.collection.PersonalCollectionAccessSettingsConfiguration;
import com.luna.insight.admin.collserver.config.CollectionServerConfiguration;
import com.luna.insight.admin.collserver.field.CollectionServerField;
import com.luna.insight.admin.collserver.field.CollectionServerFieldGroup;
import com.luna.insight.admin.collserver.field.CollectionServerFieldRecordHandler;
import com.luna.insight.admin.collserver.fieldstd.CsFieldStandard;
import com.luna.insight.admin.collserver.fieldstd.CsFieldStandardField;
import com.luna.insight.admin.collserver.fieldstd.CsFieldStandardFieldRecordHandler;
import com.luna.insight.admin.collserver.fieldstd.CsFieldStandardNode;
import com.luna.insight.admin.collserver.fieldstd.CsFieldStandardsNode;
import com.luna.insight.admin.collserver.inscribe.CcMedeApprovalLevels;
import com.luna.insight.admin.collserver.inscribe.CcMedeEntityField;
import com.luna.insight.admin.collserver.inscribe.CcMedeEntityRelationship;
import com.luna.insight.admin.collserver.inscribe.CcMedeEntityType;
import com.luna.insight.admin.collserver.inscribe.CcMedeNode;
import com.luna.insight.admin.collserver.inscribe.CcMedeProfile;
import com.luna.insight.admin.collserver.inscribe.CcMedeProfileNode;
import com.luna.insight.admin.collserver.lps.CcLpsData;
import com.luna.insight.admin.collserver.lps.CcLpsDataNode;
import com.luna.insight.admin.collserver.maxid.CsMaxIDs;
import com.luna.insight.admin.collserver.maxid.CsMaxIDsNode;
import com.luna.insight.admin.collserver.measurement.CsMeasurementToolSettings;
import com.luna.insight.admin.collserver.mediacreation.CcMediaBatch;
import com.luna.insight.admin.collserver.mediacreation.CsMediaGroup;
import com.luna.insight.admin.collserver.mpd.CsMpd;
import com.luna.insight.admin.collserver.mpd.CsMpdTemplate;
import com.luna.insight.admin.collserver.profile.CollectionServerProfile;
import com.luna.insight.admin.collserver.profile.CollectionServerProfileNode;
import com.luna.insight.admin.collserver.sps.CcSpsData;
import com.luna.insight.admin.collserver.sps.CcSpsDataNode;
import com.luna.insight.admin.collserver.stoplist.CcStopListNode;
import com.luna.insight.admin.collserver.stoplist.CcStopWord;
import com.luna.insight.admin.collserver.table.CcTableRecord;
import com.luna.insight.admin.collserver.usergroup.CollectionServerConnectionPool;
import com.luna.insight.admin.collserver.usergroup.CollectionServerConnectionPoolsNode;
import com.luna.insight.admin.collserver.usergroup.CollectionServerUserGroup;
import com.luna.insight.admin.collserver.usergroup.PersonalCollectionServerUserGroup;
import com.luna.insight.admin.collserver.usergroup.PersonalCollectionServerUserGroupsNode;
import com.luna.insight.admin.collserver.vocab.CsVocabulariesNode;
import com.luna.insight.admin.userserver.UserServerConnectEditComponent;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.tree.TreeNode;

public class CollectionServerNode
extends AdministeredServerNode {
    public static final String COMMAND_NEW_PROFILE = "New Profile Command";
    public static final String COMMAND_DELETE_PROFILE = "Delete Profile Command";
    public static final String COMMAND_EDIT_PROFILE = "Edit Profile Command";
    public static final String COMMAND_NEW_FIELD_STANDARD = "New Field Standard Command";
    public static final String COMMAND_DELETE_FIELD_STANDARD = "Delete Field Standard Command";
    public static final String COMMAND_EDIT_FIELD_STANDARD = "Edit Field Standard Command";
    public static final String COMMAND_NEW_FIELD_STANDARD_FIELD = "New-field-standard-field";
    public static final String COMMAND_DELETE_FIELD_STANDARD_FIELD = "Delete-field-standard-field";
    public static final String COMMAND_EDIT_FIELD_STANDARD_FIELD = "Edit-field-standard-field";
    public static final String COMMAND_MAP_STANDARD_FIELDS = "Editmap-field-standard-fields";
    public static final String COMMAND_NEW_CONNECTION_POOL = "New Connection Pool Command";
    public static final String COMMAND_DELETE_CONNECTION_POOL = "Delete Connection Pool Command";
    public static final String COMMAND_EDIT_CONNECTION_POOL = "Edit Connection Pool Command";
    public static final String COMMAND_NEW_VOCAB_VALUE = "New Vocab Value Command";
    public static final String COMMAND_DELETE_VOCAB_VALUE = "Delete Vocab Value Command";
    public static final String COMMAND_EDIT_VOCAB_VALUE = "Edit Vocab Value Command";
    public static final String COMMAND_NEW_LPS_DATA = "New LPS Data Command";
    public static final String COMMAND_DELETE_LPS_DATA = "Delete LPS Data Command";
    public static final String COMMAND_EDIT_LPS_DATA = "Edit LPS Data Command";
    public static final String COMMAND_NEW_SPS_DATA = "New SPS Data Command";
    public static final String COMMAND_DELETE_SPS_DATA = "Delete SPS Data Command";
    public static final String COMMAND_EDIT_SPS_DATA = "Edit SPS Data Command";
    public static final String COMMAND_NEW_STOP_WORD = "New Stop Word Command";
    public static final String COMMAND_DELETE_STOP_WORD = "Delete Stop Word Command";
    public static final String COMMAND_EDIT_STOP_WORD = "Edit Stop Word Command";
    public static final String COMMAND_EDIT_MAX_IDS = "Edit-max-ids";
    public static final String COMMAND_NEW_PC_USER_GROUP = "New PC User Group Command";
    public static final String COMMAND_OPEN_TASK = "Open Task Command";
    public static final String COMMAND_NEW_TASK = "New Task Command";
    public static final String COMMAND_DELETE_TASK = "Delete Task Command";
    public static final String COMMAND_EDIT_TASK = "Edit Task Command";
    public static final String COMMAND_EDIT_TASK_IMAGE_CREATION = "Edit Task Image Creation";
    public static final String COMMAND_NEW_PROFILE_MEDE = "New MEDE Profile Command";
    public static final String COMMAND_DELETE_PROFILE_MEDE = "Delete MEDE Profile Command";
    public static final String COMMAND_EDIT_PROFILE_MEDE = "Edit MEDE Profile Command";
    public static final int JOIN_MODE_INSIGHT = 1;
    public static final int JOIN_MODE_INSCRIBE = 2;
    public static final float MIN_SERVER_VERSION_MPD = 3.5f;
    public static final float MIN_SERVER_VERSION_VOCABULARIES = 3.5f;
    protected GroupingNode collectionSettingsNode = null;
    protected GroupingNode serverSettingsNode = null;
    protected GroupingNode catalogTemplatesNode = null;
    protected Map collectionNodes = new HashMap();
    protected Map templateNodes = new HashMap();
    protected Set collectionsWithDuplicateUIDAndVCIDEntries = new HashSet();
    protected CollectionServer collectionServer = null;
    public CollectionServerProfileNode profileNode = null;
    public CsFieldStandardsNode fieldStandardsNode = null;
    public CollectionServerConnectionPoolsNode connectionPoolsNode = null;
    public CsVocabulariesNode vocabulariesNode = null;
    public CcMedeNode medeNode = null;
    public CcMedeProfileNode medeProfileNode = null;
    public PersonalCollectionServerUserGroupsNode personalCollectionsUserGroupsNode = null;
    public CcLpsDataNode lpsDataNode = null;
    public CcSpsDataNode spsDataNode = null;
    public CcStopListNode stopListNode = null;
    public CsMaxIDsNode maxIDsNode = null;
    protected String labelText = null;
    protected SaveCancelDialog mpdtDialog = null;
    protected boolean isPersonalCollectionServer = false;

    public CollectionServerNode(CollectionServer collectionServer) {
        super(collectionServer);
        this.collectionServer = collectionServer;
        collectionServer.setNode(this);
    }

    protected void createInformationModel() {
        this.labelText = "";
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        CollectionServerNode.debugOut("Received action: " + string);
        if (string.equals("Remove Command")) {
            CollectionServerNode.debugOut("Remove CollectionServer.");
            if (this.insightAdministrator.showYesNoConfirmDialog("Are you sure you want to delete this CollectionServer registration?", "Delete Confirmation")) {
                if (this.collectionServer.disconnect()) {
                    TreeNode treeNode = this.getParent();
                    this.removeFromParent();
                    this.insightAdministrator.reloadTreeModel(treeNode);
                    this.insightAdministrator.removeCollectionServerFromStore(this.collectionServer.getName());
                } else {
                    CollectionServerNode.debugOut("Couldn't disconnect CollectionServer.");
                }
            }
        } else if (string.equals(COMMAND_NEW_PC_USER_GROUP)) {
            this.createNewUserGroup(new Integer(-1));
        } else if (string.equals(COMMAND_NEW_FIELD_STANDARD)) {
            this.createNewFieldStandard();
        } else if (string.equals(COMMAND_MAP_STANDARD_FIELDS)) {
            this.manageStandardFieldMappings();
        } else if (string.equals(COMMAND_NEW_CONNECTION_POOL)) {
            this.createNewConnectionPool();
        } else if (string.equals(COMMAND_NEW_LPS_DATA)) {
            this.createNewLpsData();
        } else if (string.equals(COMMAND_NEW_SPS_DATA)) {
            this.createNewSpsData();
        } else if (string.equals(COMMAND_NEW_STOP_WORD)) {
            this.createNewStopWord();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public CollectionNode getCollectionNode(Integer n) {
        return (CollectionNode)this.collectionNodes.get(n);
    }

    public Set getCollectionsWithDuplicateUIDAndVCIDEntries() {
        return this.collectionsWithDuplicateUIDAndVCIDEntries;
    }

    public void addCollectionNode(CollectionNode collectionNode) {
        Integer n = collectionNode.getCollection().getUniqueCollectionID();
        if (this.collectionNodes.keySet().contains(n) && collectionNode.getCollection().getVCID().equals("NA")) {
            this.collectionsWithDuplicateUIDAndVCIDEntries.add(n);
        }
        this.collectionNodes.put(n, collectionNode);
        this.collectionSettingsNode.add(collectionNode);
    }

    public CatalogTemplateNode getCatalogTemplateNode(Integer n) {
        return (CatalogTemplateNode)this.templateNodes.get(n);
    }

    public void addCatalogTemplateNode(CatalogTemplateNode catalogTemplateNode, boolean bl) {
        this.templateNodes.put(catalogTemplateNode.getTemplate().getTemplateID(), catalogTemplateNode);
        if (!bl) {
            this.catalogTemplatesNode.add(catalogTemplateNode);
        }
    }

    public void connect() {
        CollectionServerNode.debugOut("Connect CollectionServer.");
        EditableDataObject editableDataObject = new EditableDataObject(){
            private UserServerConnectEditComponent usce = null;

            public EditComponent getEditComponent() {
                this.usce = new UserServerConnectEditComponent();
                boolean bl = CollectionServerNode.this.collectionServer.isPasswordRemembered();
                String string = CollectionServerNode.this.collectionServer.getAccountUsername();
                String string2 = "";
                if (bl) {
                    string2 = CollectionServerNode.this.collectionServer.getAccountPassword();
                }
                this.usce.getUsernameField().setText(string);
                this.usce.getPasswordField().setText(string2);
                this.usce.getRememberCheckBox().setSelected(bl);
                this.usce.getUsernameField().selectAll();
                return this.usce;
            }

            public void save() {
                CollectionServerNode.this.doConnect(this.usce.getUsernameField().getText(), new String(this.usce.getPasswordField().getPassword()), this.usce.getRememberCheckBox().isSelected());
            }

            public void cancel() {
            }

            public String getSaveButtonText() {
                return "Login";
            }

            public String getEditWindowTitle() {
                return "Login";
            }

            public ImageIcon getEditWindowIcon() {
                return IconMaker.createImage("images/collection-server-node-icon.gif");
            }
        };
        new EditDialog(this.insightAdministrator.getFrame(), true, editableDataObject).show();
    }

    public void fullRefresh() {
        this.removeAllChildren();
        boolean bl = this.getAdminAccount().hasServerPermission(17) && !this.getAdminAccount().hasServerPermission(5) && !this.getAdminAccount().hasServerPermission(9) && !this.getAdminAccount().hasServerPermission(3);
        CollectionServerConnector collectionServerConnector = (CollectionServerConnector)this.collectionServer.getServerConnector();
        this.collectionSettingsNode = new GroupingNode("Collection Settings", this.server.getInsightAdministrator(), bl);
        this.serverSettingsNode = new GroupingNode("Server Settings", this.server.getInsightAdministrator(), bl);
        this.catalogTemplatesNode = new GroupingNode("Catalog Templates", this.server.getInsightAdministrator(), bl);
        this.isPersonalCollectionServer = collectionServerConnector.isPersonalCollectionServer();
        List list = collectionServerConnector.getCatalogTemplates();
        Collections.sort(list);
        this.add(this.catalogTemplatesNode);
        Object object = list.iterator();
        while (object.hasNext()) {
            this.addCatalogTemplateNode(new CatalogTemplateNode((CatalogTemplate)object.next()), bl);
        }
        this.add(this.collectionSettingsNode);
        this.add(this.serverSettingsNode);
        if (!bl) {
            object = collectionServerConnector.getCollections();
            Collections.sort(object);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Collection collection = (Collection)iterator.next();
                if (!collection.getVCID().equals("NA")) continue;
                this.addCollectionNode(new CollectionNode(collection));
            }
            this.personalCollectionsUserGroupsNode = new PersonalCollectionServerUserGroupsNode(this);
            if (this.isPersonalCollectionServer) {
                this.serverSettingsNode.add(this.personalCollectionsUserGroupsNode);
            }
            this.adminAccountsNode = new AdminAccountsNode(this);
            this.serverSettingsNode.add(this.adminAccountsNode);
            this.profileNode = new CollectionServerProfileNode(this);
            this.serverSettingsNode.add(this.profileNode);
            this.medeProfileNode = new CcMedeProfileNode(this);
            this.serverSettingsNode.add(this.medeProfileNode);
            this.connectionPoolsNode = new CollectionServerConnectionPoolsNode(this);
            this.serverSettingsNode.add(this.connectionPoolsNode);
            if (this.collectionServer.getCollectionServerVersion() < 3.5f) {
                this.vocabulariesNode = new CsVocabulariesNode(this);
                this.serverSettingsNode.add(this.vocabulariesNode);
            }
            this.fieldStandardsNode = new CsFieldStandardsNode(this);
            this.serverSettingsNode.add(this.fieldStandardsNode);
            this.stopListNode = new CcStopListNode(this);
            this.serverSettingsNode.add(this.stopListNode);
            this.lpsDataNode = new CcLpsDataNode(this);
            this.serverSettingsNode.add(this.lpsDataNode);
            this.spsDataNode = new CcSpsDataNode(this);
            this.serverSettingsNode.add(this.spsDataNode);
            if (this.collectionServer.isMaxIDsEnabled()) {
                this.maxIDsNode = new CsMaxIDsNode(this);
                this.serverSettingsNode.add(this.maxIDsNode);
            }
        }
        if (bl) {
            CollectionServerNode.debugOut("User has only Task permissions: setting server edit, add and delete permissions to true.");
            this.getAdminAccount().setServerEditPermission(true);
            this.getAdminAccount().setServerAddPermission(true);
            this.getAdminAccount().setServerDeletePermission(true);
        }
        this.expandNode();
    }

    public void doConnect(String string, String string2, boolean bl) {
        if (this.collectionServer.isConnected()) {
            this.insightAdministrator.showWarningDialog("Already connected.  Disconnect first, and then try connecting again.", "Already Connected");
            return;
        }
        this.username = string;
        this.password = string2;
        this.collectionServer.setPasswordRemembered(bl);
        if (this.collectionServer.connect(string, string2)) {
            this.fullRefresh();
        }
        this.refreshData();
    }

    public void disconnect() {
        CollectionServerNode.debugOut("Disconnect CollectionServer.");
        this.collectionServer.disconnect();
        this.removeAllChildren();
        this.refreshData();
    }

    public void edit() {
        CollectionServerNode.debugOut("Edit CollectionServer.");
        this.collectionServer.edit();
    }

    public void refreshData() {
        if (!this.collectionServer.getAccountUsername().equals("") && this.collectionServer.isConnected()) {
            this.setText(this.collectionServer.getName() + " (" + this.collectionServer.getAccountUsername() + ")");
        } else {
            this.setText(this.collectionServer.getName());
        }
        this.collectionServer.getInsightAdministrator().reloadTreeModel(this);
    }

    public CollectionServer getCollectionServer() {
        return this.collectionServer;
    }

    public AdminAccount getAdminAccount() {
        return this.collectionServer.getAdminAccount();
    }

    public JComponent getDisplayComponent() {
        if (this.labelText == null) {
            this.createInformationModel();
        }
        return new JLabel(this.labelText);
    }

    public ImageIcon getIcon() {
        if (this.collectionServer.isConnected()) {
            if (this.treeIcon == null) {
                this.treeIcon = IconMaker.createImage("images/collection-server-node-icon.gif");
            }
            return this.treeIcon;
        }
        if (this.disconnectedIcon == null) {
            this.disconnectedIcon = IconMaker.createImage("images/disconnected-collection-server-node-icon.gif");
        }
        return this.disconnectedIcon;
    }

    public void createNewConfiguration(Integer n) {
        Collection collection = ((CollectionNode)this.collectionNodes.get(n)).getCollection();
        this.collectionServer.addDataObject(new CollectionServerConfiguration(collection));
    }

    public void removeConfigurations(Vector vector) {
        CollectionServerNode.debugOut("Removing configurations: " + vector);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        if (this.insightAdministrator.showYesNoConfirmDialog("Are you sure you want to delete the selected configurations?", "Delete Confirmation")) {
            Object object;
            for (int i = 0; i < vector.size(); ++i) {
                object = (CollectionServerConfiguration)vector.elementAt(i);
                this.collectionServer.removeDataObject((EditableDataObject)object);
                hashSet.add(((CollectionServerConfiguration)object).getUniqueCollectionID());
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                object = this.getCollectionNode((Integer)iterator.next());
                if (object == null) continue;
                ((CollectionNode)object).configurationsNode.updateInformationDisplay();
            }
            this.profileNode.refreshChildNodes();
        }
    }

    public void convertPersonalToInstitutionalCollection(CollectionServerConfiguration collectionServerConfiguration) {
        CollectionServerNode.debugOut("Converting personal collection to institutional");
        if (this.insightAdministrator.showYesNoConfirmDialog("Are you sure you want to convert this personal collection into an institutional collection?  This cannot be undone.", "Convert Confirmation")) {
            this.collectionServer.convertPersonalToInstitutionalCollection(collectionServerConfiguration);
        }
    }

    public void editConfiguration(CollectionServerConfiguration collectionServerConfiguration) {
        this.collectionServer.editDataObject(collectionServerConfiguration);
    }

    public void editPCAccessSettings(PersonalCollectionAccessSettingsConfiguration personalCollectionAccessSettingsConfiguration) {
        this.collectionServer.editDataObject(personalCollectionAccessSettingsConfiguration);
    }

    public void editProfile(CollectionServerProfile collectionServerProfile) {
        CollectionServerNode.debugOut("Editing profile: " + collectionServerProfile);
        this.collectionServer.editDataObject(collectionServerProfile);
    }

    public void removeProfile(Vector vector) {
        if (this.insightAdministrator.showYesNoConfirmDialog("Are you sure you want to delete the selected profiles?", "Delete Confirmation")) {
            for (int i = 0; i < vector.size(); ++i) {
                CollectionServerProfile collectionServerProfile = (CollectionServerProfile)vector.elementAt(i);
                this.collectionServer.removeDataObject(collectionServerProfile);
                this.profileNode.updateNodeChild(collectionServerProfile);
            }
        }
    }

    public void createNewField(Integer n) {
        CollectionServerConnector collectionServerConnector = (CollectionServerConnector)this.collectionServer.getServerConnector();
        CollectionServerFieldRecordHandler collectionServerFieldRecordHandler = collectionServerConnector.getFieldHandler();
        int n2 = this.collectionServer.getCollectionServerConnector().getNextValidFieldID();
        Vector vector = this.collectionServer.getCollectionServerConnector().fieldHandler.getTableNames();
        Vector vector2 = collectionServerFieldRecordHandler.getHierarchyValues();
        Vector vector3 = this.collectionServer.getCollectionServerConnector().fieldHandler.getJoinNames(1);
        Vector vector4 = collectionServerFieldRecordHandler.getFieldGroupNames();
        Vector vector5 = collectionServerFieldRecordHandler.getEntityTypeNames();
        CollectionServerField collectionServerField = new CollectionServerField(this.getCatalogTemplateNode(n).getTemplate(), n2, vector, vector2, vector3, vector4, vector5);
        collectionServerField.setSelectListSettings(CsFieldStandardField.SELECT_LIST_NONE);
        this.collectionServer.addDataObject(collectionServerField);
    }

    public void removeField(Vector vector) {
        CollectionServerNode.debugOut("Removing fields ");
        HashSet<Integer> hashSet = new HashSet<Integer>();
        if (this.insightAdministrator.showYesNoConfirmDialog("Are you sure you want to delete the selected fields?", "Delete Confirmation")) {
            for (int i = 0; i < vector.size(); ++i) {
                CollectionServerField collectionServerField = (CollectionServerField)vector.elementAt(i);
                collectionServerField.setDeleteMode(CollectionServerField.DELETE_MODE_DELETE);
                this.collectionServer.removeDataObject(collectionServerField);
                hashSet.add(collectionServerField.getTemplate().getTemplateID());
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                this.getCatalogTemplateNode((Integer)((Integer)iterator.next())).fieldNode.updateInformationDisplay();
            }
            if (this.vocabulariesNode != null) {
                this.vocabulariesNode.refreshChildNodes();
            }
        }
    }

    public void editField(CollectionServerField collectionServerField) {
        CollectionServerNode.debugOut("Editing Field");
        collectionServerField.setDeleteMode(CollectionServerField.DELETE_MODE_EDIT);
        this.collectionServer.editDataObject(collectionServerField);
    }

    public void createNewFieldGroup(Integer n) {
        CatalogTemplate catalogTemplate = this.getCatalogTemplateNode(n).getTemplate();
        CollectionServerFieldGroup collectionServerFieldGroup = new CollectionServerFieldGroup(this.collectionServer.getCollectionServerConnector().getNextValidFieldGroupID(), catalogTemplate);
        collectionServerFieldGroup.setDisplayOrder(1);
        this.collectionServer.addDataObject(collectionServerFieldGroup);
    }

    public void removeFieldGroups(Vector vector) {
        CollectionServerNode.debugOut("Removing FieldGroups: " + vector);
        if (this.insightAdministrator.showYesNoConfirmDialog("Are you sure you want to delete the selected field groups?", "Delete Confirmation")) {
            HashSet<Integer> hashSet = new HashSet<Integer>();
            for (int i = 0; i < vector.size(); ++i) {
                CollectionServerFieldGroup collectionServerFieldGroup = (CollectionServerFieldGroup)vector.elementAt(i);
                Integer n = collectionServerFieldGroup.getTemplate().getTemplateID();
                Vector vector2 = this.getCollectionServer().getCollectionServerConnector().getMedeEntityTypeRecords(n);
                boolean bl = false;
                if (vector2 != null) {
                    Iterator iterator = vector2.iterator();
                    while (iterator.hasNext() && !bl) {
                        CcMedeEntityType ccMedeEntityType = (CcMedeEntityType)iterator.next();
                        if (ccMedeEntityType.getIndex() != collectionServerFieldGroup.getIndex()) continue;
                        bl = true;
                        this.insightAdministrator.showWarningDialog("This Field Group is required by the Record Type \"" + ccMedeEntityType.getName() + "\" and can't be deleted.", "Can't Delete");
                    }
                }
                if (bl) continue;
                this.collectionServer.removeDataObject(collectionServerFieldGroup);
                hashSet.add(n);
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                this.getCatalogTemplateNode((Integer)((Integer)iterator.next())).fieldGroupsNode.updateInformationDisplay();
            }
        }
    }

    public void editFieldGroup(CollectionServerFieldGroup collectionServerFieldGroup) {
        CollectionServerNode.debugOut("Editing FieldGroup: " + collectionServerFieldGroup);
        this.collectionServer.editDataObject(collectionServerFieldGroup);
    }

    public void createNewFieldStandard() {
        CsFieldStandard csFieldStandard = new CsFieldStandard(this.collectionServer.getCollectionServerConnector().getNextValidFieldStandardID(), this.collectionServer);
        csFieldStandard.setDisplayOrder(this.collectionServer.getCollectionServerConnector().getNextValidFieldStandardDisplayOrder());
        this.collectionServer.addDataObject(csFieldStandard);
    }

    public void removeFieldStandards(Vector vector) {
        CollectionServerNode.debugOut("Removing FieldStandards: " + vector);
        if (this.insightAdministrator.showYesNoConfirmDialog("Are you sure you want to delete the selected field standards?", "Delete Confirmation")) {
            for (int i = 0; i < vector.size(); ++i) {
                this.collectionServer.removeDataObject((CsFieldStandard)vector.elementAt(i));
            }
            this.fieldStandardsNode.updateInformationDisplay();
        }
    }

    public void editFieldStandard(CsFieldStandard csFieldStandard) {
        CollectionServerNode.debugOut("Editing FieldStandard: " + csFieldStandard);
        this.collectionServer.editDataObject(csFieldStandard);
    }

    public void createNewFieldStandardField(CsFieldStandard csFieldStandard) {
        CsFieldStandardField csFieldStandardField = new CsFieldStandardField(this.collectionServer, csFieldStandard, this.collectionServer.getCollectionServerConnector().getNextValidFieldStandardFieldID(csFieldStandard));
        CsFieldStandardFieldRecordHandler csFieldStandardFieldRecordHandler = this.collectionServer.getCollectionServerConnector().getFieldStandardFieldHandler();
        csFieldStandardField.setSelectListSettings(CsFieldStandardField.SELECT_LIST_NONE);
        this.collectionServer.addDataObject(csFieldStandardField);
    }

    public void removeFieldStandardFields(CsFieldStandardNode csFieldStandardNode, Vector vector) {
        CollectionServerNode.debugOut("Removing field standard fields.");
        if (this.insightAdministrator.showYesNoConfirmDialog("Are you sure you want to delete the selected standard fields?", "Delete Confirmation")) {
            for (int i = 0; i < vector.size(); ++i) {
                this.collectionServer.removeDataObject((CsFieldStandardField)vector.elementAt(i));
            }
            csFieldStandardNode.updateInformationDisplay();
        }
    }

    public void editFieldStandardField(CsFieldStandardField csFieldStandardField) {
        CollectionServerNode.debugOut("Editing field standard field: " + csFieldStandardField);
        this.collectionServer.editDataObject(csFieldStandardField);
    }

    public void manageStandardFieldMappings() {
        this.collectionServer.manageStandardFieldMappings();
    }

    public void createNewConnectionPool() {
        this.collectionServer.addDataObject(new CollectionServerConnectionPool(this.collectionServer.getCollectionServerConnector().getNextValidConnectionPoolID(), this.collectionServer));
    }

    public void removeConnectionPools(Vector vector) {
        CollectionServerNode.debugOut("Removing ConnectionPools: " + vector);
        if (this.insightAdministrator.showYesNoConfirmDialog("Are you sure you want to delete the selected connection pools?", "Delete Confirmation")) {
            for (int i = 0; i < vector.size(); ++i) {
                this.collectionServer.removeDataObject((CollectionServerConnectionPool)vector.elementAt(i));
            }
            this.connectionPoolsNode.updateInformationDisplay();
        }
    }

    public void editConnectionPool(CollectionServerConnectionPool collectionServerConnectionPool) {
        CollectionServerNode.debugOut("Editing ConnectionPool: " + collectionServerConnectionPool);
        this.collectionServer.editDataObject(collectionServerConnectionPool);
    }

    public void createNewUserGroup(Integer n) {
        if (n.equals(new Integer(-1))) {
            this.collectionServer.addDataObject(new PersonalCollectionServerUserGroup(this.collectionServer.getCollectionServerConnector().getNextValidUserGroupID(), this.collectionServer));
        } else {
            Collection collection = ((CollectionNode)this.collectionNodes.get(n)).getCollection();
            this.collectionServer.addDataObject(new CollectionServerUserGroup(n, this.collectionServer.getCollectionServerConnector().getNextValidUserGroupID(), collection));
        }
    }

    public void removeUserGroups(Vector vector) {
        CollectionServerNode.debugOut("Removing UserGroups: " + vector);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        if (this.insightAdministrator.showYesNoConfirmDialog("Are you sure you want to delete the selected user groups?", "Delete Confirmation")) {
            for (int i = 0; i < vector.size(); ++i) {
                this.collectionServer.removeDataObject((EditableDataObject)vector.elementAt(i));
                if (vector.elementAt(i) instanceof CollectionServerUserGroup) {
                    hashSet.add(((CollectionServerUserGroup)vector.elementAt(i)).getUniqueCollectionID());
                    continue;
                }
                hashSet.add(new Integer(-1));
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                Integer n = (Integer)iterator.next();
                if (!n.equals(new Integer(-1))) {
                    CollectionNode collectionNode = this.getCollectionNode(n);
                    if (collectionNode == null) continue;
                    collectionNode.userGroupsNode.updateInformationDisplay();
                    continue;
                }
                this.personalCollectionsUserGroupsNode.updateInformationDisplay();
            }
        }
    }

    public void editUserGroup(CollectionServerUserGroup collectionServerUserGroup) {
        CollectionServerNode.debugOut("Editing UserGroup: " + collectionServerUserGroup);
        this.collectionServer.editDataObject(collectionServerUserGroup);
    }

    public void editPersonalCollectionUserGroup(PersonalCollectionServerUserGroup personalCollectionServerUserGroup) {
        CollectionServerNode.debugOut("Editing UserGroup: " + personalCollectionServerUserGroup);
        this.collectionServer.editDataObject(personalCollectionServerUserGroup);
    }

    public void createNewMediaGroup(Integer n) {
        this.collectionServer.addDataObject(new CsMediaGroup(n, this.collectionServer.getCollectionServerConnector().getNextValidMediaGroupID(), this.collectionServer));
    }

    public void removeMediaGroups(Integer n, Vector vector) {
        CollectionServerNode.debugOut("Removing MediaGroups: " + vector);
        if (this.insightAdministrator.showYesNoConfirmDialog("Are you sure you want to delete the selected groups?", "Delete Confirmation")) {
            for (int i = 0; i < vector.size(); ++i) {
                this.collectionServer.removeDataObject((CsMediaGroup)vector.elementAt(i));
            }
            ((CollectionNode)this.collectionNodes.get((Object)n)).mediaGroupsNode.updateInformationDisplay();
        }
    }

    public void editMediaGroup(CsMediaGroup csMediaGroup) {
        CollectionServerNode.debugOut("Editing MediaGroup: " + csMediaGroup);
        CsMediaGroup csMediaGroup2 = this.collectionServer.getMediaGroup(csMediaGroup);
        this.collectionServer.editDataObject(csMediaGroup2);
    }

    public void manageSetIndexer(Integer n) {
        this.collectionServer.manageSetIndexer(n);
    }

    public void editInvokeIndexer(Integer n) {
        this.collectionServer.editInvokeIndexer(n);
    }

    public void createNewLpsData() {
        this.collectionServer.addDataObject(new CcLpsData(this.collectionServer, this.collectionServer.getCollectionServerConnector().getNextValidLpsDataID()));
    }

    public void removeLpsData(Vector vector) {
        CollectionServerNode.debugOut("Removing LPS Data: " + vector);
        if (this.insightAdministrator.showYesNoConfirmDialog("Are you sure you want to delete the selected LPS data entries?", "Delete Confirmation")) {
            for (int i = 0; i < vector.size(); ++i) {
                this.collectionServer.removeDataObject((CcLpsData)vector.elementAt(i));
            }
            this.lpsDataNode.updateInformationDisplay();
        }
    }

    public void editLpsData(CcLpsData ccLpsData) {
        CollectionServerNode.debugOut("Editing LPS Data: " + ccLpsData);
        this.collectionServer.editDataObject(ccLpsData);
    }

    public void createNewSpsData() {
        this.collectionServer.addDataObject(new CcSpsData(this.collectionServer.getCollectionServerConnector().getValidSpsNumber(), this.collectionServer));
    }

    public void removeSpsData(Vector vector) {
        CollectionServerNode.debugOut("Removing SPS Data: " + vector);
        if (this.insightAdministrator.showYesNoConfirmDialog("Are you sure you want to delete the selected SPS data entries?", "Delete Confirmation")) {
            for (int i = 0; i < vector.size(); ++i) {
                this.collectionServer.removeDataObject((CcSpsData)vector.elementAt(i));
            }
            this.spsDataNode.updateInformationDisplay();
        }
    }

    public void editSpsData(CcSpsData ccSpsData) {
        CollectionServerNode.debugOut("Editing SPS Data: " + ccSpsData);
        this.collectionServer.editDataObject(ccSpsData);
    }

    public void createNewStopWord() {
        this.collectionServer.addDataObject(new CcStopWord(this.collectionServer.getCollectionServerConnector().getNextValidStopWordID(), this.collectionServer));
    }

    public void removeStopWords(Vector vector) {
        CollectionServerNode.debugOut("Removing stop words: " + vector);
        if (this.insightAdministrator.showYesNoConfirmDialog("Are you sure you want to delete the selected stop words?", "Delete Confirmation")) {
            for (int i = 0; i < vector.size(); ++i) {
                this.collectionServer.removeDataObject((CcStopWord)vector.elementAt(i));
            }
            this.stopListNode.updateInformationDisplay();
        }
    }

    public void editStopWord(CcStopWord ccStopWord) {
        CollectionServerNode.debugOut("Editing stop word: " + ccStopWord);
        this.collectionServer.editDataObject(ccStopWord);
    }

    public void createNewTableRecord(Integer n) {
        Collection collection = this.getCollectionNode(n).getCollection();
        this.collectionServer.addDataObject(new CcTableRecord(collection, this.collectionServer.getCollectionServerConnector().getNextValidTableRecordID()));
    }

    public void removeTableRecords(Vector vector) {
        CollectionServerNode.debugOut("Removing table records: " + vector);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        if (this.insightAdministrator.showYesNoConfirmDialog("Are you sure you want to delete the selected table records?", "Delete Confirmation")) {
            for (int i = 0; i < vector.size(); ++i) {
                CcTableRecord ccTableRecord = (CcTableRecord)vector.elementAt(i);
                this.collectionServer.removeDataObject(ccTableRecord);
                hashSet.add(ccTableRecord.getCollection().getUniqueCollectionID());
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                this.getCollectionNode((Integer)((Integer)iterator.next())).tableRecordsNode.updateInformationDisplay();
            }
        }
    }

    public void editTableRecord(CcTableRecord ccTableRecord) {
        CollectionServerNode.debugOut("Editing table record: " + ccTableRecord);
        this.collectionServer.editDataObject(ccTableRecord);
    }

    public void createNewMpd(Integer n) {
        Vector vector = ((CollectionServerConnector)this.collectionServer.getServerConnector()).getMpdLevelData(-1);
        Vector vector2 = ((CollectionServerConnector)this.collectionServer.getServerConnector()).getMpdGroupList(n);
        Vector vector3 = ((CollectionServerConnector)this.collectionServer.getServerConnector()).getMpdFieldList(n);
        Vector vector4 = ((CollectionServerConnector)this.collectionServer.getServerConnector()).getMpdLevelFieldList(n);
        this.collectionServer.addDataObject(new CsMpd(n, ((CollectionServerConnector)this.collectionServer.getServerConnector()).getNextValidMpdId(), ((CollectionNode)this.collectionNodes.get(n)).getCollection(), vector, vector2, vector3, vector4));
        ((CollectionNode)this.collectionNodes.get((Object)n)).mpdNode.updateInformationDisplay();
    }

    public void removeMpd(Vector vector) {
        if (this.insightAdministrator.showYesNoConfirmDialog("Are you sure you want to delete the selected mpd records?", "Delete Confirmation")) {
            HashSet<Integer> hashSet = new HashSet<Integer>();
            for (int i = 0; i < vector.size(); ++i) {
                this.collectionServer.removeDataObject((CsMpd)vector.elementAt(i));
                hashSet.add(((CsMpd)vector.elementAt(i)).getUniqueCollectionID());
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                ((CollectionNode)this.collectionNodes.get((Object)((Integer)iterator.next()))).mpdNode.updateInformationDisplay();
            }
        }
    }

    public void editMpd(CsMpd csMpd) {
        this.collectionServer.editDataObject(csMpd);
        ((CollectionNode)this.collectionNodes.get((Object)csMpd.getUniqueCollectionID())).mpdNode.updateInformationDisplay();
    }

    public void createNewMpdTemplate(Integer n) {
        Vector vector = ((CollectionServerConnector)this.collectionServer.getServerConnector()).getMpdLevelData(-1);
        Vector vector2 = ((CollectionServerConnector)this.collectionServer.getServerConnector()).getMpdGroupList(n);
        Vector vector3 = ((CollectionServerConnector)this.collectionServer.getServerConnector()).getMpdFieldList(n);
        Vector vector4 = ((CollectionServerConnector)this.collectionServer.getServerConnector()).getMpdLevelFieldList(n);
        CsMpdTemplate csMpdTemplate = new CsMpdTemplate(n, ((CollectionServerConnector)this.collectionServer.getServerConnector()).getNextValidMpdId(), ((CollectionNode)this.collectionNodes.get(n)).getCollection(), vector, vector2, vector3, vector4);
        this.collectionServer.addmpdtDataObject(csMpdTemplate);
        ((CollectionNode)this.collectionNodes.get((Object)n)).mpdNode.updateInformationDisplay();
    }

    public void createNewMediaBatch(Integer n) {
        Collection collection = this.getCollectionNode(n).getCollection();
        this.collectionServer.addDataObject(new CcMediaBatch(n, this.collectionServer.getCollectionServerConnector().getNextMediaBatchID(), collection));
    }

    public void deleteMediaBatches(Vector vector) {
        if (this.insightAdministrator.showYesNoConfirmDialog("Are you sure you want to delete the selected media batches?", "Delete Confirmation")) {
            HashSet<Integer> hashSet = new HashSet<Integer>();
            for (int i = 0; i < vector.size(); ++i) {
                CcMediaBatch ccMediaBatch = (CcMediaBatch)vector.get(i);
                this.collectionServer.removeDataObject(ccMediaBatch);
                hashSet.add(ccMediaBatch.getUniqueCollectionID());
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                this.getCollectionNode((Integer)((Integer)iterator.next())).mediaBatchesNode.updateInformationDisplay();
            }
        }
    }

    public void createNewEntityField(Integer n) {
        this.collectionServer.addDataObject(new CcMedeEntityField(0, 0, this.getCatalogTemplateNode(n).getTemplate()));
    }

    public void removeEntityFields(Vector vector) {
        CollectionServerNode.debugOut("Removing Record fields: " + vector);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        if (this.insightAdministrator.showYesNoConfirmDialog("Are you sure you want to delete the selected record fields?", "Delete Confirmation")) {
            for (int i = 0; i < vector.size(); ++i) {
                CcMedeEntityField ccMedeEntityField = (CcMedeEntityField)vector.elementAt(i);
                this.collectionServer.removeDataObject(ccMedeEntityField);
                hashSet.add(ccMedeEntityField.getTemplate().getTemplateID());
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                this.getCatalogTemplateNode((Integer)((Integer)iterator.next())).entityFieldsNode.updateInformationDisplay();
            }
        }
    }

    public void editEntityField(CcMedeEntityField ccMedeEntityField) {
        CollectionServerNode.debugOut("Editing Record Field: " + ccMedeEntityField);
        this.collectionServer.editDataObject(ccMedeEntityField);
    }

    public void editMeasurementToolSettings(CsMeasurementToolSettings csMeasurementToolSettings) {
        CollectionServerNode.debugOut("Editing Measurement Tool Settings: " + csMeasurementToolSettings);
        this.collectionServer.editDataObject(csMeasurementToolSettings);
    }

    public void editMaxIDs(CsMaxIDs csMaxIDs) {
        CollectionServerNode.debugOut("Editing Max IDs: " + csMaxIDs);
        this.collectionServer.editDataObject(csMaxIDs);
    }

    public void editProfileMede(CcMedeProfile ccMedeProfile) {
        CollectionServerNode.debugOut("Editing profile (Inscribe): " + ccMedeProfile);
        this.collectionServer.editDataObject(ccMedeProfile);
    }

    public void editMedeApprovalLevels(CcMedeApprovalLevels ccMedeApprovalLevels) {
        CollectionServerNode.debugOut("Editing Inscribe approval levels: " + ccMedeApprovalLevels);
        this.collectionServer.editDataObject(ccMedeApprovalLevels);
    }

    public void createNewMedeEntityType(Integer n) {
        CatalogTemplate catalogTemplate = this.getCatalogTemplateNode(n).getTemplate();
        CollectionServerConnector collectionServerConnector = this.collectionServer.getCollectionServerConnector();
        this.collectionServer.addDataObject(new CcMedeEntityType(collectionServerConnector.getNextValidMedeEntityTypeID(), catalogTemplate, collectionServerConnector.getUnmappedFieldGroups()));
    }

    public void removeEntityTypes(Vector vector) {
        CollectionServerNode.debugOut("Removing Record Types: " + vector);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        if (this.insightAdministrator.showYesNoConfirmDialog("Are you sure you want to delete the selected record types?", "Delete Confirmation")) {
            for (int i = 0; i < vector.size(); ++i) {
                CcMedeEntityType ccMedeEntityType = (CcMedeEntityType)vector.elementAt(i);
                this.collectionServer.removeDataObject(ccMedeEntityType);
                hashSet.add(ccMedeEntityType.getTemplate().getTemplateID());
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                this.getCatalogTemplateNode((Integer)((Integer)iterator.next())).medeEntityTypesNode.updateInformationDisplay();
            }
        }
    }

    public void editEntityType(CcMedeEntityType ccMedeEntityType) {
        CollectionServerNode.debugOut("Editing Record Type: " + ccMedeEntityType);
        this.collectionServer.editDataObject(ccMedeEntityType);
    }

    public void createNewMedeEntityRelationship(Integer n) {
        CatalogTemplate catalogTemplate = this.getCatalogTemplateNode(n).getTemplate();
        this.collectionServer.addDataObject(new CcMedeEntityRelationship(this.collectionServer.getCollectionServerConnector(), 0, 0, catalogTemplate));
    }

    public void removeEntityRelationships(Vector vector) {
        CollectionServerNode.debugOut("Removing Record Relationships: " + vector);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        if (this.insightAdministrator.showYesNoConfirmDialog("Are you sure you want to delete the selected record relationships?", "Delete Confirmation")) {
            for (int i = 0; i < vector.size(); ++i) {
                CcMedeEntityRelationship ccMedeEntityRelationship = (CcMedeEntityRelationship)vector.elementAt(i);
                this.collectionServer.removeDataObject(ccMedeEntityRelationship);
                hashSet.add(ccMedeEntityRelationship.getTemplate().getTemplateID());
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                this.getCatalogTemplateNode((Integer)((Integer)iterator.next())).medeEntityRelationshipsNode.updateInformationDisplay();
            }
        }
    }

    public void editEntityRelationship(CcMedeEntityRelationship ccMedeEntityRelationship) {
        CollectionServerNode.debugOut("Editing Record Relationship: " + ccMedeEntityRelationship);
        this.collectionServer.editDataObject(ccMedeEntityRelationship);
    }

    public boolean isPersonalCollectionServer() {
        return this.isPersonalCollectionServer;
    }

    public static void debugOut(String string) {
        CollectionServerNode.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CollectionServerNode: " + string, n);
    }
}

