/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin;

import com.luna.insight.admin.AdminDesktopPane;
import com.luna.insight.admin.AdminFocusManager;
import com.luna.insight.admin.AdminServerAccessManager;
import com.luna.insight.admin.ControlPanelNode;
import com.luna.insight.admin.ControlPanelRootNode;
import com.luna.insight.admin.ControlWindow;
import com.luna.insight.admin.EditDialog;
import com.luna.insight.admin.InsightAdministratorAbout;
import com.luna.insight.admin.InsightAdministratorEncryptionWindow;
import com.luna.insight.admin.InsightAdministratorHelp;
import com.luna.insight.admin.InsightAdministratorToolBar;
import com.luna.insight.admin.WindowJMenuItem;
import com.luna.insight.admin.adminmetal.AdminMetalTheme;
import com.luna.insight.admin.collserver.CollectionServer;
import com.luna.insight.admin.collserver.CollectionServerNode;
import com.luna.insight.admin.collserver.CollectionServersRootNode;
import com.luna.insight.admin.collserver.mediacreation.InsightAdminMediaCreationConfig;
import com.luna.insight.admin.userserver.EncryptionUtilityRootNode;
import com.luna.insight.admin.userserver.UserServer;
import com.luna.insight.admin.userserver.UserServerNode;
import com.luna.insight.admin.userserver.UserServersRootNode;
import com.luna.insight.client.IconMaker;
import com.luna.insight.core.license.InsightLicenseClientManager;
import com.luna.insight.server.Debug;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.FocusManager;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class InsightAdministrator
implements ActionListener {
    public static final String WINDOW_ICON_PATH = "images/insight-icon.gif";
    public static final String FRAME_ICON_PATH = "images/insight-icon.gif";
    public static final String DEFAULT_NODE_ICON_PATH = "images/defaultnode-icon.gif";
    public static final String CONTROL_PANEL_ROOT_NODE_ICON_PATH = "images/root-node-icon.gif";
    public static final String NO_IMAGE_PATH = "images/noimage.gif";
    public static final String ENCRYPTION_ROOT_NODE_ICON_PATH = "images/encryption-root-node-icon.gif";
    public static final String USER_SERVERS_ROOT_NODE_ICON_PATH = "images/user-servers-root-node-icon.gif";
    public static final String USER_SERVER_NODE_ICON_PATH = "images/user-server-node-icon.gif";
    public static final String USER_SERVER_NODE_DISCONNECTED_ICON_PATH = "images/disconnected-user-server-node-icon.gif";
    public static final String USER_SERVER_COLLECTIONS_NODE_ICON_PATH = "images/user-server-collections-node-icon.gif";
    public static final String USER_SERVER_USERS_NODE_ICON_PATH = "images/user-server-users-node-icon.gif";
    public static final String USER_SERVER_USER_GROUPS_NODE_ICON_PATH = "images/user-server-user-groups-node-icon.gif";
    public static final String USER_SERVER_USER_SHARES_NODE_ICON_PATH = "images/user-server-user-groups-node-icon.gif";
    public static final String USER_SERVER_USER_PROFILES_NODE_ICON_PATH = "images/user-server-user-profiles-node-icon.gif";
    public static final String USER_SERVER_IMAGE_GROUP_FILES_NODE_ICON_PATH = "images/user-server-image-group-files-node-icon.gif";
    public static final String US_USER_GROUP_NODE_ICON_PATH = "images/us-user-group-node-icon.gif";
    public static final String US_IMAGE_GROUP_FILE_NODE_ICON_PATH = "images/us-image-group-file-node-icon.gif";
    public static final String COLLECTION_SERVERS_ROOT_NODE_ICON_PATH = "images/collection-servers-root-node-icon.gif";
    public static final String COLLECTION_SERVER_NODE_ICON_PATH = "images/collection-server-node-icon.gif";
    public static final String COLLECTION_SERVER_NODE_DISCONNECTED_ICON_PATH = "images/disconnected-collection-server-node-icon.gif";
    public static final String COLLECTION_SERVER_USER_GROUPS_NODE_ICON_PATH = "images/collection-server-user-groups-node-icon.gif";
    public static final String COLLECTION_SERVER_PROFILES_NODE_ICON_PATH = "images/collection-server-profiles-node-icon.gif";
    public static final String COLLECTION_SERVER_PROFILES_NODE_CHILD_ICON_PATH = "images/collection-server-profiles-node-child-icon.gif";
    public static final String COLLECTION_SERVER_MEDIA_GROUPS_NODE_ICON_PATH = "images/collection-server-media-groups-node-icon.gif";
    public static final String COLLECTION_SERVER_FIELD_STANDARDS_NODE_ICON_PATH = "images/collection-server-field-standards-node-icon.gif";
    public static final String COLLECTION_SERVER_CONNECTION_POOLS_NODE_ICON_PATH = "images/collection-server-connection-pools-node-icon.gif";
    public static final String COLLECTION_SERVER_CONFIGURATIONS_NODE_ICON_PATH = "images/collection-server-configurations-node-icon.gif";
    public static final String COLLECTION_SERVER_FIELDS_NODE_ICON_PATH = "images/collection-server-fields-node-icon.gif";
    public static final String COLLECTION_SERVER_FIELD_GROUPS_NODE_ICON_PATH = "images/collection-server-field-groups-node-icon.gif";
    public static final String COLLECTION_SERVER_VOCABULARIES_NODE_ICON_PATH = "images/collection-server-vocabularies-node-icon.gif";
    public static final String COLLECTION_SERVER_VOCAB_VALUES_NODE_ICON_PATH = "images/collection-server-vocab-values-node-icon.gif";
    public static final String COLLECTION_SERVER_TASKS_NODE_ICON_PATH = "images/collection-server-tasks-node-icon.gif";
    public static final String COLLECTION_SERVER_MPD_NODE_ICON_PATH = "images/collection-server-mpd-node-icon.gif";
    public static final String COLLECTION_SERVER_STOP_LIST_ICON_PATH = "images/collection-server-stop-list-node-icon.gif";
    public static final String COLLECTION_SERVER_TABLES_ICON_PATH = "images/collection-server-tables-node-icon.gif";
    public static final String COLLECTION_SERVER_JOINS_ICON_PATH = "images/collection-server-joins-node-icon.gif";
    public static final String COLLECTION_SERVER_LPS_ICON_PATH = "images/collection-server-lps-node-icon.gif";
    public static final String COLLECTION_SERVER_SPS_ICON_PATH = "images/collection-server-sps-node-icon.gif";
    public static final String COLLECTION_SERVER_MEDE_NODE_ICON_PATH = "images/collection-server-mede-node-icon.gif";
    public static final String COLLECTION_CREATION_INVOKE_INDEXER_ICON_PATH = "images/collection-creation-indexer-icon.gif";
    public static final String COLLECTION_CREATION_IMAGE_CREATION_ICON_PATH = "images/collection-creation-image-creation-icon.gif";
    public static final String COLLECTION_CREATION_OBJECT_IMAGE_MAP_ICON_PATH = "images/collection-creation-object-image-mapping-icon.gif";
    public static final String CC_PUBLISH_MEDIA_BATCH_ICON_PATH = "images/cc-publish-media-batch-icon.gif";
    public static final String ADMINISTERED_SERVER_ACCOUNTS_NODE_ICON_PATH = "images/administered-server-accounts-node-icon.gif";
    public static final String DEFAULT_CONFIG_FILE_PROPERTIES_ICON_PATH = "images/default-config-file-properites-icon.gif";
    public static final String STORE_FILE = "InsightAdminStore.dat";
    public static final String STORE_USER_SERVER_PREFIX = "UserServer";
    public static final String STORE_FIELD_TOKEN = "FieldToken";
    public static final String STORE_COLLECTION_SERVER_PREFIX = "CollectionServer";
    public static final String STORE_FIELD_DIVIDER = "|";
    public static final String STORE_MEDIA_GEN_CONFIG_KEY = "MediaGenerationConfig";
    public static final String STORE_RESAMPLE_DURING_RESIZE_KEY = "ResampleDuringResizeMode";
    public static final int MEDIA_GEN_USE_JAI = 0;
    public static final int MEDIA_GEN_USE_IMAGEJ = 1;
    public static final int MEDIA_GEN_USE_EXTERNAL_TOOL = 2;
    public static final String COMMAND_NEW_USER_SERVER = "New User Server Command";
    public static final String COMMAND_NEW_COLLECTION_SERVER = "New Collection Server Command";
    public static final String COMMAND_NEW_ENCRYPTION_DIALOG = "New Encryption";
    public static final String WINDOW_TITLE = "Insight Administration Console";
    public static final String ROOT_NODE_TITLE = "Console Root";
    public static final String ENCRYPT_ROOT_NODE_TITLE = "Encryption";
    public static final String USER_SERVERS_ROOT_NODE_TITLE = "User Managers";
    public static final String COLL_SERVERS_ROOT_NODE_TITLE = "Collection Managers";
    public static final String FILE_MENU_NAME = "File";
    public static final String NEW_WINDOW_MENU_ITEM_NAME = "New window";
    public static final String EXIT_MENU_ITEM_NAME = "Exit";
    public static final String EDIT_MENU_NAME = "Edit";
    public static final String MEDIA_GEN_MENU_ITEM_NAME = "JPEG Generation Configuration";
    public static final String HELP_MENU_NAME = "Help";
    public static final String HELP_MAIN = "Launch Help";
    public static final String HELP_LUNA = "Luna Imaging Home Page";
    public static final String HELP_ABOUT = "About Insight Administrator Tools";
    public static final String WINDOW_MENU_NAME = "Window";
    public static final String CASCADE_MENU_ITEM_NAME = "Cascade";
    public static final String TILE_MENU_ITEM_NAME = "Tile";
    public static final Dimension INITIAL_FRAME_SIZE = new Dimension(1024, 768);
    public static final String DEFAULT_HELP_FILE = "http://www.lunaimaging.com/admin/help.html";
    public static String HELP_FILE = "http://www.lunaimaging.com/admin/help.html";
    public static String HELP_FILE_KEY = "HelpFilename";
    public static boolean RESAMPLE_DURING_RESIZE = true;
    public static boolean LICENSED_JP2K_ENCODER = false;
    public static InsightLicenseClientManager licenseManager = null;
    public static final String LICENSE_FILE_PATH_KEY = "LicenseFilePath";
    public static final String DEFAULT_LICENSE_FILE_PATH = "License-Files";
    public static String licenseFilePath = "License-Files";
    public static String DEFAULT_WARN_JPEG2000_LICENSE = "1";
    public static InsightAdministrator insightAdministrator = null;
    public static ImageIcon NO_IMAGE = null;
    public static ImageIcon DEFAULT_NODE_ICON = null;
    public static ImageIcon FRAME_ICON = null;
    public static String FC_DIRECTORY_PATH = ".";
    protected static Vector existingUserServerNames = new Vector();
    protected static Vector existingCollectionServerNames = new Vector();
    protected JFrame mainFrame;
    protected AdminDesktopPane desktopPane;
    protected JMenuBar menuBar;
    protected JMenu fileMenu;
    protected JMenuItem newWindowMenuItem;
    protected JMenuItem exitMenuItem;
    protected JMenu editMenu;
    protected JMenuItem mediaGenerationMenuItem;
    protected JMenu windowMenu;
    protected JMenuItem cascadeMenuItem;
    protected JMenuItem tileMenuItem;
    protected JMenu helpMenu;
    protected JMenuItem launchHelpItem;
    protected JMenuItem launchLunaItem;
    protected JMenuItem aboutItem;
    protected DefaultTreeModel treeModel;
    protected ControlPanelRootNode root;
    protected ControlPanelNode encrypt;
    protected UserServersRootNode userServersRootNode;
    protected CollectionServersRootNode collectionServersRootNode;
    protected InsightAdministratorHelp helpController = null;
    protected InsightAdministratorAbout aboutWindow = null;
    protected EditDialog mediaGenerationConfigWindow = null;
    protected InsightAdministratorEncryptionWindow encryptionTesterWindow = null;

    public InsightAdministrator() {
        Properties properties = this.loadProperties(STORE_FILE);
        licenseFilePath = properties.getProperty(LICENSE_FILE_PATH_KEY, DEFAULT_LICENSE_FILE_PATH);
        licenseManager = new InsightLicenseClientManager(licenseFilePath);
        boolean bl = true;
        String string = properties.getProperty("WarnJPEG2KLicense", DEFAULT_WARN_JPEG2000_LICENSE);
        if (string.equalsIgnoreCase("No") || string.equalsIgnoreCase("0")) {
            bl = false;
        }
        if (!(LICENSED_JP2K_ENCODER = licenseManager.checkInsightJp2kEncoderLicense(bl))) {
            InsightAdministrator.debugOut("No Jpeg2000 Files will be generated during image processing.");
        }
        HELP_FILE = properties.getProperty(HELP_FILE_KEY, DEFAULT_HELP_FILE);
        this.helpController = new InsightAdministratorHelp();
        String string2 = properties.getProperty(STORE_RESAMPLE_DURING_RESIZE_KEY, RESAMPLE_DURING_RESIZE ? "1" : "0");
        RESAMPLE_DURING_RESIZE = !string2.equalsIgnoreCase("No") && !string2.equalsIgnoreCase("0");
        NO_IMAGE = IconMaker.createImage(NO_IMAGE_PATH);
        DEFAULT_NODE_ICON = IconMaker.createImage(DEFAULT_NODE_ICON_PATH);
        FRAME_ICON = IconMaker.createImage("images/insight-icon.gif");
        insightAdministrator = this;
        Debug.setDebugLevel(3);
        this.mainFrame = new JFrame();
        FocusManager.setCurrentManager(new AdminFocusManager());
        ImageIcon imageIcon = IconMaker.createImage("images/insight-icon.gif");
        if (imageIcon != null) {
            this.mainFrame.setIconImage(imageIcon.getImage());
        }
        MetalLookAndFeel.setCurrentTheme(new AdminMetalTheme());
        try {
            UIManager.setLookAndFeel(new MetalLookAndFeel(){

                protected void initClassDefaults(UIDefaults uIDefaults) {
                    super.initClassDefaults(uIDefaults);
                    String string = "javax.swing.plaf.metal.";
                    Object[] objectArray = new Object[]{"ButtonUI", string + "MetalButtonUI", "CheckBoxUI", string + "MetalCheckBoxUI", "RadioButtonUI", string + "MetalRadioButtonUI", "ToggleButtonUI", string + "MetalToggleButtonUI", "ProgressBarUI", string + "MetalProgressBarUI", "ScrollBarUI", string + "MetalScrollBarUI", "ScrollPaneUI", string + "MetalScrollPaneUI", "SplitPaneUI", string + "MetalSplitPaneUI", "SliderUI", string + "MetalSliderUI", "SeparatorUI", string + "MetalSeparatorUI", "PopupMenuSeparatorUI", string + "MetalPopupMenuSeparatorUI", "TabbedPaneUI", string + "MetalTabbedPaneUI", "TextFieldUI", string + "MetalTextFieldUI", "TreeUI", string + "MetalTreeUI", "LabelUI", string + "MetalLabelUI", "ToolBarUI", string + "MetalToolBarUI", "ToolTipUI", string + "MetalToolTipUI", "ComboBoxUI", string + "MetalComboBoxUI", "InternalFrameUI", "com.luna.insight.admin.adminmetal.MetalInternalFrameUI", "DesktopIconUI", string + "MetalDesktopIconUI", "FileChooserUI", string + "MetalFileChooserUI"};
                    uIDefaults.putDefaults(objectArray);
                }
            });
        }
        catch (Exception exception) {
            Debug.debugOut("Error installing look and feel: " + exception);
        }
        SwingUtilities.updateComponentTreeUI(this.mainFrame);
        this.mainFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this.mainFrame.setTitle(WINDOW_TITLE);
        this.root = new ControlPanelRootNode(this, ROOT_NODE_TITLE);
        this.encrypt = new EncryptionUtilityRootNode(this, ENCRYPT_ROOT_NODE_TITLE);
        this.userServersRootNode = new UserServersRootNode(this, USER_SERVERS_ROOT_NODE_TITLE);
        this.collectionServersRootNode = new CollectionServersRootNode(this, COLL_SERVERS_ROOT_NODE_TITLE);
        int n = AdminServerAccessManager.getServerAccessMode();
        switch (n) {
            case 1: {
                this.root.add(this.userServersRootNode);
                break;
            }
            case 2: {
                this.root.add(this.collectionServersRootNode);
                break;
            }
            default: {
                this.root.add(this.userServersRootNode);
                this.root.add(this.collectionServersRootNode);
            }
        }
        this.treeModel = new DefaultTreeModel(this.root);
        this.desktopPane = new AdminDesktopPane();
        this.menuBar = new JMenuBar();
        this.mainFrame.setJMenuBar(this.menuBar);
        this.fileMenu = new JMenu(FILE_MENU_NAME);
        this.fileMenu.setMnemonic(70);
        this.menuBar.add(this.fileMenu);
        this.exitMenuItem = new JMenuItem(EXIT_MENU_ITEM_NAME);
        this.exitMenuItem.setMnemonic(88);
        this.exitMenuItem.addActionListener(this);
        this.fileMenu.add(this.exitMenuItem);
        this.windowMenu = new JMenu(WINDOW_MENU_NAME){

            public void setPopupMenuVisible(boolean bl) {
                if (bl) {
                    try {
                        Component[] componentArray = this.getMenuComponents();
                        for (int i = 0; i < componentArray.length; ++i) {
                            if (!(componentArray[i] instanceof WindowJMenuItem)) continue;
                            this.remove(componentArray[i]);
                        }
                        JInternalFrame[] jInternalFrameArray = InsightAdministrator.this.desktopPane.getAllFrames();
                        for (int i = 0; i < jInternalFrameArray.length; ++i) {
                            this.add(new WindowJMenuItem(jInternalFrameArray[i], jInternalFrameArray[i].getTitle(), i, InsightAdministrator.this));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                super.setPopupMenuVisible(bl);
            }
        };
        this.windowMenu.setMnemonic(87);
        this.menuBar.add(this.windowMenu);
        this.newWindowMenuItem = new JMenuItem(NEW_WINDOW_MENU_ITEM_NAME, 78);
        this.newWindowMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.newWindowMenuItem.addActionListener(this);
        this.windowMenu.add(this.newWindowMenuItem);
        this.cascadeMenuItem = new JMenuItem(CASCADE_MENU_ITEM_NAME);
        this.cascadeMenuItem.addActionListener(this);
        this.cascadeMenuItem.setMnemonic(67);
        this.windowMenu.add(this.cascadeMenuItem);
        this.tileMenuItem = new JMenuItem(TILE_MENU_ITEM_NAME);
        this.tileMenuItem.addActionListener(this);
        this.tileMenuItem.setMnemonic(84);
        this.tileMenuItem.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        this.windowMenu.add(this.tileMenuItem);
        this.windowMenu.addSeparator();
        this.helpMenu = new JMenu(HELP_MENU_NAME);
        this.helpMenu.setMnemonic(72);
        this.launchHelpItem = new JMenuItem(HELP_MAIN);
        this.launchHelpItem.addActionListener(this);
        this.launchHelpItem.setMnemonic(72);
        this.launchHelpItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.helpMenu.add(this.launchHelpItem);
        this.launchLunaItem = new JMenuItem(HELP_LUNA);
        this.launchLunaItem.addActionListener(this);
        this.launchLunaItem.setMnemonic(76);
        this.helpMenu.add(this.launchLunaItem);
        this.aboutItem = new JMenuItem(HELP_ABOUT);
        this.aboutItem.addActionListener(this);
        this.aboutItem.setMnemonic(65);
        this.helpMenu.add(this.aboutItem);
        this.menuBar.add(this.helpMenu);
        Vector vector = this.getRegisteredUserServers();
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.elementAt(i) == null) continue;
            this.userServersRootNode.add(new UserServerNode((UserServer)vector.elementAt(i)));
        }
        this.setExistingUserServerNames();
        Vector vector2 = this.getRegisteredCollectionServers();
        for (int i = 0; i < vector2.size(); ++i) {
            if (vector2.elementAt(i) == null) continue;
            this.collectionServersRootNode.add(new CollectionServerNode((CollectionServer)vector2.elementAt(i)));
        }
        this.setExistingCollectionServerNames();
        InsightAdministratorToolBar insightAdministratorToolBar = new InsightAdministratorToolBar(this);
        this.mainFrame.getContentPane().setLayout(new BorderLayout());
        this.mainFrame.getContentPane().add((Component)this.desktopPane, "Center");
        this.mainFrame.getContentPane().add((Component)insightAdministratorToolBar, "North");
        this.mainFrame.setSize(INITIAL_FRAME_SIZE);
        this.mainFrame.show();
        ControlWindow controlWindow = new ControlWindow(this, this.treeModel, false);
        this.addToDesktop(controlWindow);
        try {
            controlWindow.setSelected(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public JFrame getFrame() {
        return this.mainFrame;
    }

    public AdminDesktopPane getDesktop() {
        return this.desktopPane;
    }

    public JInternalFrame getSelectedFrame() {
        return this.desktopPane.getSelectedFrame();
    }

    public ControlWindow getTopmostControlWindow() {
        Component[] componentArray = this.desktopPane.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof ControlWindow)) continue;
            return (ControlWindow)componentArray[i];
        }
        return null;
    }

    public void setSelectedFrame(JInternalFrame jInternalFrame) {
        try {
            jInternalFrame.setSelected(true);
            this.desktopPane.getDesktopManager().deiconifyFrame(jInternalFrame);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static InsightAdministrator getInsightAdministrator() {
        return insightAdministrator;
    }

    public void showWaitCursor(boolean bl) {
        if (bl) {
            if (this.mainFrame != null) {
                this.mainFrame.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
                this.mainFrame.getGlassPane().setVisible(true);
            }
        } else if (this.mainFrame != null) {
            this.mainFrame.getGlassPane().setCursor(Cursor.getDefaultCursor());
            this.mainFrame.getGlassPane().setVisible(false);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(NEW_WINDOW_MENU_ITEM_NAME)) {
            ControlWindow controlWindow = new ControlWindow(this, this.treeModel, true);
            this.addToDesktop(controlWindow);
            try {
                controlWindow.setSelected(true);
            }
            catch (Exception exception) {}
        } else if (actionEvent.getSource().equals(this.exitMenuItem)) {
            System.exit(0);
        } else if (actionEvent.getActionCommand().equals(CASCADE_MENU_ITEM_NAME)) {
            this.desktopPane.cascade();
        } else if (actionEvent.getActionCommand().equals(TILE_MENU_ITEM_NAME)) {
            this.desktopPane.tile();
        } else if (actionEvent.getActionCommand().equals(COMMAND_NEW_USER_SERVER)) {
            this.registerNewUserServer();
        } else if (actionEvent.getActionCommand().equals(COMMAND_NEW_ENCRYPTION_DIALOG)) {
            this.showEncryptionDialog();
        } else if (actionEvent.getActionCommand().equals(COMMAND_NEW_COLLECTION_SERVER)) {
            this.registerNewCollectionServer();
        } else if (actionEvent.getActionCommand().equals(HELP_MAIN)) {
            this.helpController.launchHelp();
        } else if (actionEvent.getActionCommand().equals(HELP_LUNA)) {
            this.helpController.launchLunaHome();
        } else if (actionEvent.getActionCommand().equals(HELP_ABOUT)) {
            this.showAboutWindow();
        } else if (actionEvent.getActionCommand().equals(MEDIA_GEN_MENU_ITEM_NAME)) {
            this.showMediaGenerationConfigDialog();
        } else if (actionEvent.getSource() instanceof WindowJMenuItem) {
            WindowJMenuItem windowJMenuItem = (WindowJMenuItem)actionEvent.getSource();
            this.setSelectedFrame((JInternalFrame)windowJMenuItem.getTargetWindow());
        }
    }

    public void showAboutWindow() {
        if (this.aboutWindow == null) {
            this.aboutWindow = new InsightAdministratorAbout(this);
            this.aboutWindow.show();
        } else {
            this.setSelectedFrame(this.aboutWindow);
        }
    }

    public void closeAboutWindow() {
        if (this.aboutWindow != null) {
            this.aboutWindow.closeDialog();
        }
        this.aboutWindow = null;
    }

    public void closeEncryptionWindow() {
        if (this.encryptionTesterWindow != null) {
            this.encryptionTesterWindow.closeDialog();
        }
        this.encryptionTesterWindow = null;
    }

    public void showMediaGenerationConfigDialog() {
        if (this.mediaGenerationConfigWindow == null) {
            InsightAdminMediaCreationConfig insightAdminMediaCreationConfig = new InsightAdminMediaCreationConfig(this, this.readMediaGenerationConfigurationValue());
            this.mediaGenerationConfigWindow = new EditDialog(insightAdministrator.getFrame(), true, insightAdminMediaCreationConfig);
            this.mediaGenerationConfigWindow.show();
        } else {
            insightAdministrator.setSelectedFrame(this.mediaGenerationConfigWindow);
        }
    }

    public void closeMediaGenerationConfigDialog() {
        this.mediaGenerationConfigWindow = null;
    }

    public void registerNewUserServer() {
        UserServer userServer = new UserServer("", this);
        userServer.edit();
    }

    public void showEncryptionDialog() {
        if (this.encryptionTesterWindow == null) {
            this.encryptionTesterWindow = new InsightAdministratorEncryptionWindow(this);
            Dimension dimension = this.mainFrame.getSize();
            this.encryptionTesterWindow.setBounds((dimension.width - this.encryptionTesterWindow.getWidth()) / 2, (dimension.height - this.encryptionTesterWindow.getHeight()) / 2, this.encryptionTesterWindow.getWidth(), this.encryptionTesterWindow.getHeight());
            this.encryptionTesterWindow.show();
        } else {
            insightAdministrator.setSelectedFrame(this.encryptionTesterWindow);
        }
    }

    public void registerNewUserServer(UserServer userServer) {
        if (userServer != null && userServer.creationCompleted) {
            if (userServer.parentNode == null) {
                this.userServersRootNode.add(new UserServerNode(userServer));
            }
            this.writeNewUserServerToDisc(userServer);
            this.reloadTreeModel(this.userServersRootNode);
        }
    }

    public void writeNewUserServerToDisc(UserServer userServer) {
        Properties properties = this.loadProperties(STORE_FILE);
        String string = properties.getProperty("UserServerNextNumber", "0");
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean bl = userServer.isPasswordRemembered();
        String string2 = userServer.getAccountPassword();
        if (!bl) {
            string2 = "";
        }
        String[] stringArray = new String[]{userServer.getName(), userServer.getConnectString(), userServer.getDatabaseConnector(), userServer.getJdbcDriverName(), userServer.getJdbcUrlPrefix(), userServer.getConfigFilePath(), userServer.getDatabaseUsername(), userServer.getDatabasePassword(), userServer.getAccountUsername(), string2, userServer.getImageGroupFilePath(), userServer.getGlobalEscapeDelimiter(), userServer.getUnicodeFieldPrefix()};
        String string3 = STORE_FIELD_DIVIDER;
        properties.setProperty(STORE_FIELD_TOKEN, string3);
        properties.setProperty(STORE_USER_SERVER_PREFIX + n, stringArray[0] + string3 + stringArray[1] + string3 + stringArray[2] + string3 + stringArray[3] + string3 + stringArray[4] + string3 + stringArray[5] + string3 + stringArray[6] + string3 + stringArray[7] + string3 + stringArray[8] + string3 + stringArray[9] + string3 + bl + string3 + stringArray[10] + string3 + stringArray[11] + string3 + stringArray[12]);
        properties.setProperty("UserServerNextNumber", "" + (n + 1));
        if (!existingUserServerNames.contains(userServer.getName())) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(STORE_FILE);
                properties.store(fileOutputStream, "Insight Admin Data Store");
                fileOutputStream.close();
            }
            catch (Exception exception) {
                InsightAdministrator.debugOut("Exception while trying to write user server data to disc: " + exception);
            }
        }
        this.setExistingUserServerNames();
    }

    protected String calculateFieldDelimiter(String[] stringArray) {
        String[] stringArray2 = new String[]{STORE_FIELD_DIVIDER, ":", "^", "~", "`", "#", "$", "*", "@", "!", "_", "-", "="};
        for (int i = 0; i < stringArray2.length; ++i) {
            boolean bl = false;
            for (int j = 0; j < stringArray.length && !bl; ++j) {
                if (stringArray[j].indexOf(stringArray2[i]) == -1) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return stringArray2[i];
        }
        return ";";
    }

    public void removeUserServerFromStore(String string) {
        if (string != null && string.length() > 0) {
            Object object;
            Properties properties = this.loadProperties(STORE_FILE);
            String string2 = properties.getProperty(STORE_FIELD_TOKEN, STORE_FIELD_DIVIDER);
            Properties properties2 = new Properties();
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string3;
                object = (String)enumeration.nextElement();
                if (!((String)object).startsWith(STORE_USER_SERVER_PREFIX)) {
                    string3 = properties.getProperty((String)object);
                    properties2.put(object, string3);
                    continue;
                }
                if (!((String)object).startsWith(STORE_USER_SERVER_PREFIX)) continue;
                string3 = properties.getProperty((String)object);
                String string4 = string;
                String string5 = "";
                StringTokenizer stringTokenizer = new StringTokenizer(string3, string2);
                if (!stringTokenizer.hasMoreTokens() || (string5 = stringTokenizer.nextToken()).equals(string4)) continue;
                properties2.put(object, string3);
            }
            try {
                object = new FileOutputStream(STORE_FILE);
                properties2.store((OutputStream)object, "Insight Admin Data Store");
                ((FileOutputStream)object).close();
            }
            catch (Exception exception) {
                InsightAdministrator.debugOut("Exception while trying to write user server data to disc: " + exception);
            }
        }
        this.setExistingUserServerNames();
    }

    protected Properties loadProperties(String string) {
        String string2 = string;
        Properties properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(string2);
            properties.load(fileInputStream);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            InsightAdministrator.debugOut("Cannot read configuration file. exc: " + iOException);
        }
        return properties;
    }

    protected Vector getRegisteredUserServers() {
        Properties properties = this.loadProperties(STORE_FILE);
        String string = properties.getProperty(STORE_FIELD_TOKEN, STORE_FIELD_DIVIDER);
        Enumeration<?> enumeration = properties.propertyNames();
        Vector<UserServer> vector = new Vector<UserServer>();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string2 == null || !string2.startsWith(STORE_USER_SERVER_PREFIX) || string2.equals("UserServerNextNumber")) continue;
            String string3 = string2.substring(STORE_USER_SERVER_PREFIX.length());
            UserServer userServer = this.parseUserServerData(string, properties.getProperty(string2, ""));
            if (userServer == null) continue;
            vector.addElement(userServer);
        }
        Collections.sort(vector);
        return vector;
    }

    private String[] constructTokenizedArray(String[] stringArray, String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
        boolean bl = false;
        int n = 0;
        while (stringTokenizer.hasMoreTokens() && n < stringArray.length) {
            String string3 = stringTokenizer.nextToken();
            if (string3.equals(string2)) {
                if (bl) {
                    ++n;
                    continue;
                }
                bl = true;
                continue;
            }
            bl = false;
            stringArray[n++] = string3;
        }
        return stringArray;
    }

    protected UserServer parseUserServerData(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        String[] stringArray = new String[]{"", "", "", "", "", "", "", "", "", "", "", null, "", ""};
        stringArray = this.constructTokenizedArray(stringArray, string2, string);
        UserServer userServer = new UserServer(stringArray[0], this);
        userServer.setConnectString(stringArray[1]);
        userServer.setDatabaseConnector(stringArray[2]);
        userServer.setJdbcDriverName(stringArray[3]);
        userServer.setJdbcUrlPrefix(stringArray[4]);
        userServer.setConfigFilePath(stringArray[5]);
        userServer.setDatabaseUsername(stringArray[6]);
        userServer.setDatabasePassword(stringArray[7]);
        userServer.setAccountUsername(stringArray[8]);
        userServer.setAccountPassword(stringArray[9]);
        try {
            userServer.setPasswordRemembered(Boolean.valueOf(stringArray[10]));
        }
        catch (Exception exception) {
            userServer.setPasswordRemembered(false);
        }
        userServer.setImageGroupFilePath(stringArray[11]);
        userServer.setGlobalEscapeDelimiter(stringArray[12]);
        userServer.setUnicodeFieldPrefix(stringArray[13]);
        userServer.creationCompleted = true;
        return userServer;
    }

    public void registerNewCollectionServer() {
        CollectionServer collectionServer = new CollectionServer("", this);
        collectionServer.edit();
    }

    public void registerNewCollectionServer(CollectionServer collectionServer) {
        if (collectionServer != null && collectionServer.creationCompleted) {
            if (collectionServer.parentNode == null) {
                this.collectionServersRootNode.add(new CollectionServerNode(collectionServer));
            }
            this.writeNewCollectionServerToDisc(collectionServer);
            this.reloadTreeModel(this.collectionServersRootNode);
        }
    }

    public void writeNewCollectionServerToDisc(CollectionServer collectionServer) {
        Properties properties = this.loadProperties(STORE_FILE);
        String string = properties.getProperty("CollectionServerNextNumber", "0");
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean bl = collectionServer.isPasswordRemembered();
        String string2 = collectionServer.getAccountPassword();
        if (!bl) {
            string2 = "";
        }
        String[] stringArray = new String[]{collectionServer.getName(), collectionServer.getConnectString(), collectionServer.getDatabaseConnector(), collectionServer.getJdbcDriverName(), collectionServer.getJdbcUrlPrefix(), collectionServer.getConfigFilePath(), collectionServer.getDatabaseUsername(), collectionServer.getDatabasePassword(), collectionServer.getAccountUsername(), string2, collectionServer.getLogBatchCommands() ? "1" : "0", collectionServer.getGlobalEscapeDelimiter() == null ? "" : collectionServer.getGlobalEscapeDelimiter(), collectionServer.getUnicodeFieldPrefix() == null ? "" : collectionServer.getUnicodeFieldPrefix()};
        String string3 = STORE_FIELD_DIVIDER;
        properties.setProperty(STORE_FIELD_TOKEN, string3);
        properties.setProperty(STORE_COLLECTION_SERVER_PREFIX + n, stringArray[0] + string3 + stringArray[1] + string3 + stringArray[2] + string3 + stringArray[3] + string3 + stringArray[4] + string3 + stringArray[5] + string3 + stringArray[6] + string3 + stringArray[7] + string3 + stringArray[8] + string3 + stringArray[9] + string3 + bl + string3 + collectionServer.getQueryMode() + string3 + stringArray[10] + string3 + stringArray[11] + string3 + stringArray[12]);
        properties.setProperty("CollectionServerNextNumber", "" + (n + 1));
        if (!existingCollectionServerNames.contains(collectionServer.getName())) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(STORE_FILE);
                properties.store(fileOutputStream, "Insight Admin Data Store");
                fileOutputStream.close();
            }
            catch (Exception exception) {
                InsightAdministrator.debugOut("Exception while trying to write user server data to disc: " + exception);
            }
        }
        this.setExistingCollectionServerNames();
    }

    public void removeCollectionServerFromStore(String string) {
        if (string != null && string.length() > 0) {
            Object object;
            Properties properties = this.loadProperties(STORE_FILE);
            String string2 = properties.getProperty(STORE_FIELD_TOKEN, STORE_FIELD_DIVIDER);
            Properties properties2 = new Properties();
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string3;
                object = (String)enumeration.nextElement();
                if (!((String)object).startsWith(STORE_COLLECTION_SERVER_PREFIX)) {
                    string3 = properties.getProperty((String)object);
                    properties2.put(object, string3);
                    continue;
                }
                if (!((String)object).startsWith(STORE_COLLECTION_SERVER_PREFIX)) continue;
                string3 = properties.getProperty((String)object);
                String string4 = string;
                String string5 = "";
                StringTokenizer stringTokenizer = new StringTokenizer(string3, string2);
                if (!stringTokenizer.hasMoreTokens() || (string5 = stringTokenizer.nextToken()).equals(string4)) continue;
                properties2.put(object, string3);
            }
            try {
                object = new FileOutputStream(STORE_FILE);
                properties2.store((OutputStream)object, "Insight Admin Data Store");
                ((FileOutputStream)object).close();
            }
            catch (Exception exception) {
                InsightAdministrator.debugOut("Exception while trying to write collection server data to disc: " + exception);
            }
        }
        this.setExistingCollectionServerNames();
    }

    protected Vector getRegisteredCollectionServers() {
        Properties properties = this.loadProperties(STORE_FILE);
        String string = properties.getProperty(STORE_FIELD_TOKEN, STORE_FIELD_DIVIDER);
        Enumeration<?> enumeration = properties.propertyNames();
        Vector<CollectionServer> vector = new Vector<CollectionServer>();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string2 == null || !string2.startsWith(STORE_COLLECTION_SERVER_PREFIX) || string2.equals("CollectionServerNextNumber")) continue;
            String string3 = string2.substring(STORE_COLLECTION_SERVER_PREFIX.length());
            CollectionServer collectionServer = this.parseCollectionServerData(string, properties.getProperty(string2, ""));
            if (collectionServer == null) continue;
            vector.addElement(collectionServer);
        }
        Collections.sort(vector);
        return vector;
    }

    protected CollectionServer parseCollectionServerData(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        String[] stringArray = new String[]{"", "", "", "", "", "", "", "", "", "", "", "", "", "", ""};
        stringArray = this.constructTokenizedArray(stringArray, string2, string);
        CollectionServer collectionServer = new CollectionServer(stringArray[0], this);
        collectionServer.setConnectString(stringArray[1]);
        collectionServer.setDatabaseConnector(stringArray[2]);
        collectionServer.setJdbcDriverName(stringArray[3]);
        collectionServer.setJdbcUrlPrefix(stringArray[4]);
        collectionServer.setConfigFilePath(stringArray[5]);
        collectionServer.setDatabaseUsername(stringArray[6]);
        collectionServer.setDatabasePassword(stringArray[7]);
        collectionServer.setAccountUsername(stringArray[8]);
        collectionServer.setAccountPassword(stringArray[9]);
        try {
            collectionServer.setPasswordRemembered(Boolean.valueOf(stringArray[10]));
        }
        catch (Exception exception) {
            collectionServer.setPasswordRemembered(false);
        }
        int n = 0;
        try {
            n = Integer.parseInt(stringArray[11]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        collectionServer.setQueryMode(n);
        boolean bl = false;
        try {
            bl = Integer.parseInt(stringArray[12]) == 1;
        }
        catch (Exception exception) {
            // empty catch block
        }
        collectionServer.setLogBatchCommands(bl);
        collectionServer.setGlobalEscapeDelimiter(stringArray[13]);
        collectionServer.setUnicodeFieldPrefix(stringArray[14]);
        collectionServer.creationCompleted = true;
        return collectionServer;
    }

    public void addToDesktop(JComponent jComponent) {
        this.desktopPane.add(jComponent);
    }

    public void reloadTreeModel() {
        this.treeModel.reload();
    }

    public void reloadTreeModel(TreeNode treeNode) {
        this.treeModel.reload(treeNode);
    }

    public void treeModelStructureChanged(TreeNode treeNode) {
        this.treeModel.nodeStructureChanged(treeNode);
    }

    public void setExistingUserServerNames() {
        Object object;
        existingUserServerNames = new Vector();
        Properties properties = new Properties();
        try {
            object = new FileInputStream(STORE_FILE);
            properties.load((InputStream)object);
            ((FileInputStream)object).close();
        }
        catch (IOException iOException) {
            InsightAdministrator.debugOut("Cannot read configuration file. exc: " + iOException);
        }
        object = properties.getProperty(STORE_FIELD_TOKEN, STORE_FIELD_DIVIDER);
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            StringTokenizer stringTokenizer;
            String string;
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(STORE_USER_SERVER_PREFIX) || (string = properties.getProperty(string2)).equals(null) && string.equals("") || (stringTokenizer = new StringTokenizer(string, (String)object)) == null || !stringTokenizer.hasMoreElements()) continue;
            String string3 = (String)stringTokenizer.nextElement();
            existingUserServerNames.addElement(string3);
        }
    }

    public static Vector getExistingUserServerNames(String string) {
        Vector vector = (Vector)existingUserServerNames.clone();
        vector.remove(string);
        return vector;
    }

    public void setExistingCollectionServerNames() {
        Object object;
        existingCollectionServerNames = new Vector();
        Properties properties = new Properties();
        try {
            object = new FileInputStream(STORE_FILE);
            properties.load((InputStream)object);
            ((FileInputStream)object).close();
        }
        catch (IOException iOException) {
            InsightAdministrator.debugOut("Cannot read configuration file. exc: " + iOException);
        }
        object = properties.getProperty(STORE_FIELD_TOKEN, STORE_FIELD_DIVIDER);
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            StringTokenizer stringTokenizer;
            String string;
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(STORE_COLLECTION_SERVER_PREFIX) || (string = properties.getProperty(string2)).equals(null) && string.equals("") || (stringTokenizer = new StringTokenizer(string, (String)object)) == null || !stringTokenizer.hasMoreElements()) continue;
            String string3 = (String)stringTokenizer.nextElement();
            existingCollectionServerNames.addElement(string3);
        }
    }

    public static Vector getExistingCollectionServerNames(String string) {
        Vector vector = (Vector)existingCollectionServerNames.clone();
        vector.remove(string);
        return vector;
    }

    public static void showWarningDialog(Component component, String string, String string2) {
        JOptionPane.showInternalMessageDialog(component, string, string2, 2);
    }

    public void showWarningDialog(String string, String string2) {
        InsightAdministrator.showWarningDialog(this.getSelectedFrame(), string, string2);
    }

    public static void showIncompleteFeatureWarning() {
        InsightAdministrator.getInsightAdministrator().showWarningDialog("This section is incomplete; use at your own risk.", "Incomplete Feature");
    }

    public boolean showYesNoConfirmDialog(String string, String string2) {
        return 0 == JOptionPane.showInternalConfirmDialog(this.getSelectedFrame(), string, string2, 0, 3);
    }

    public boolean readResampleDuringResize() {
        return RESAMPLE_DURING_RESIZE;
    }

    public int readMediaGenerationConfigurationValue() {
        Properties properties = this.loadProperties(STORE_FILE);
        int n = 1;
        if (properties.containsKey(STORE_MEDIA_GEN_CONFIG_KEY)) {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (string == null || !string.equals(STORE_MEDIA_GEN_CONFIG_KEY)) continue;
                String string2 = properties.getProperty(string, "1");
                try {
                    n = Integer.parseInt(string2);
                }
                catch (Exception exception) {}
            }
        }
        return n;
    }

    public void writeMediaGenerationConfigurationValue(int n) {
        Properties properties = this.loadProperties(STORE_FILE);
        properties.put(STORE_MEDIA_GEN_CONFIG_KEY, n + "");
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(STORE_FILE);
            properties.store(fileOutputStream, "Insight Admin Data Store");
            fileOutputStream.close();
        }
        catch (Exception exception) {
            InsightAdministrator.debugOut("Exception while trying to write media generation config to disc: " + exception);
        }
    }

    public static void debugOut(String string) {
        InsightAdministrator.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("InsightAdministrator: " + string, n);
    }

    public static void main(String[] stringArray) {
        new InsightAdministrator();
    }
}

