/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin;

import com.luna.insight.admin.ControlPanelNode;
import com.luna.insight.admin.ControlPanelRootNode;
import com.luna.insight.admin.ControlTreeRenderer;
import com.luna.insight.admin.InsightAdministrator;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ControlWindow
extends JInternalFrame
implements TreeSelectionListener,
MouseListener {
    protected static final String FRAME_TITLE = "Control Panel";
    protected static int instanceNumber = 1;
    protected JTree controlTree = null;
    protected JScrollPane treeScrollPane = null;
    protected JScrollPane displayScrollPane = null;
    protected JComponent infoComponent = null;
    protected JSplitPane splitPane = null;
    protected InsightAdministrator insightAdministrator = null;
    protected ControlPanelRootNode root = null;
    protected DefaultTreeModel treeModel = null;
    protected Dimension defaultSize = new Dimension(700, 500);

    public static void debugOut(String string) {
        ControlWindow.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("ControlWindow: " + string, n);
    }

    public ControlWindow(InsightAdministrator insightAdministrator, DefaultTreeModel defaultTreeModel, boolean bl) {
        super(FRAME_TITLE, true, bl, true, true);
        String string = instanceNumber == 1 ? "Control Panel - Main" : "Control Panel - Instance " + instanceNumber;
        this.setTitle(string);
        ++instanceNumber;
        this.insightAdministrator = insightAdministrator;
        this.controlTree = new JTree(defaultTreeModel);
        this.controlTree.setCellRenderer(new ControlTreeRenderer());
        this.controlTree.putClientProperty("JTree.lineStyle", "Angled");
        this.controlTree.getSelectionModel().setSelectionMode(1);
        this.controlTree.addTreeSelectionListener(this);
        this.controlTree.addMouseListener(this);
        this.controlTree.setVisible(true);
        this.controlTree.setShowsRootHandles(false);
        this.treeScrollPane = new JScrollPane();
        this.treeScrollPane.setMinimumSize(new Dimension(50, 50));
        this.treeScrollPane.setPreferredSize(new Dimension(200, 100));
        this.treeScrollPane.add(this.controlTree);
        this.treeScrollPane.setViewportView(this.controlTree);
        this.displayScrollPane = new JScrollPane();
        this.displayScrollPane.setMinimumSize(new Dimension(50, 50));
        this.displayScrollPane.setPreferredSize(new Dimension(200, 100));
        this.splitPane = new JSplitPane(1, this.treeScrollPane, this.displayScrollPane);
        this.splitPane.setDividerSize(5);
        this.getContentPane().add(this.splitPane);
        ImageIcon imageIcon = IconMaker.createImage("images/insight-icon.gif");
        imageIcon = new ImageIcon(imageIcon.getImage().getScaledInstance(16, 16, 4));
        if (imageIcon != null) {
            this.setFrameIcon(imageIcon);
        }
        this.setPreferredSize(this.defaultSize);
        this.setSize(this.defaultSize);
        this.setVisible(true);
    }

    public JTree getControlTree() {
        return this.controlTree;
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath = treeSelectionEvent.getPath();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.controlTree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode instanceof ControlPanelNode) {
            this.displayNodeInfo((ControlPanelNode)defaultMutableTreeNode);
        }
        this.repaint();
    }

    protected void displayNodeInfo(ControlPanelNode controlPanelNode) {
        this.infoComponent = controlPanelNode.getDisplayComponent();
        this.displayScrollPane.setViewportView(this.infoComponent);
        this.refreshDisplayedInfo();
    }

    protected void refreshDisplayedInfo() {
        this.infoComponent.invalidate();
        this.infoComponent.validate();
        this.infoComponent.doLayout();
        this.infoComponent.repaint();
        this.displayScrollPane.validate();
        this.displayScrollPane.doLayout();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.maybeShowPopup(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    private void maybeShowPopup(MouseEvent mouseEvent) {
        TreePath treePath = this.controlTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath != null) {
            JPopupMenu jPopupMenu;
            TreeNode treeNode;
            this.controlTree.setSelectionPath(treePath);
            if ((mouseEvent.getModifiers() & 4) == 4 && (treeNode = (TreeNode)treePath.getLastPathComponent()) instanceof ControlPanelNode && (jPopupMenu = ((ControlPanelNode)treeNode).getPopup()) != null) {
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

