/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin;

import com.luna.insight.admin.AdminAccount;
import com.luna.insight.admin.AdminAccountRecordHandler;
import com.luna.insight.admin.AdministeredServer;
import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.LoginFailedException;
import com.luna.insight.admin.RecordCommitFailedException;
import com.luna.insight.admin.RecordDeleteFailedException;
import com.luna.insight.admin.collserver.CollectionServer;
import com.luna.insight.admin.collserver.CollectionServerConnector;
import com.luna.insight.server.Debug;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.backend.DatabaseConnector;
import com.luna.insight.server.backend.DatabaseConnectorGenerator;
import com.luna.insight.server.backend.SqlQueryGenerator;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.Vector;

public abstract class AdministeredServerConnector {
    public static final String JDBC_CONNECTOR = "JDBC";
    public static final String RDO_CONNECTOR = "RDO";
    public static final String ADO_CONNECTOR = "ADO";
    public static final int DEBUG_LEVEL = 3;
    public static final String DEBUG_FILENAME = "Insight-Backend.txt";
    public String VERSION_ID = "2.02 (09July2001)";
    public String COMPONENT_CODE = "AdministeredServerConnector";
    public static final int DEFAULT_QUERY_MODE = 0;
    public static final boolean DEFAULT_USE_DISTINCT_KEYWORD = true;
    public static String TABLE_ADMIN_ACCOUNTS = "IAADMINISTRATIONACCOUNTS";
    public static String CANDIDATE_INDEX_NAME = "CandidateIndex";
    protected String connectString = "";
    protected boolean msAccessMode = false;
    protected boolean useDistinctKeyword = true;
    protected String distinctKeyword = "DISTINCT";
    protected DatabaseConnectorGenerator dbConnectorGenerator = null;
    protected AdministeredServer server = null;
    protected AdminAccountRecordHandler adminAccountHandler = new AdminAccountRecordHandler(this);

    public static void debugFile(String string) {
        AdministeredServerConnector.debugFile(string, 3);
    }

    public static void debugFile(String string, int n) {
        if (n <= 2 && DEBUG_FILENAME != null) {
            try {
                FileWriter fileWriter = new FileWriter(DEBUG_FILENAME, true);
                fileWriter.write(new Date() + ": " + string + "\r\n");
                fileWriter.flush();
                fileWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void setConnectString(String string) {
        if (string != null) {
            this.connectString = string;
        } else {
            AdministeredServerConnector.debugFile("setConnectString received null.");
        }
    }

    public AdministeredServer getAdministeredServer() {
        return this.server;
    }

    public AdminAccount login(String string, String string2) throws LoginFailedException {
        AdminAccount adminAccount = null;
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            if (this instanceof CollectionServerConnector) {
                sqlQueryGenerator.addTable("IRVERSION", null, "*");
                databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                this.debugOut("Database version query: " + databaseConnector.getQuery());
                databaseConnector.runQuery();
                float f = 0.0f;
                boolean bl = false;
                if (databaseConnector.more()) {
                    String string3 = databaseConnector.getFieldByName("Version");
                    try {
                        f = Float.parseFloat(string3);
                    }
                    catch (Exception exception) {
                        this.debugOut("Exception parsing DB version: not a float: " + exception);
                    }
                    try {
                        bl = databaseConnector.getIntegerFieldByName("IsInscribeCompliant") == 1;
                    }
                    catch (Exception exception) {
                        this.debugOut("Exception parsing DB IsInscribeCompliant: " + exception);
                    }
                } else {
                    throw new LoginFailedException("Unable to connect to database, verify the database connection properties.");
                }
                if ((double)f < 5.0) {
                    throw new LoginFailedException("Can only administer collection managers of version 5.0 and higher.  Version is " + f);
                }
                if (this.server instanceof CollectionServer) {
                    ((CollectionServer)this.server).setCollectionServerVersion(f);
                    ((CollectionServer)this.server).setCollectionServerInscribeCompliant(bl);
                }
                if (this.server instanceof CollectionServer) {
                    ((CollectionServer)this.server).setMedeEnabled(true);
                    this.debugOut("Collection Server Inscribe-enabled: " + ((CollectionServer)this.server).isMedeEnabled());
                }
                if (this.server instanceof CollectionServer) {
                    ((CollectionServer)this.server).setMeasurementToolSettingEnabled(true);
                    ((CollectionServer)this.server).setMaxIDsEnabled(true);
                }
            }
            sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable(TABLE_ADMIN_ACCOUNTS, null, "*");
            sqlQueryGenerator.appendToWhere("Username = " + sqlQueryGenerator.prepStringForQuery(string) + " AND Password = " + sqlQueryGenerator.prepStringForQuery(string2));
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Login query: " + databaseConnector.getQuery());
            databaseConnector.runQuery();
            if (!databaseConnector.more()) {
                throw new LoginFailedException("That is not a valid username and password combination.");
            }
            adminAccount = new AdminAccount(this.server, databaseConnector.getIntegerFieldByName("AdminID"), databaseConnector.getFieldByName("Username"), databaseConnector.getFieldByName("Password"), databaseConnector.getIntegerFieldByName("ServerAdminPermissions"), databaseConnector.getIntegerFieldByName("AccountAdminPermissions"), databaseConnector.getFieldByName("CreatedTimestamp"));
            databaseConnector.close();
            databaseConnector.close();
        }
        catch (Exception exception) {
            if (exception instanceof LoginFailedException) {
                throw (LoginFailedException)exception;
            }
            this.debugOut("Exception in login(): " + InsightUtilities.getStackTrace(exception));
        }
        return adminAccount;
    }

    public Vector getAdminAccountRecords() {
        return this.adminAccountHandler.getRecords();
    }

    public void commitRecord(DatabaseRecord databaseRecord) throws RecordCommitFailedException {
        if (databaseRecord != null && databaseRecord instanceof AdminAccount) {
            this.adminAccountHandler.commitRecord(databaseRecord);
        }
    }

    public void deleteRecord(DatabaseRecord databaseRecord) throws RecordDeleteFailedException {
        if (databaseRecord != null && databaseRecord instanceof AdminAccount) {
            this.adminAccountHandler.deleteRecord(databaseRecord);
        }
    }

    public AdminAccount getAdminAccount(int n) {
        return (AdminAccount)this.adminAccountHandler.getAdminAccount(n);
    }

    public int getNextValidAdminAccountID() {
        return this.adminAccountHandler.getNextValidID();
    }

    public int findFirstAvailableIndex(Vector vector) {
        try {
            if (vector != null) {
                boolean bl = false;
                int n = 0;
                while (vector.contains(new Integer(++n))) {
                }
                return n;
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in findFirstAvailableIndex(): " + exception);
            return -1;
        }
        return -1;
    }

    public DatabaseConnector getDatabaseConnector() {
        return this.dbConnectorGenerator.getConnector(this.connectString);
    }

    public DatabaseConnectorGenerator getDatabaseConnectorGenerator() {
        return this.dbConnectorGenerator;
    }

    public SqlQueryGenerator getQueryGenerator() {
        if (this.server != null) {
            return this.server.getQueryGenerator();
        }
        return new SqlQueryGenerator(0, null, null);
    }

    public SqlQueryGenerator getQueryGeneratorUtil() {
        if (this.server != null) {
            return this.server.getQueryGeneratorUtil();
        }
        return new SqlQueryGenerator(0, null, null);
    }

    public void quickQuery(String string) {
        this.debugOut("Quick-query: " + string);
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            databaseConnector.setQuery(string);
            databaseConnector.runQuery();
        }
        catch (Exception exception) {
            this.debugOut("Exception in quickQuery: " + exception);
        }
        databaseConnector.close();
    }

    protected void debugOut(String string, int n) {
        Debug.debugOut(this.COMPONENT_CODE + ": " + string, n);
    }

    protected void debugOut(String string) {
        Debug.debugOut(this.COMPONENT_CODE + ": " + string, 3);
    }
}

