/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin;

import com.luna.insight.admin.AdminAccount;
import com.luna.insight.admin.AdministeredServerConfigurationFileProperties;
import com.luna.insight.admin.AdministeredServerConnector;
import com.luna.insight.admin.AdministeredServerEditComponent;
import com.luna.insight.admin.AdministeredServerNode;
import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.DefaultConfigurationFileProperties;
import com.luna.insight.admin.EditDialog;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.InsightAdministrator;
import com.luna.insight.admin.LoginFailedException;
import com.luna.insight.admin.RecordCommitFailedException;
import com.luna.insight.admin.RecordDeleteFailedException;
import com.luna.insight.admin.mpdtEditDialog;
import com.luna.insight.server.Debug;
import com.luna.insight.server.backend.SqlQueryGenerator;
import java.io.File;
import java.io.FileInputStream;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public abstract class AdministeredServer
extends EditableDataObject
implements Comparable {
    protected String name = "";
    protected InsightAdministrator insightAdministrator = null;
    protected boolean isConnected = false;
    protected EditDialog propertiesEditDialog = null;
    protected EditDialog defaultPropertiesEditDialog = null;
    protected Hashtable adminAccountsTable = new Hashtable();
    protected AdministeredServerConfigurationFileProperties configFileProperties = null;
    protected DefaultConfigurationFileProperties defaultConfigFileProperties = null;
    protected AdministeredServerConnector serverConnector = null;
    protected AdministeredServerEditComponent editComponent = null;
    protected String oldName = null;
    protected EditDialog editDialog = null;
    protected AdminAccount adminAccount = null;
    protected AdministeredServerNode parentNode = null;
    protected String connectString = "";
    protected int queryMode = 0;
    protected String globalEscapeDelimiter = "";
    protected String unicodeFieldPrefix = "";
    protected SqlQueryGenerator sqlQueryGeneratorUtil = new SqlQueryGenerator(0, null, null);
    protected String databaseConnector = "";
    protected String jdbcDriverName = "";
    protected String jdbcUrlPrefix = "";
    protected String databaseUsername = "";
    protected String databasePassword = "";
    protected String accountUsername = "";
    protected String accountPassword = "";
    protected String configFilePath = "";
    protected boolean logBatchCommands = false;
    protected boolean passwordRemembered = false;

    public AdministeredServer(String string, InsightAdministrator insightAdministrator) {
        this.name = string;
        this.insightAdministrator = insightAdministrator;
    }

    public int compareTo(Object object) {
        if (object == null) {
            return -1;
        }
        String string = ((AdministeredServer)object).name;
        return this.name.compareTo(string);
    }

    public boolean connect(String string, String string2) {
        this.accountUsername = string;
        this.accountPassword = string2;
        if (this.accountUsername == null || this.accountPassword == null) {
            return false;
        }
        this.saveToDisk();
        try {
            this.adminAccount = this.getServerConnector().login(this.accountUsername, this.accountPassword);
        }
        catch (LoginFailedException loginFailedException) {
            this.adminAccount = null;
            this.insightAdministrator.showWarningDialog(loginFailedException.getMessage(), "Login Failed");
        }
        if (this.adminAccount != null) {
            this.isConnected = true;
        } else {
            this.isConnected = false;
            this.serverConnector = null;
        }
        return this.isConnected;
    }

    public boolean disconnect() {
        this.isConnected = false;
        this.serverConnector = null;
        return !this.isConnected;
    }

    public String getName() {
        return this.name;
    }

    public abstract void saveToDisk();

    public abstract void commitEdit();

    public abstract String getConnectStringKey();

    public void loadEditComponentFromConfigFile() {
        block24: {
            try {
                String string;
                if (this.editComponent == null || (string = this.editComponent.getConfigFileNameField().getText()) == null || string.length() <= 0) break block24;
                String string2 = null;
                String string3 = null;
                String string4 = null;
                String string5 = null;
                String string6 = null;
                String string7 = null;
                String string8 = null;
                String string9 = null;
                String string10 = null;
                boolean bl = false;
                Properties properties = new Properties();
                AdministeredServer.debugOut("InsightServer file is " + string + ".", 3);
                FileInputStream fileInputStream = new FileInputStream(string);
                properties.load(fileInputStream);
                fileInputStream.close();
                if (properties != null) {
                    string2 = properties.getProperty(this.getConnectStringKey());
                    string8 = properties.getProperty("DefaultUsername");
                    string9 = properties.getProperty("DefaultPassword");
                    string3 = properties.getProperty("DatabaseConnector");
                    string4 = properties.getProperty("GlobalEscapeDelimiter");
                    string5 = properties.getProperty("UnicodeFieldPrefix");
                    string10 = properties.getProperty("DatabaseQueryMode");
                    if (string3 != null && string3.equals("JDBC")) {
                        bl = true;
                    }
                    if (bl) {
                        string6 = properties.getProperty("JDBCDriverName");
                        string7 = properties.getProperty("JDBCUrlPrefix");
                    }
                    if (string3 == null || string3.length() == 0 || bl && (string6 == null || string6.length() == 0) || bl && (string7 == null || string7.length() == 0) || string8 == null || string8.length() == 0 || string9 == null || string9.length() == 0) {
                        try {
                            File file = new File(string);
                            String string11 = file.getParent() + File.separator + "InsightBackend.dat";
                            Properties properties2 = new Properties();
                            AdministeredServer.debugOut("InsightBackend file is " + string11 + ".", 3);
                            FileInputStream fileInputStream2 = new FileInputStream(string11);
                            properties2.load(fileInputStream2);
                            fileInputStream2.close();
                            if (string3 == null) {
                                string3 = properties2.getProperty("DatabaseConnector");
                            }
                            if (string3 != null && string3.equals("JDBC")) {
                                bl = true;
                            }
                            if (bl) {
                                if (string6 == null) {
                                    string6 = properties2.getProperty("JDBCDriverName");
                                }
                                if (string7 == null) {
                                    string7 = properties2.getProperty("JDBCUrlPrefix");
                                }
                            }
                            if (string8 == null) {
                                string8 = properties2.getProperty("DefaultUsername");
                            }
                            if (string9 == null) {
                                string9 = properties2.getProperty("DefaultPassword");
                            }
                        }
                        catch (Exception exception) {
                            AdministeredServer.debugOut("Exception while loading InsightBackend.dat: " + exception);
                        }
                    }
                }
                if (string2 != null) {
                    this.editComponent.getConnectStringField().setText(string2);
                }
                if (string8 != null) {
                    this.editComponent.getDatabaseUsernameField().setText(string8);
                }
                if (string9 != null) {
                    this.editComponent.getDatabasePasswordField().setText(string9);
                }
                if (string3 != null) {
                    this.editComponent.getDatabaseConnectorComboBox().setSelectedItem(string3);
                }
                if (string4 != null) {
                    this.editComponent.getGlobalEscapeDelimiterField().setText(string4);
                }
                if (string5 != null) {
                    this.editComponent.getUnicodeFieldPrefixField().setText(string5);
                }
                if (string6 != null) {
                    this.editComponent.getJdbcDriverNameField().setText(string6);
                }
                if (string7 != null) {
                    this.editComponent.getJdbcUrlPrefixField().setText(string7);
                }
                if (string10 != null) {
                    this.editComponent.getSqlLevelComboBox().setSelectedIndex(Integer.parseInt(string10));
                }
            }
            catch (Exception exception) {
                AdministeredServer.debugOut("Exception in loadEditComponentFromConfigFile(): " + exception);
            }
        }
    }

    public void save() {
        AdministeredServer.debugOut("Save...", 3);
        this.requiresCommit = false;
        if (this.hasChanged(this.name, this.editComponent.getNameField().getText())) {
            this.name = this.editComponent.getNameField().getText();
        }
        if (this.hasChanged(this.connectString, this.editComponent.getConnectStringField().getText())) {
            this.connectString = this.editComponent.getConnectStringField().getText();
        }
        if (this.hasChanged(this.databaseUsername, this.editComponent.getDatabaseUsernameField().getText())) {
            this.databaseUsername = this.editComponent.getDatabaseUsernameField().getText();
        }
        if (this.hasChanged(this.databasePassword, new String(this.editComponent.getDatabasePasswordField().getPassword()))) {
            this.databasePassword = new String(this.editComponent.getDatabasePasswordField().getPassword());
        }
        if (this.hasChanged((Object)this.databaseConnector, this.editComponent.getDatabaseConnectorComboBox().getSelectedItem())) {
            this.databaseConnector = (String)this.editComponent.getDatabaseConnectorComboBox().getSelectedItem();
        }
        if (this.hasChanged(this.globalEscapeDelimiter, this.editComponent.getGlobalEscapeDelimiterField().getText())) {
            this.globalEscapeDelimiter = this.editComponent.getGlobalEscapeDelimiterField().getText();
        }
        if (this.hasChanged(this.unicodeFieldPrefix, this.editComponent.getUnicodeFieldPrefixField().getText())) {
            this.unicodeFieldPrefix = this.editComponent.getUnicodeFieldPrefixField().getText();
        }
        if (this.hasChanged(this.jdbcDriverName, this.editComponent.getJdbcDriverNameField().getText())) {
            this.jdbcDriverName = this.editComponent.getJdbcDriverNameField().getText();
        }
        if (this.hasChanged(this.jdbcUrlPrefix, this.editComponent.getJdbcUrlPrefixField().getText())) {
            this.jdbcUrlPrefix = this.editComponent.getJdbcUrlPrefixField().getText();
        }
        if (this.hasChanged(this.configFilePath, this.editComponent.getConfigFileNameField().getText())) {
            this.configFilePath = this.editComponent.getConfigFileNameField().getText();
        }
        if (this.hasChanged(this.queryMode, this.editComponent.getSqlLevelComboBox().getSelectedIndex())) {
            this.queryMode = this.editComponent.getSqlLevelComboBox().getSelectedIndex();
        }
        if (this.hasChanged(this.logBatchCommands, this.editComponent.getLogBatchCommandsCheckBox().isSelected())) {
            this.logBatchCommands = this.editComponent.getLogBatchCommandsCheckBox().isSelected();
        }
        this.sqlQueryGeneratorUtil = this.getQueryGenerator();
        this.creationCompleted = true;
        this.serverConnector = null;
        if (this.requiresCommit) {
            this.commitEdit();
        }
        this.editDialog = null;
    }

    public void cancel() {
        AdministeredServer.debugOut("Cancel...", 3);
        this.editComponent = null;
        this.editDialog = null;
    }

    public String getConnectString() {
        return this.connectString;
    }

    public int getQueryMode() {
        return this.queryMode;
    }

    public void setQueryMode(int n) {
        this.queryMode = n;
        this.sqlQueryGeneratorUtil = this.getQueryGenerator();
    }

    public void setQueryMode(String string) {
        try {
            this.queryMode = Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sqlQueryGeneratorUtil = this.getQueryGenerator();
    }

    public boolean getLogBatchCommands() {
        return this.logBatchCommands;
    }

    public void setLogBatchCommands(boolean bl) {
        this.logBatchCommands = bl;
    }

    public String getDatabaseConnector() {
        return this.databaseConnector;
    }

    public String getGlobalEscapeDelimiter() {
        return this.globalEscapeDelimiter;
    }

    public String getUnicodeFieldPrefix() {
        return this.unicodeFieldPrefix;
    }

    public String getJdbcDriverName() {
        return this.jdbcDriverName;
    }

    public String getJdbcUrlPrefix() {
        return this.jdbcUrlPrefix;
    }

    public String getConfigFilePath() {
        return this.configFilePath;
    }

    public String getDatabaseUsername() {
        return this.databaseUsername;
    }

    public String getDatabasePassword() {
        return this.databasePassword;
    }

    public void setConnectString(String string) {
        this.connectString = string;
    }

    public void setDatabaseConnector(String string) {
        this.databaseConnector = string;
    }

    public void setGlobalEscapeDelimiter(String string) {
        this.globalEscapeDelimiter = string;
        this.sqlQueryGeneratorUtil = this.getQueryGenerator();
    }

    public void setUnicodeFieldPrefix(String string) {
        this.unicodeFieldPrefix = string;
        this.sqlQueryGeneratorUtil = this.getQueryGenerator();
    }

    public void setJdbcDriverName(String string) {
        this.jdbcDriverName = string;
    }

    public void setJdbcUrlPrefix(String string) {
        this.jdbcUrlPrefix = string;
    }

    public void setConfigFilePath(String string) {
        this.configFilePath = string;
    }

    public void setDatabaseUsername(String string) {
        this.databaseUsername = string;
    }

    public void setDatabasePassword(String string) {
        this.databasePassword = string;
    }

    public AdminAccount getAdminAccount() {
        return this.adminAccount;
    }

    public String getAccountUsername() {
        return this.accountUsername;
    }

    public String getAccountPassword() {
        return this.accountPassword;
    }

    public void setAccountUsername(String string) {
        this.accountUsername = string;
    }

    public void setAccountPassword(String string) {
        this.accountPassword = string;
    }

    public boolean isPasswordRemembered() {
        return this.passwordRemembered;
    }

    public void setPasswordRemembered(boolean bl) {
        this.passwordRemembered = bl;
    }

    public InsightAdministrator getInsightAdministrator() {
        return this.insightAdministrator;
    }

    public abstract AdministeredServerConnector getServerConnector();

    public boolean isConnected() {
        return this.isConnected;
    }

    public void addDataObject(EditableDataObject editableDataObject) {
        if (editableDataObject != null && this.hasAddPermission(editableDataObject, true)) {
            this.editDataObject(editableDataObject, true);
        }
    }

    public void removeDataObject(EditableDataObject editableDataObject) {
        if (editableDataObject != null && this.hasDeletePermission(editableDataObject, true) && editableDataObject instanceof DatabaseRecord) {
            try {
                this.getServerConnector().deleteRecord((DatabaseRecord)((Object)editableDataObject));
            }
            catch (RecordDeleteFailedException recordDeleteFailedException) {
                this.insightAdministrator.showWarningDialog(recordDeleteFailedException.getWarningMessage(), recordDeleteFailedException.getWarningTitle());
            }
        }
    }

    public void editDataObject(EditableDataObject editableDataObject) {
        this.editDataObject(editableDataObject, false);
    }

    public void editDataObject(EditableDataObject editableDataObject, boolean bl) {
        if (editableDataObject == null) {
            return;
        }
        if ((bl || this.hasEditPermission(editableDataObject, true)) && !this.getEditDialogCache(editableDataObject).containsKey(editableDataObject.getUniqueIdentifier())) {
            EditDialog editDialog = new EditDialog(this.insightAdministrator.getFrame(), true, editableDataObject);
            this.getEditDialogCache(editableDataObject).put(editableDataObject.getUniqueIdentifier(), editDialog);
            editDialog.show();
        } else {
            this.insightAdministrator.setSelectedFrame((EditDialog)this.getEditDialogCache(editableDataObject).get(editableDataObject.getUniqueIdentifier()));
        }
    }

    public void cancelEdit(EditableDataObject editableDataObject) {
        this.getEditDialogCache(editableDataObject).remove(editableDataObject.getOriginalUniqueIdentifier());
    }

    public void commitDataObject(EditableDataObject editableDataObject) {
        try {
            if (editableDataObject != null && editableDataObject instanceof DatabaseRecord) {
                this.getServerConnector().commitRecord((DatabaseRecord)((Object)editableDataObject));
            }
        }
        catch (RecordCommitFailedException recordCommitFailedException) {
            this.insightAdministrator.showWarningDialog(recordCommitFailedException.getWarningMessage(), recordCommitFailedException.getWarningTitle());
        }
        this.cancelEdit(editableDataObject);
        try {
            this.updateParentNode(editableDataObject);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected Hashtable getEditDialogCache(EditableDataObject editableDataObject) {
        if (editableDataObject != null && editableDataObject instanceof AdminAccount) {
            return this.adminAccountsTable;
        }
        return null;
    }

    public void updateParentNode(EditableDataObject editableDataObject) {
        if (editableDataObject != null && editableDataObject instanceof AdminAccount) {
            this.parentNode.adminAccountsNode.updateInformationDisplay();
        }
    }

    public Vector getAdminAccounts() {
        if (this.hasAccountReadPermission(true)) {
            this.insightAdministrator.showWaitCursor(true);
            Vector vector = this.getServerConnector().getAdminAccountRecords();
            this.insightAdministrator.showWaitCursor(false);
            return vector;
        }
        return new Vector();
    }

    public AdminAccount getAdminAccount(int n) {
        return this.getServerConnector().getAdminAccount(n);
    }

    public abstract void refreshConfigurationFileProperties();

    public void editConfigurationFileProperties() {
        AdministeredServer.debugOut("in editConfigurationInformation");
        if (this.propertiesEditDialog == null) {
            this.refreshConfigurationFileProperties();
            if (this.configFileProperties != null) {
                this.propertiesEditDialog = new EditDialog(this.insightAdministrator.getFrame(), true, this.configFileProperties);
                this.propertiesEditDialog.show();
            }
        } else {
            this.insightAdministrator.setSelectedFrame(this.propertiesEditDialog);
        }
    }

    public void commitConfigurationFileProperties() {
        AdministeredServer.debugOut("About to commit changes...");
        this.propertiesEditDialog = null;
        if (this.configFileProperties != null) {
            this.configFileProperties.commit();
        }
    }

    public void cancelConfigurationFilePropertiesEdit() {
        this.propertiesEditDialog = null;
    }

    public void refreshDefaultConfigurationFileProperties() {
        AdministeredServer.debugOut("in refreshDefaultConfigurationFileProperties()...");
        try {
            this.insightAdministrator.showWaitCursor(true);
            File file = new File(this.configFilePath);
            String string = file.getParent() + File.separator + "InsightBackend.dat";
            this.defaultConfigFileProperties = new DefaultConfigurationFileProperties(this, string);
            this.defaultConfigFileProperties.refresh();
            this.insightAdministrator.showWaitCursor(false);
        }
        catch (Exception exception) {
            AdministeredServer.debugOut("Exception in refreshDefaultConfigurationFileProperties(): " + exception);
        }
    }

    public void editDefaultConfigurationFileProperties() {
        AdministeredServer.debugOut("in editDefaultConfigurationFileProperties");
        if (this.defaultPropertiesEditDialog == null) {
            if (this.defaultConfigFileProperties == null) {
                this.refreshDefaultConfigurationFileProperties();
            }
            if (this.defaultConfigFileProperties != null) {
                this.defaultPropertiesEditDialog = new EditDialog(this.insightAdministrator.getFrame(), true, this.defaultConfigFileProperties);
                this.defaultPropertiesEditDialog.show();
            }
        } else {
            this.insightAdministrator.setSelectedFrame(this.defaultPropertiesEditDialog);
        }
    }

    public void commitDefaultConfigurationFileProperties() {
        AdministeredServer.debugOut("in commitDefaultConfigurationFileProperties()");
        this.defaultPropertiesEditDialog = null;
        if (this.defaultConfigFileProperties != null) {
            this.defaultConfigFileProperties.commit();
        }
    }

    public void cancelDefaultConfigurationFilePropertiesEdit() {
        AdministeredServer.debugOut("in cancelDefaultConfigurationFilePropertiesEdit()");
        this.defaultPropertiesEditDialog = null;
    }

    public boolean hasReadPermission(EditableDataObject editableDataObject, boolean bl) {
        if (editableDataObject != null) {
            if (editableDataObject instanceof AdminAccount) {
                return this.hasAccountReadPermission(bl);
            }
            return this.hasServerReadPermission(bl);
        }
        return false;
    }

    public boolean hasEditPermission(EditableDataObject editableDataObject, boolean bl) {
        if (editableDataObject != null) {
            if (editableDataObject instanceof AdminAccount) {
                return this.hasAccountEditPermission(bl);
            }
            return this.hasServerEditPermission(bl);
        }
        return false;
    }

    public boolean hasAddPermission(EditableDataObject editableDataObject, boolean bl) {
        if (editableDataObject != null) {
            if (editableDataObject instanceof AdminAccount) {
                return this.hasAccountAddPermission(bl);
            }
            return this.hasServerAddPermission(bl);
        }
        return false;
    }

    public boolean hasDeletePermission(EditableDataObject editableDataObject, boolean bl) {
        if (editableDataObject != null) {
            if (editableDataObject instanceof AdminAccount) {
                return this.hasAccountDeletePermission(bl);
            }
            return this.hasServerDeletePermission(bl);
        }
        return false;
    }

    public boolean hasServerReadPermission(boolean bl) {
        if (this.adminAccount != null && this.adminAccount.hasServerPermission(1)) {
            return true;
        }
        if (bl) {
            this.insightAdministrator.showWarningDialog("You do not have permission to view this data.", "Permission Denied");
        }
        return false;
    }

    public boolean hasServerEditPermission(boolean bl) {
        if (this.adminAccount != null && this.adminAccount.hasServerPermission(3)) {
            return true;
        }
        if (bl) {
            this.insightAdministrator.showWarningDialog("You do not have permission to edit this data.", "Permission Denied");
        }
        return false;
    }

    public boolean hasServerAddPermission(boolean bl) {
        if (this.adminAccount != null && this.adminAccount.hasServerPermission(5)) {
            return true;
        }
        if (bl) {
            this.insightAdministrator.showWarningDialog("You do not have permission to add new items.", "Permission Denied");
        }
        return false;
    }

    public boolean hasServerDeletePermission(boolean bl) {
        if (this.adminAccount != null && this.adminAccount.hasServerPermission(9)) {
            return true;
        }
        if (bl) {
            this.insightAdministrator.showWarningDialog("You do not have permission to delete items.", "Permission Denied");
        }
        return false;
    }

    public boolean hasAccountReadPermission(boolean bl) {
        if (this.adminAccount != null && this.adminAccount.hasAccountPermission(1)) {
            return true;
        }
        if (bl) {
            this.insightAdministrator.showWarningDialog("You do not have permission to view this data.", "Permission Denied");
        }
        return false;
    }

    public boolean hasAccountEditPermission(boolean bl) {
        if (this.adminAccount != null && this.adminAccount.hasAccountPermission(3)) {
            return true;
        }
        if (bl) {
            this.insightAdministrator.showWarningDialog("You do not have permission to edit this data.", "Permission Denied");
        }
        return false;
    }

    public boolean hasAccountAddPermission(boolean bl) {
        if (this.adminAccount != null && this.adminAccount.hasAccountPermission(5)) {
            return true;
        }
        if (bl) {
            this.insightAdministrator.showWarningDialog("You do not have permission to add new items.", "Permission Denied");
        }
        return false;
    }

    public boolean hasAccountDeletePermission(boolean bl) {
        if (this.adminAccount != null && this.adminAccount.hasAccountPermission(9)) {
            return true;
        }
        if (bl) {
            this.insightAdministrator.showWarningDialog("You do not have permission to delete items.", "Permission Denied");
        }
        return false;
    }

    public void addmpdtDataObject(EditableDataObject editableDataObject) {
        if (editableDataObject != null && this.hasAddPermission(editableDataObject, true)) {
            this.editmpdtDataObject(editableDataObject, true);
        }
    }

    public void editmpdtDataObject(EditableDataObject editableDataObject, boolean bl) {
        if (editableDataObject == null) {
            return;
        }
        if ((bl || this.hasEditPermission(editableDataObject, true)) && !this.getEditDialogCache(editableDataObject).containsKey(editableDataObject.getUniqueIdentifier())) {
            mpdtEditDialog mpdtEditDialog2 = new mpdtEditDialog(this.insightAdministrator.getFrame(), true, editableDataObject);
            this.getEditDialogCache(editableDataObject).put(editableDataObject.getUniqueIdentifier(), mpdtEditDialog2);
            mpdtEditDialog2.show();
        } else {
            this.insightAdministrator.setSelectedFrame((mpdtEditDialog)this.getEditDialogCache(editableDataObject).get(editableDataObject.getUniqueIdentifier()));
        }
    }

    public SqlQueryGenerator getQueryGenerator() {
        return new SqlQueryGenerator(this.queryMode, this.globalEscapeDelimiter, this.unicodeFieldPrefix);
    }

    public SqlQueryGenerator getQueryGeneratorUtil() {
        return this.sqlQueryGeneratorUtil;
    }

    public static void debugOut(String string) {
        AdministeredServer.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("AdministeredServer: " + string, n);
    }
}

