/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin;

import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;

public class AdminDesktopPane
extends JDesktopPane {
    protected static final int OFFSET_PIXELS = 30;
    protected int offsetMax = 160;
    protected int currentOffset = 0;

    public void cascade() {
        this.updateOffsetMax();
        this.currentOffset = 0;
        JInternalFrame[] jInternalFrameArray = this.getAllFrames();
        for (int i = jInternalFrameArray.length - 1; i > -1; --i) {
            JInternalFrame jInternalFrame = jInternalFrameArray[i];
            if (jInternalFrame.isIcon()) continue;
            jInternalFrame.setLocation(this.getNextLocation());
            this.sizeToDesktop(jInternalFrame);
        }
    }

    public void tile() {
        JInternalFrame[] jInternalFrameArray = this.getAllFrames();
        int n = jInternalFrameArray.length;
        int n2 = (int)Math.sqrt(n);
        if (n2 == 0) {
            n2 = 1;
        }
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        int n5 = n / n2;
        int n6 = n / n5;
        int n7 = n3 / n5;
        int n8 = n4 / n6;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        for (n10 = 0; n10 < n5 - 1; ++n10) {
            for (n11 = 0; n11 < n6; ++n11) {
                jInternalFrameArray[n9].setLocation(n10 * n7, n11 * n8);
                jInternalFrameArray[n9].setSize(n7, n8);
                ++n9;
            }
        }
        int n12 = n - n9;
        n8 = n4 / n12;
        for (int i = 0; i < n12; ++i) {
            jInternalFrameArray[n9].setLocation(n10 * n7, i * n8);
            jInternalFrameArray[n9].setSize(n7, n8);
            ++n9;
        }
    }

    public void add(JComponent jComponent) {
        this.updateOffsetMax();
        jComponent.setLocation(this.getNextLocation());
        this.sizeToDesktop(jComponent);
        super.add(jComponent);
        this.moveToFront(jComponent);
        jComponent.requestFocus();
    }

    protected void sizeToDesktop(JComponent jComponent) {
        if (jComponent instanceof JInternalFrame) {
            ((JInternalFrame)jComponent).pack();
        }
        int n = jComponent.getWidth();
        int n2 = jComponent.getHeight();
        if (this.getWidth() < jComponent.getWidth() + jComponent.getX()) {
            n = this.getWidth() - jComponent.getX();
        }
        if (this.getHeight() < jComponent.getHeight() + jComponent.getY()) {
            n2 = this.getHeight() - jComponent.getY();
        }
        jComponent.setSize(n, n2);
    }

    private Point getNextLocation() {
        Point point = new Point(this.currentOffset, this.currentOffset);
        this.currentOffset = this.currentOffset % this.offsetMax + 30;
        return point;
    }

    private void updateOffsetMax() {
        this.offsetMax = Math.max(this.getHeight() / 3, 100);
    }
}

