/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin;

import com.luna.insight.admin.AdminAccount;
import com.luna.insight.admin.AdministeredServerConnector;
import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.DatabaseRecordHandler;
import com.luna.insight.server.backend.DatabaseConnector;
import com.luna.insight.server.backend.SqlQueryGenerator;
import java.util.Vector;

public class AdminAccountRecordHandler
extends DatabaseRecordHandler {
    public AdminAccountRecordHandler(AdministeredServerConnector administeredServerConnector) {
        super(administeredServerConnector);
        this.COMPONENT_CODE = "AdminAccountRecordHandler";
    }

    public void doInsert(DatabaseRecord databaseRecord) {
        this.debugOut("in doInsert()");
        try {
            if (databaseRecord != null && databaseRecord instanceof AdminAccount) {
                AdminAccount adminAccount = (AdminAccount)databaseRecord;
                DatabaseConnector databaseConnector = this.getDatabaseConnector();
                String string = "INSERT INTO " + AdministeredServerConnector.TABLE_ADMIN_ACCOUNTS + " " + "(AdminID, Username, Password, ServerAdminPermissions, AccountAdminPermissions, CreatedTimestamp) " + "VALUES (" + adminAccount.adminID + ", " + this.prepForInsertQuery(adminAccount.username) + ", " + this.prepForInsertQuery(adminAccount.password) + ", " + adminAccount.serverAdminPermissions + ", " + adminAccount.accountAdminPermissions + ", " + this.prepForInsertQuery(adminAccount.createdTimestamp) + ")";
                databaseConnector.setQuery(string);
                this.debugOut("insertAdminAccountQuery query: \n" + databaseConnector.getQuery(), 3);
                databaseConnector.runUpdateQuery();
                databaseConnector.close();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in doInsert(): " + exception);
        }
    }

    public void doDelete(DatabaseRecord databaseRecord) {
        this.debugOut("in doDelete()");
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            String string = "DELETE FROM " + AdministeredServerConnector.TABLE_ADMIN_ACCOUNTS + " WHERE AdminID = " + databaseRecord.getIndex();
            databaseConnector.setQuery(string);
            this.debugOut("deleteAdminAccountQuery query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in doDelete(): " + exception);
        }
    }

    public Vector getRecords() {
        this.debugOut("in getRecords()");
        Vector<AdminAccount> vector = new Vector<AdminAccount>();
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable(AdministeredServerConnector.TABLE_ADMIN_ACCOUNTS, null, "*");
            sqlQueryGenerator.addOrderBy(AdministeredServerConnector.TABLE_ADMIN_ACCOUNTS, "AdminID");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Admin Accounts query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                while (databaseConnector.more()) {
                    AdminAccount adminAccount = new AdminAccount(this.serverConnector.getAdministeredServer(), databaseConnector.getIntegerFieldByName("AdminID"), databaseConnector.getFieldByName("Username"), databaseConnector.getFieldByName("Password"), databaseConnector.getIntegerFieldByName("ServerAdminPermissions"), databaseConnector.getIntegerFieldByName("AccountAdminPermissions"), databaseConnector.getFieldByName("CreatedTimestamp"));
                    vector.addElement(adminAccount);
                    databaseConnector.next();
                }
            }
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getRecords(): " + exception);
        }
        return vector;
    }

    public DatabaseRecord getRecord(DatabaseRecord databaseRecord) {
        return this.getAdminAccount(databaseRecord.getIndex());
    }

    public DatabaseRecord getAdminAccount(int n) {
        this.debugOut("in getRecord()");
        AdminAccount adminAccount = null;
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable(AdministeredServerConnector.TABLE_ADMIN_ACCOUNTS, null, "*");
            sqlQueryGenerator.addOrderBy(AdministeredServerConnector.TABLE_ADMIN_ACCOUNTS, "AdminID");
            sqlQueryGenerator.appendToWhere("AdminID = " + n);
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Admin Account query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                adminAccount = new AdminAccount(this.serverConnector.getAdministeredServer(), databaseConnector.getIntegerFieldByName("AdminID"), databaseConnector.getFieldByName("Username"), databaseConnector.getFieldByName("Password"), databaseConnector.getIntegerFieldByName("ServerAdminPermissions"), databaseConnector.getIntegerFieldByName("AccountAdminPermissions"), databaseConnector.getFieldByName("CreatedTimestamp"));
            }
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getRecord(): " + exception);
        }
        return adminAccount;
    }

    public String getNextValidIDQuery() {
        return "SELECT AdminID AS " + AdministeredServerConnector.CANDIDATE_INDEX_NAME + " FROM " + AdministeredServerConnector.TABLE_ADMIN_ACCOUNTS + " ORDER BY AdminID";
    }

    public void updateMaxIDValue(long l) {
    }
}

