/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin;

import com.luna.insight.admin.AdminAccountEditComponent;
import com.luna.insight.admin.AdministeredServer;
import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.IndexedObject;
import com.luna.insight.admin.collserver.CollectionServer;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import com.luna.insight.server.SimpleDate;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;

public class AdminAccount
extends EditableDataObject
implements IndexedObject,
DatabaseRecord {
    public static final int SERVER_ADMIN_READ = 1;
    public static final int SERVER_ADMIN_EDIT = 3;
    public static final int SERVER_ADMIN_ADD = 5;
    public static final int SERVER_ADMIN_DELETE = 9;
    public static final int SERVER_ADMIN_TASK_MASTER = 17;
    public static final int SERVER_STUDIO_AUTHENTICATE = 32;
    public static final int SERVER_STUDIO_COLLECTION_DELETE = 64;
    public static final int ACCOUNT_ADMIN_READ = 1;
    public static final int ACCOUNT_ADMIN_EDIT = 3;
    public static final int ACCOUNT_ADMIN_ADD = 5;
    public static final int ACCOUNT_ADMIN_DELETE = 9;
    protected int adminID;
    protected AdministeredServer server;
    protected String username = "";
    protected String password = "";
    protected int serverAdminPermissions = 0;
    protected int accountAdminPermissions = 0;
    protected String createdTimestamp = "";
    private boolean serverRead = false;
    private boolean serverEdit = false;
    private boolean serverAdd = false;
    private boolean serverDelete = false;
    private boolean serverTaskMaster = false;
    private boolean serverStudioAuthentication = false;
    private boolean serverStudioCollectionDelete = false;
    private boolean accountRead = false;
    private boolean accountEdit = false;
    private boolean accountAdd = false;
    private boolean accountDelete = false;
    protected boolean isPCCollectionServer = false;
    protected boolean commitChange = false;
    protected AdminAccountEditComponent editComponent = null;

    public AdminAccount(AdministeredServer administeredServer, int n, String string, String string2, int n2, int n3, String string3) {
        this.server = administeredServer;
        this.adminID = n;
        this.username = string;
        this.password = string2;
        this.serverAdminPermissions = n2;
        this.accountAdminPermissions = n3;
        this.createdTimestamp = string3 == null ? new SimpleDate().get() : string3;
        this.isPCCollectionServer = administeredServer instanceof CollectionServer ? ((CollectionServer)administeredServer).getCollectionServerConnector().isPersonalCollectionServer() : false;
        this.loadPermissions();
    }

    public AdminAccount(int n, AdministeredServer administeredServer) {
        this.adminID = n;
        this.server = administeredServer;
        this.isPCCollectionServer = administeredServer instanceof CollectionServer ? ((CollectionServer)administeredServer).getCollectionServerConnector().isPersonalCollectionServer() : false;
        this.createdTimestamp = new SimpleDate().get();
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.username;
    }

    public void setServerReadPermission(boolean bl) {
        this.serverRead = bl;
        this.updatePermissions();
    }

    public void setServerEditPermission(boolean bl) {
        this.serverEdit = bl;
        this.updatePermissions();
    }

    public void setServerAddPermission(boolean bl) {
        this.serverAdd = bl;
        this.updatePermissions();
    }

    public void setServerDeletePermission(boolean bl) {
        this.serverDelete = bl;
        this.updatePermissions();
    }

    public void loadPermissions() {
        this.serverRead = this.hasServerPermission(1);
        this.serverEdit = this.hasServerPermission(3);
        this.serverAdd = this.hasServerPermission(5);
        this.serverDelete = this.hasServerPermission(9);
        this.serverTaskMaster = this.hasServerPermission(17);
        this.commitChange = this.serverTaskMaster != this.hasServerPermission(17);
        this.serverStudioAuthentication = this.hasServerPermission(32);
        this.serverStudioCollectionDelete = this.hasServerPermission(64);
        this.commitChange = this.commitChange || this.serverStudioCollectionDelete != this.hasServerPermission(64);
        this.accountRead = this.hasAccountPermission(1);
        this.accountEdit = this.hasAccountPermission(3);
        this.accountAdd = this.hasAccountPermission(5);
        this.accountDelete = this.hasAccountPermission(9);
    }

    public void updatePermissions() {
        this.serverAdminPermissions = 0;
        if (this.serverRead) {
            this.serverAdminPermissions |= 1;
        }
        if (this.serverEdit) {
            this.serverAdminPermissions |= 3;
        }
        if (this.serverAdd) {
            this.serverAdminPermissions |= 5;
        }
        if (this.serverDelete) {
            this.serverAdminPermissions |= 9;
        }
        if (this.serverTaskMaster) {
            this.serverAdminPermissions |= 0x11;
        }
        if (this.serverStudioAuthentication) {
            this.serverAdminPermissions |= 0x20;
        }
        if (this.serverStudioCollectionDelete) {
            this.serverAdminPermissions |= 0x40;
        }
        this.accountAdminPermissions = 0;
        if (this.accountRead) {
            this.accountAdminPermissions |= 1;
        }
        if (this.accountEdit) {
            this.accountAdminPermissions |= 3;
        }
        if (this.accountAdd) {
            this.accountAdminPermissions |= 5;
        }
        if (this.accountDelete) {
            this.accountAdminPermissions |= 9;
        }
    }

    public boolean hasServerPermission(int n) {
        return (this.serverAdminPermissions & n) == n;
    }

    public boolean hasAccountPermission(int n) {
        return (this.accountAdminPermissions & n) == n;
    }

    public int getIndex() {
        return this.adminID;
    }

    public EditComponent getEditComponent() {
        if (this.server instanceof CollectionServer) {
            this.editComponent = new AdminAccountEditComponent(true);
            this.editComponent.getServerTaskMasterCheckBox().setSelected(this.serverTaskMaster);
        } else {
            this.editComponent = new AdminAccountEditComponent();
        }
        this.editComponent.getServerStudioAuthenticationCheckBox().setSelected(this.serverStudioAuthentication);
        this.editComponent.getServerStudioCollectionDeleteCheckBox().setSelected(this.serverStudioCollectionDelete);
        this.editComponent.getUsernameField().setText(this.username);
        this.editComponent.getPasswordField().setText(this.password);
        this.editComponent.getServerReadPermissionCheckBox().setSelected(this.serverRead);
        this.editComponent.getServerEditPermissionCheckBox().setSelected(this.serverEdit);
        this.editComponent.getServerAddPermissionCheckBox().setSelected(this.serverAdd);
        this.editComponent.getServerDeletePermissionCheckBox().setSelected(this.serverDelete);
        this.editComponent.getAccountReadPermissionCheckBox().setSelected(this.accountRead);
        this.editComponent.getAccountEditPermissionCheckBox().setSelected(this.accountEdit);
        this.editComponent.getAccountAddPermissionCheckBox().setSelected(this.accountAdd);
        this.editComponent.getAccountDeletePermissionCheckBox().setSelected(this.accountDelete);
        this.editComponent.getUsernameField().selectAll();
        return this.editComponent;
    }

    public void save() {
        AdminAccount.debugOut("Save...", 3);
        this.requiresCommit = this.commitChange;
        if (this.hasChanged(this.username, this.editComponent.getUsernameField().getText())) {
            this.username = this.editComponent.getUsernameField().getText();
        }
        if (this.hasChanged(this.password, new String(this.editComponent.getPasswordField().getPassword()))) {
            this.password = new String(this.editComponent.getPasswordField().getPassword());
        }
        if (this.hasChanged(this.serverRead, this.editComponent.getServerReadPermissionCheckBox().isSelected())) {
            this.serverRead = this.editComponent.getServerReadPermissionCheckBox().isSelected();
        }
        if (this.hasChanged(this.serverEdit, this.editComponent.getServerEditPermissionCheckBox().isSelected())) {
            this.serverEdit = this.editComponent.getServerEditPermissionCheckBox().isSelected();
        }
        if (this.hasChanged(this.serverAdd, this.editComponent.getServerAddPermissionCheckBox().isSelected())) {
            this.serverAdd = this.editComponent.getServerAddPermissionCheckBox().isSelected();
        }
        if (this.hasChanged(this.serverDelete, this.editComponent.getServerDeletePermissionCheckBox().isSelected())) {
            this.serverDelete = this.editComponent.getServerDeletePermissionCheckBox().isSelected();
        }
        if (this.server instanceof CollectionServer && this.hasChanged(this.serverTaskMaster, this.editComponent.getServerTaskMasterCheckBox().isSelected())) {
            this.serverTaskMaster = this.editComponent.getServerTaskMasterCheckBox().isSelected();
        }
        if (this.hasChanged(this.serverStudioAuthentication, this.editComponent.getServerStudioAuthenticationCheckBox().isSelected())) {
            this.serverStudioAuthentication = this.editComponent.getServerStudioAuthenticationCheckBox().isSelected();
        }
        if (this.hasChanged(this.serverStudioCollectionDelete, this.editComponent.getServerStudioCollectionDeleteCheckBox().isSelected())) {
            this.serverStudioCollectionDelete = this.editComponent.getServerStudioCollectionDeleteCheckBox().isSelected();
        }
        if (this.hasChanged(this.accountRead, this.editComponent.getAccountReadPermissionCheckBox().isSelected())) {
            this.accountRead = this.editComponent.getAccountReadPermissionCheckBox().isSelected();
        }
        if (this.hasChanged(this.accountEdit, this.editComponent.getAccountEditPermissionCheckBox().isSelected())) {
            this.accountEdit = this.editComponent.getAccountEditPermissionCheckBox().isSelected();
        }
        if (this.hasChanged(this.accountAdd, this.editComponent.getAccountAddPermissionCheckBox().isSelected())) {
            this.accountAdd = this.editComponent.getAccountAddPermissionCheckBox().isSelected();
        }
        if (this.hasChanged(this.accountDelete, this.editComponent.getAccountDeletePermissionCheckBox().isSelected())) {
            this.accountDelete = this.editComponent.getAccountDeletePermissionCheckBox().isSelected();
        }
        this.updatePermissions();
        this.creationCompleted = true;
        if (this.requiresCommit) {
            this.server.commitDataObject(this);
        } else {
            this.server.cancelEdit(this);
        }
    }

    public void cancel() {
        AdminAccount.debugOut("Cancel...", 3);
        if (this.commitChange) {
            this.save();
        }
        this.editComponent = null;
        this.server.cancelEdit(this);
    }

    public String getEditWindowTitle() {
        return "Edit Admin Account - " + this.username;
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/administered-server-accounts-node-icon.gif");
    }

    public String getUniqueIdentifier() {
        return "" + this.getIndex();
    }

    public boolean equals(Object object) {
        if (object instanceof AdminAccount) {
            return this.adminID == ((AdminAccount)object).adminID;
        }
        return super.equals(object);
    }

    public boolean equalsRecord(DatabaseRecord databaseRecord) {
        if (databaseRecord instanceof AdminAccount) {
            AdminAccount adminAccount = (AdminAccount)databaseRecord;
            return this.adminID == adminAccount.adminID && this.serverAdminPermissions == adminAccount.serverAdminPermissions && this.accountAdminPermissions == adminAccount.accountAdminPermissions && AdminAccount.stringsAreEqual(this.username, adminAccount.username) && AdminAccount.stringsAreEqual(this.password, adminAccount.password) && AdminAccount.stringsAreEqual(this.createdTimestamp, adminAccount.createdTimestamp);
        }
        return false;
    }

    public JMenuItem createPermittedServerMenuItem(String string, String string2, ActionListener actionListener) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.setActionCommand(string2);
        if (string2 == null) {
            jMenuItem.addActionListener(actionListener);
        } else if (string2.startsWith("New")) {
            if (this.hasServerPermission(5)) {
                jMenuItem.addActionListener(actionListener);
            } else {
                jMenuItem.setEnabled(false);
            }
        } else if (string2.startsWith("Edit")) {
            if (this.hasServerPermission(3)) {
                jMenuItem.addActionListener(actionListener);
            } else {
                jMenuItem.setEnabled(false);
            }
        } else if (string2.startsWith("Delete")) {
            if (this.hasServerPermission(9)) {
                jMenuItem.addActionListener(actionListener);
            } else {
                jMenuItem.setEnabled(false);
            }
        } else {
            jMenuItem.addActionListener(actionListener);
        }
        return jMenuItem;
    }

    public JMenuItem createPermittedTaskMenuItem(String string, String string2, ActionListener actionListener) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.setActionCommand(string2);
        if (string2 == null) {
            jMenuItem.addActionListener(actionListener);
        } else if (string2.startsWith("Open")) {
            if (this.hasServerPermission(1)) {
                jMenuItem.addActionListener(actionListener);
            } else {
                jMenuItem.setEnabled(false);
            }
        } else if (string2.startsWith("New") || string2.startsWith("Edit") || string2.startsWith("Delete")) {
            if (this.hasServerPermission(17)) {
                jMenuItem.addActionListener(actionListener);
            } else {
                jMenuItem.setEnabled(false);
            }
        } else {
            jMenuItem.addActionListener(actionListener);
        }
        return jMenuItem;
    }

    public JMenuItem createPermittedAdminAccountMenuItem(String string, String string2, ActionListener actionListener) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.setActionCommand(string2);
        if (string2 == null) {
            jMenuItem.addActionListener(actionListener);
        } else if (string2.startsWith("New")) {
            if (this.hasAccountPermission(5)) {
                jMenuItem.addActionListener(actionListener);
            } else {
                jMenuItem.setEnabled(false);
            }
        } else if (string2.startsWith("Edit")) {
            if (this.hasAccountPermission(3)) {
                jMenuItem.addActionListener(actionListener);
            } else {
                jMenuItem.setEnabled(false);
            }
        } else if (string2.startsWith("Delete")) {
            if (this.hasAccountPermission(9)) {
                jMenuItem.addActionListener(actionListener);
            } else {
                jMenuItem.setEnabled(false);
            }
        }
        return jMenuItem;
    }

    public JMenuItem createMenuItem(String string, String string2, ActionListener actionListener) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.setActionCommand(string2);
        if (string2 == null) {
            jMenuItem.addActionListener(actionListener);
        } else if (string2.startsWith("New")) {
            jMenuItem.addActionListener(actionListener);
        } else if (string2.startsWith("Edit")) {
            jMenuItem.addActionListener(actionListener);
        } else if (string2.startsWith("Delete")) {
            jMenuItem.addActionListener(actionListener);
        }
        return jMenuItem;
    }

    public static void debugOut(String string) {
        AdminAccount.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("AdminAccount: " + string, n);
    }
}

