/*
 * Decompiled with CFR 0.152.
 */
package ca.beq.util.win32.registry;

import ca.beq.util.win32.registry.ValueType;

public class RegistryValue {
    private String name = "";
    private ValueType type = ValueType.REG_SZ;
    private Object data = null;

    public RegistryValue() {
    }

    public RegistryValue(Object data) {
        this.data = data;
    }

    public RegistryValue(String name, Object data) {
        this.name = name;
        this.data = data;
    }

    public RegistryValue(String name, ValueType type, Object data) {
        this.name = name;
        this.type = type;
        this.data = data;
    }

    public RegistryValue(String name, boolean data) {
        this(name, ValueType.REG_DWORD, new Boolean(data));
    }

    public RegistryValue(String name, byte data) {
        this(name, ValueType.REG_BINARY, new Byte(data));
    }

    public RegistryValue(String name, int data) {
        this(name, ValueType.REG_DWORD, new Integer(data));
    }

    public RegistryValue(String name, long data) {
        this(name, ValueType.REG_DWORD, new Long(data));
    }

    public RegistryValue(String name, float data) {
        this(name, ValueType.REG_BINARY, new Float(data));
    }

    public RegistryValue(String name, double data) {
        this(name, ValueType.REG_BINARY, new Double(data));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ValueType getType() {
        return this.type;
    }

    public void setType(ValueType type) {
        this.type = type;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public void setData(byte data) {
        this.setData(new Byte(data));
    }

    public void setData(boolean data) {
        this.setData(new Boolean(data));
    }

    public void setData(int data) {
        this.setData(new Integer(data));
    }

    public void setData(long data) {
        this.setData(new Long(data));
    }

    public void setData(float data) {
        this.setData(new Float(data));
    }

    public void setData(double data) {
        this.setData(new Double(data));
    }

    public String toString() {
        if (this.name == null || this.data == null) {
            throw new NullPointerException("Neither name not data may be null");
        }
        String dataval = "<no data>";
        if (this.type == ValueType.REG_SZ || this.type == ValueType.REG_EXPAND_SZ || this.type == ValueType.REG_MULTI_SZ) {
            dataval = this.data.toString();
        } else if (this.type == ValueType.REG_DWORD || this.type == ValueType.REG_DWORD_LITTLE_ENDIAN || this.type == ValueType.REG_DWORD_BIG_ENDIAN) {
            dataval = ((Integer)this.data).toString();
        } else if (this.type == ValueType.REG_NONE || this.type == ValueType.REG_BINARY) {
            StringBuffer sb = new StringBuffer();
            byte[] b = (byte[])this.data;
            int index = 0;
            while (index < b.length) {
                sb.append(" " + Byte.toString(b[index]));
                ++index;
            }
            dataval = sb.toString();
        }
        return this.name + ":" + this.type.toString() + ":" + dataval;
    }
}

