/*
 * Decompiled with CFR 0.152.
 */
package ca.beq.util.win32.registry;

import ca.beq.util.win32.registry.RegistryException;
import ca.beq.util.win32.registry.RegistryKey;
import ca.beq.util.win32.registry.RegistryValue;
import ca.beq.util.win32.registry.RootKey;
import ca.beq.util.win32.registry.ValueType;
import java.util.Arrays;
import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class RegistryKeyTest
extends TestCase {
    private static final String TESTKEY = "jRegistryKeyTestKey";
    static /* synthetic */ Class class$ca$beq$util$win32$registry$RegistryKeyTest;

    public static void main(String[] args) {
        TestRunner.run((Test)RegistryKeyTest.suite());
    }

    public RegistryKeyTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(class$ca$beq$util$win32$registry$RegistryKeyTest == null ? (class$ca$beq$util$win32$registry$RegistryKeyTest = RegistryKeyTest.class$("ca.beq.util.win32.registry.RegistryKeyTest")) : class$ca$beq$util$win32$registry$RegistryKeyTest);
    }

    public void testExistsValid() {
        RegistryKey r = new RegistryKey(RootKey.HKEY_LOCAL_MACHINE, "HARDWARE");
        Assert.assertEquals((String)"Valid key \"HKLM\\HARDWARE\" must report true (exists)!", (boolean)true, (boolean)r.exists());
    }

    public void testExistsInvalid() {
        RegistryKey r = new RegistryKey(RootKey.HKEY_LOCAL_MACHINE, "GoodBadImTheOneWithTheGun");
        Assert.assertEquals((String)"Bogus key \"HKCU\\OogaBooga\" must report false (does not exist)!", (boolean)false, (boolean)r.exists());
    }

    public void testCreateNew() {
        try {
            RegistryKey r = new RegistryKey(RootKey.HKEY_CURRENT_USER, TESTKEY);
            if (r.exists()) {
                r.delete();
            }
            r.create();
        }
        catch (RegistryException re) {
            Assert.fail((String)"Creation of a new key must succeed!");
        }
    }

    public void testCreateDuplicate() {
        try {
            RegistryKey r = new RegistryKey(RootKey.HKEY_CURRENT_USER, TESTKEY);
            if (!r.exists()) {
                r.create();
            }
            r.create();
            Assert.fail((String)"Creation of a duplicate key must fail!");
        }
        catch (RegistryException registryException) {
            // empty catch block
        }
    }

    public void testDeleteValid() {
        try {
            RegistryKey r = new RegistryKey(RootKey.HKEY_CURRENT_USER, TESTKEY);
            if (!r.exists()) {
                r.create();
            }
            r.delete();
        }
        catch (RegistryException re) {
            Assert.fail((String)"Deletion of a non-empty key must succeed!");
        }
    }

    public void testDeleteInvalid() {
        try {
            RegistryKey r = new RegistryKey(RootKey.HKEY_CURRENT_USER, TESTKEY);
            if (r.exists()) {
                r.delete();
            }
            r.delete();
            Assert.fail((String)"Deletion of an invalid key must fail!");
        }
        catch (RegistryException registryException) {
            // empty catch block
        }
    }

    public void testHasSubkeysFail() {
        RegistryKey r = new RegistryKey(RootKey.HKEY_CURRENT_USER, TESTKEY);
        try {
            if (r.exists()) {
                r.delete();
            }
            r.create();
            Assert.assertEquals((String)"Checking if a key without subkey has keys must fail!", (boolean)false, (boolean)r.hasSubkeys());
        }
        catch (RegistryException re) {
            Assert.fail((String)"Subkey creation must succeed!");
        }
    }

    public void testHasSubkeys() {
        RegistryKey r = new RegistryKey(RootKey.HKEY_CURRENT_USER, TESTKEY);
        try {
            if (r.exists()) {
                r.delete();
            }
            r.create();
            RegistryKey rr = r.createSubkey(TESTKEY);
            Assert.assertEquals((String)"Checking if a key with subkey has keys must not fail!", (boolean)true, (boolean)r.hasSubkeys());
        }
        catch (RegistryException re) {
            Assert.fail((String)"Subkey creation must succeed!");
        }
    }

    public void testSetGetValue() {
        String REGVALUE_SZ = "This is a test";
        String REGVALUE_EXPAND_SZ = "PATH=%path%";
        Integer REGVALUE_DWORD = new Integer(1);
        Integer REGVALUE_DWORD_LITTLE_ENDIAN = new Integer(2);
        byte[] REGVALUE_BINARY = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        RegistryKey r = new RegistryKey(RootKey.HKEY_CURRENT_USER, TESTKEY);
        RegistryValue v = new RegistryValue("test1", ValueType.REG_SZ, (Object)REGVALUE_SZ);
        r.setValue(v);
        Assert.assertEquals((String)"REG_SZ strings must match!", (Object)REGVALUE_SZ, (Object)((String)r.getValue("test1").getData()));
        v = new RegistryValue("test2", ValueType.REG_EXPAND_SZ, (Object)REGVALUE_EXPAND_SZ);
        r.setValue(v);
        v = new RegistryValue("test3", ValueType.REG_DWORD, (Object)REGVALUE_DWORD);
        r.setValue(v);
        Assert.assertEquals((String)"REG_DWORD values must match!", (int)REGVALUE_DWORD, (int)((Integer)r.getValue("test3").getData()));
        v = new RegistryValue("test4", ValueType.REG_DWORD_LITTLE_ENDIAN, (Object)REGVALUE_DWORD_LITTLE_ENDIAN);
        r.setValue(v);
        Assert.assertEquals((String)"REG_DWORD_LITTLE_ENDIAN values must match!", (int)REGVALUE_DWORD_LITTLE_ENDIAN, (int)((Integer)r.getValue("test4").getData()));
        v = new RegistryValue("test5", ValueType.REG_BINARY, (Object)REGVALUE_BINARY);
        r.setValue(v);
        Assert.assertTrue((String)"REG_BINARY values must match!", (boolean)Arrays.equals((byte[])r.getValue("test5").getData(), REGVALUE_BINARY));
    }

    public void testSubkeys() {
        RegistryKey r = new RegistryKey(RootKey.HKEY_CURRENT_USER, TESTKEY);
        Assert.assertTrue((String)"subkeys() must return an iterator", (boolean)(r.subkeys() instanceof Iterator));
        Assert.assertNotNull((String)"subkeys() must not be null!", (Object)r.subkeys());
    }

    public void testKeyIterator() {
        int NUM_KEYS = 10;
        RegistryKey r = new RegistryKey(RootKey.HKEY_CURRENT_USER, TESTKEY);
        if (r.exists()) {
            r.delete();
        }
        r.create();
        int index = 0;
        while (index < NUM_KEYS) {
            r.createSubkey("subkey-" + index);
            ++index;
        }
        if (r.hasSubkeys()) {
            System.out.println("In key " + r.toString());
            int count = 0;
            Iterator i = r.subkeys();
            while (i.hasNext()) {
                RegistryKey rr = (RegistryKey)i.next();
                System.out.println("Found subkey: " + rr.toString());
                ++count;
            }
            Assert.assertEquals((String)"We created these keys - they should exist!", (int)count, (int)NUM_KEYS);
        } else {
            Assert.fail((String)"Subkeys should have been created - this is serious!");
        }
    }

    public void testValues() {
        RegistryKey r = new RegistryKey(RootKey.HKEY_CURRENT_USER, TESTKEY);
        Assert.assertTrue((String)"values() must return an iterator!", (boolean)(r.values() instanceof Iterator));
        Assert.assertNotNull((String)"values() must not be null!", (Object)r.values());
    }

    public void testValueIterator() {
        String REGVALUE_SZ = "This is a test";
        String REGVALUE_EXPAND_SZ = "PATH=%path%";
        Integer REGVALUE_DWORD = new Integer(1);
        Integer REGVALUE_DWORD_LITTLE_ENDIAN = new Integer(2);
        byte[] REGVALUE_BINARY = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        RegistryKey r = new RegistryKey(RootKey.HKEY_CURRENT_USER, TESTKEY);
        if (r.exists()) {
            r.delete();
        }
        r.create();
        RegistryValue v = new RegistryValue("test1", ValueType.REG_SZ, (Object)REGVALUE_SZ);
        r.setValue(v);
        v = new RegistryValue("test2", ValueType.REG_EXPAND_SZ, (Object)REGVALUE_EXPAND_SZ);
        r.setValue(v);
        v = new RegistryValue("test3", ValueType.REG_DWORD, (Object)REGVALUE_DWORD);
        r.setValue(v);
        v = new RegistryValue("test4", ValueType.REG_DWORD_LITTLE_ENDIAN, (Object)REGVALUE_DWORD_LITTLE_ENDIAN);
        r.setValue(v);
        v = new RegistryValue("test5", ValueType.REG_BINARY, (Object)REGVALUE_BINARY);
        r.setValue(v);
        if (r.hasValues()) {
            System.out.println("In key " + r.toString());
            int count = 0;
            Iterator i = r.values();
            while (i.hasNext()) {
                RegistryValue rv = (RegistryValue)i.next();
                System.out.println("Found value: " + rv.toString());
                ++count;
            }
            Assert.assertEquals((String)"We created these keys - they should exist!", (int)count, (int)5);
        } else {
            Assert.fail((String)"Values should have been created - this is serious!");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

