/*
 * Decompiled with CFR 0.152.
 */
package ca.beq.util.win32.registry;

import ca.beq.util.win32.registry.KeyIterator;
import ca.beq.util.win32.registry.RegistryValue;
import ca.beq.util.win32.registry.RootKey;
import ca.beq.util.win32.registry.ValueIterator;
import java.util.Iterator;

public class RegistryKey {
    private RootKey root = RootKey.HKEY_CURRENT_USER;
    private String path = "";

    public RegistryKey() {
    }

    public RegistryKey(RootKey root) {
        this.root = root;
    }

    public RegistryKey(String path) {
        this.path = path;
    }

    public RegistryKey(RootKey root, String path) {
        this.root = root;
        this.path = path;
    }

    public RootKey getRootKey() {
        return this.root;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return this.path.substring(1 + this.path.lastIndexOf("\\"));
    }

    public native boolean exists();

    public native void create();

    public RegistryKey createSubkey(String name) {
        RegistryKey r = new RegistryKey(this.root, this.path + "\\" + name);
        r.create();
        return r;
    }

    public native void delete();

    public native boolean hasSubkeys();

    public boolean hasSubkey(String name) {
        RegistryKey r = new RegistryKey(this.root, this.path + "\\" + name);
        return r.exists();
    }

    public Iterator subkeys() {
        return new KeyIterator(this);
    }

    public Iterator values() {
        return new ValueIterator(this);
    }

    public native boolean hasValue(String var1);

    public native boolean hasValues();

    public native RegistryValue getValue(String var1);

    public native void setValue(RegistryValue var1);

    public native void deleteValue(String var1);

    public String toString() {
        return this.root.toString() + "\\" + this.path;
    }

    static {
        System.loadLibrary("jRegistryKey");
    }
}

