/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.util;

import com.zerog.util.Err;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Properties;

public class FileEncoding {
    private static FileEncoding instance = null;
    private boolean initialized = false;
    private String platformDefaultFileEncoding;
    private String[] forcedEncodingsToTry = new String[]{"UTF-8", "ISO-8859-1", "8859_1"};
    private String[] unsupportedEncodings = new String[]{"cp1047", "cp1046", "ebcdic"};

    public static synchronized FileEncoding instance() {
        if (instance == null) {
            instance = new FileEncoding();
        }
        return instance;
    }

    private FileEncoding() {
    }

    public synchronized void initialize() {
        String fn = new String("FileEncoding::initialize()");
        if (!this.initialized) {
            FileEncoding.debug(fn, "initializing FileEncoding");
            this.platformDefaultFileEncoding = System.getProperty("file.encoding", "");
            if (this.isPlatformEncodingUnsupported()) {
                for (int cx = 0; cx < this.forcedEncodingsToTry.length; ++cx) {
                    FileEncoding.debug(fn, "checking: " + this.forcedEncodingsToTry[cx]);
                    if (!FileEncoding.isEncodingAvailable(this.forcedEncodingsToTry[cx])) continue;
                    FileEncoding.debug(fn, "  VALID!");
                    FileEncoding.setSystemProperty("file.encoding", this.forcedEncodingsToTry[cx]);
                    break;
                }
            }
            this.initialized = true;
            Err.info((String)(fn + "- platform default encoding: " + this.getPlatformDefaultFileEncoding()));
            Err.info((String)(fn + "- using encoding:            " + this.getFileEncoding()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isEncodingAvailable(String encoding) {
        String fn = new String("FileEncoding::isEncodingAvailable()");
        ByteArrayOutputStream testOutputStream = null;
        OutputStreamWriter testWriter = null;
        try {
            testOutputStream = new ByteArrayOutputStream(0);
            testWriter = new OutputStreamWriter((OutputStream)testOutputStream, encoding);
            boolean bl = true;
            return bl;
        }
        catch (UnsupportedEncodingException uee) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (testOutputStream != null) {
                    testOutputStream.close();
                    testOutputStream = null;
                }
                if (testWriter != null) {
                    testWriter.close();
                    testWriter = null;
                }
            }
            catch (IOException e) {
                Err.error((String)(e.getClass().getName() + ": " + e.getMessage()));
            }
        }
    }

    private boolean isPlatformEncodingUnsupported() {
        for (int i = 0; i < this.unsupportedEncodings.length; ++i) {
            if (!this.unsupportedEncodings[i].equalsIgnoreCase(this.platformDefaultFileEncoding)) continue;
            return true;
        }
        return false;
    }

    public String getPlatformDefaultFileEncoding() {
        String fn = new String("FileEncoding::getPlatformDefaultFileEncoding()");
        this.initialize();
        return this.platformDefaultFileEncoding;
    }

    public Reader getIAFileReader(InputStream in) {
        try {
            return new InputStreamReader(in, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Err.error((String)("Failed to create a UTF-8 decoder! Trying default: " + e.getMessage()));
            return new InputStreamReader(in);
        }
    }

    public Writer getIAFileWriter(OutputStream out) {
        try {
            return new OutputStreamWriter(out, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Err.error((String)("Failed to create a UTF-8 encoder! Trying default: " + e.getMessage()));
            return new OutputStreamWriter(out);
        }
    }

    public String getFileEncoding() {
        String fn = new String("FileEncoding::getFileEncoding()");
        this.initialize();
        return System.getProperty("file.encoding", this.platformDefaultFileEncoding);
    }

    private static synchronized String setSystemProperty(String key, String value) {
        Properties properties = System.getProperties();
        String oldValue = properties.getProperty(key);
        ((Hashtable)properties).put(key, value);
        System.setProperties(properties);
        return oldValue;
    }

    private static void debug(String function, String message) {
        Err.debug((String)(function + "- " + message));
    }
}

