/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.download.utility;

import com.zerog.ia.download.utility.nativelib.unix.Environment;
import java.io.File;
import java.util.StringTokenizer;
import netscape.security.PrivilegeManager;

public class Gestalt {
    public static String NETSCAPE_VM = "netscape";
    public static String MICROSOFT_VM = "microsoft";
    public static String SUN_VM = "sun";
    public static String APPLE_VM = "apple";
    public static String IBM_VM = "ibm";
    public static String WINDOWS_PLATFORM = "windows";
    public static String MAC_OS_PLATFORM = "mac os";
    public static String MAC_OS_X_PLATFORM = "mac os x";
    public static String SOLARIS_PLATFORM = "solaris";
    public static String HPUX_PLATFORM = "hp-ux";
    public static String LINUX_PLATFORM = "linux";
    public static String DGUX_PLATFORM = "dg-ux";
    public static String IRIX_PLATFORM = "irix";
    public static String AIX_PLATFORM = "aix";
    public static String OS2_PLATFORM = "os/2";
    public static String NETSCAPE_FILE_ACCESS = "UniversalFileAccess";
    public static String NETSCAPE_EXEC_ACCESS = "UniversalExecAccess";
    public static String NETSCAPE_PROPERTY_READ = "UniversalPropertyRead";
    private static String vmVendor;
    private static String platform;
    private static String vmVersion;
    private static String mrjVersion;
    private static boolean determinedAbleToCreateFiles;
    private static boolean determinedAbleToExecuteFiles;
    private static boolean determinedAbleToReadSystemProperties;
    private static boolean ableToCreateFiles;
    private static boolean ableToExecuteFiles;
    private static boolean ableToReadSystemProperties;
    private static boolean ableToBeSuperUser;
    private static boolean pathChecked;
    private static boolean checkPathResult;

    public static String getVMVendor() {
        if (vmVendor == null) {
            String vendorName = System.getProperty("java.vendor").toLowerCase();
            vmVendor = vendorName.indexOf("netscape") >= 0 ? NETSCAPE_VM : (vendorName.indexOf("microsoft") >= 0 ? MICROSOFT_VM : (vendorName.indexOf("sun") >= 0 || vendorName.indexOf("java") >= 0 ? SUN_VM : (vendorName.indexOf("apple") >= 0 || vendorName.indexOf("mac") >= 0 ? APPLE_VM : (vendorName.indexOf("ibm") >= 0 ? IBM_VM : vendorName.toLowerCase()))));
        }
        return vmVendor;
    }

    public static String getVMVersion() {
        if (vmVersion == null) {
            vmVersion = System.getProperty("java.version").toLowerCase();
        }
        return vmVersion;
    }

    public static String getMRJVersion() {
        if (mrjVersion == null) {
            mrjVersion = System.getProperty("mrj.version").toLowerCase();
        }
        return mrjVersion;
    }

    public static String getPlatform() {
        if (platform == null) {
            String osName = System.getProperty("os.name").toLowerCase();
            platform = osName.indexOf("win") != -1 ? WINDOWS_PLATFORM : (osName.indexOf("apple") != -1 || osName.indexOf("mac") != -1 ? (osName.indexOf("x") != -1 ? MAC_OS_X_PLATFORM : MAC_OS_PLATFORM) : (osName.indexOf("sun") != -1 || osName.indexOf("solaris") != -1 ? SOLARIS_PLATFORM : (osName.indexOf("linux") != -1 ? LINUX_PLATFORM : (osName.indexOf("hp") != -1 ? HPUX_PLATFORM : (osName.indexOf("aix") != -1 ? AIX_PLATFORM : osName.toLowerCase())))));
        }
        return platform;
    }

    public static boolean isThisPlatformUnix() {
        if (Gestalt.getPlatform().equals(SOLARIS_PLATFORM)) {
            return true;
        }
        if (Gestalt.getPlatform().equals(HPUX_PLATFORM)) {
            return true;
        }
        if (Gestalt.getPlatform().equals(LINUX_PLATFORM)) {
            return true;
        }
        if (Gestalt.getPlatform().equals(IRIX_PLATFORM)) {
            return true;
        }
        if (Gestalt.getPlatform().equals(AIX_PLATFORM)) {
            return true;
        }
        if (Gestalt.getPlatform().equals(DGUX_PLATFORM)) {
            return true;
        }
        if (Gestalt.getPlatform().equals(MAC_OS_X_PLATFORM)) {
            return true;
        }
        return Gestalt.getPlatform().indexOf("unix") >= 0;
    }

    public static boolean isSupportedVM() {
        return !(Gestalt.getPlatform().equals(MAC_OS_PLATFORM) ? Gestalt.getVMVendor().equals(MICROSOFT_VM) && Gestalt.getVMVersion().equals("1.1.4") : (Gestalt.getPlatform().equals(SOLARIS_PLATFORM) ? Gestalt.getVMVendor().equals(NETSCAPE_VM) && Gestalt.getVMVersion().equals("1.02") : (Gestalt.getPlatform().equals(OS2_PLATFORM) ? Gestalt.getVMVendor().equals(IBM_VM) && Gestalt.getVMVersion().equals("1.1.6") : Gestalt.getPlatform().equals(MAC_OS_X_PLATFORM) && Gestalt.getMRJVersion().equals("3.0"))));
    }

    public static boolean isNetscapeSecurityModelAvailable() {
        if (Gestalt.getVMVendor().equals(NETSCAPE_VM)) {
            return !Gestalt.getPlatform().equals(MAC_OS_PLATFORM);
        }
        return false;
    }

    public static boolean vmCanSupportUnsecureActivities() {
        if (Gestalt.getVMVendor().equals(MICROSOFT_VM)) {
            return Gestalt.getPlatform().equals(WINDOWS_PLATFORM);
        }
        if (Gestalt.getVMVendor().equals(NETSCAPE_VM)) {
            if (Gestalt.getPlatform().equals(WINDOWS_PLATFORM)) {
                return true;
            }
            if (Gestalt.getPlatform().equals(SOLARIS_PLATFORM)) {
                return true;
            }
        } else if (Gestalt.getVMVendor().equals(APPLE_VM)) {
            return Gestalt.getPlatform().equals(MAC_OS_PLATFORM) || Gestalt.getPlatform().equals(MAC_OS_X_PLATFORM);
        }
        return false;
    }

    public static boolean isAbleToReadSystemProperties() {
        if (!determinedAbleToReadSystemProperties) {
            if (Gestalt.isNetscapeSecurityModelAvailable()) {
                try {
                    PrivilegeManager.enablePrivilege((String)"UniversalPropertyAccess");
                    ableToReadSystemProperties = true;
                }
                catch (Exception e) {
                    ableToReadSystemProperties = false;
                }
            } else if (Gestalt.getVMVendor().equals(MICROSOFT_VM) || Gestalt.getVMVendor().equals(APPLE_VM)) {
                try {
                    String test = System.getProperty("user.home");
                    ableToReadSystemProperties = true;
                }
                catch (Throwable e) {
                    ableToReadSystemProperties = false;
                }
            }
            determinedAbleToReadSystemProperties = true;
        }
        return ableToReadSystemProperties;
    }

    public static boolean isAbleToSendEmail() {
        return Gestalt.getVMVendor() != NETSCAPE_VM;
    }

    public static boolean checkPathForVM() {
        if (Gestalt.getPlatform() == MAC_OS_X_PLATFORM) {
            pathChecked = true;
            checkPathResult = true;
        }
        if (!pathChecked && Gestalt.isThisPlatformUnix()) {
            pathChecked = true;
            try {
                PrivilegeManager.getPrivilegeManager();
                PrivilegeManager.enablePrivilege((String)NETSCAPE_FILE_ACCESS);
            }
            catch (Throwable e) {
                System.err.println("Not permitted to access system files:\n   " + e);
                checkPathResult = false;
                return checkPathResult;
            }
            try {
                PrivilegeManager.getPrivilegeManager();
                PrivilegeManager.enablePrivilege((String)NETSCAPE_EXEC_ACCESS);
            }
            catch (Throwable e) {
                System.err.println("Not permitted to exec files:\n   " + e);
                checkPathResult = false;
                return checkPathResult;
            }
            String platEnv = null;
            boolean pathExists = false;
            try {
                platEnv = Environment.getInstance().getValue("PATH");
            }
            catch (Throwable e) {
                System.err.println("Unable to verify system PATH:\n   " + e);
                checkPathResult = false;
                return checkPathResult;
            }
            if (platEnv == null || platEnv.trim().equals("")) {
                return false;
            }
            System.err.println("PATH = " + platEnv);
            StringTokenizer stPath = new StringTokenizer(platEnv, ":");
            while (!checkPathResult && stPath.hasMoreTokens()) {
                String pathString = stPath.nextToken();
                File jreFile = new File(pathString, "jre");
                File javaFile = new File(pathString, "java");
                if (!jreFile.exists() && !javaFile.exists()) continue;
                System.err.println("Java has been found on the system PATH");
                checkPathResult = true;
            }
            if (!checkPathResult) {
                System.err.println("Java could not be found on the system PATH");
            }
        }
        return checkPathResult;
    }

    public static boolean isAbleToCreateFiles() {
        if (!determinedAbleToCreateFiles) {
            if (Gestalt.isNetscapeSecurityModelAvailable()) {
                try {
                    PrivilegeManager.enablePrivilege((String)NETSCAPE_FILE_ACCESS);
                    ableToCreateFiles = true;
                }
                catch (Exception e) {
                    ableToCreateFiles = false;
                }
            } else if (Gestalt.getVMVendor().equals(MICROSOFT_VM) || Gestalt.getVMVendor().equals(APPLE_VM)) {
                try {
                    String test = System.getProperty("user.home");
                    ableToCreateFiles = true;
                }
                catch (Throwable e) {
                    ableToCreateFiles = false;
                }
            }
            determinedAbleToCreateFiles = true;
        }
        return ableToCreateFiles;
    }

    public static boolean isAbleToExecuteFiles() {
        if (!determinedAbleToExecuteFiles) {
            if (Gestalt.isNetscapeSecurityModelAvailable()) {
                try {
                    PrivilegeManager.enablePrivilege((String)NETSCAPE_EXEC_ACCESS);
                    ableToExecuteFiles = true;
                }
                catch (Exception e) {
                    ableToExecuteFiles = false;
                }
            } else if (Gestalt.getVMVendor().equals(MICROSOFT_VM) || Gestalt.getVMVendor().equals(APPLE_VM) || Gestalt.getVMVendor().equals(SUN_VM)) {
                try {
                    String test = System.getProperty("user.home");
                    ableToExecuteFiles = true;
                }
                catch (Throwable e) {
                    System.err.println("failed to resolve user.home, assuming unsigned and cannot execute");
                    ableToExecuteFiles = false;
                }
            }
            determinedAbleToExecuteFiles = true;
        }
        return ableToExecuteFiles;
    }

    static {
        determinedAbleToCreateFiles = false;
        determinedAbleToExecuteFiles = false;
        determinedAbleToReadSystemProperties = false;
        ableToCreateFiles = false;
        ableToExecuteFiles = false;
        ableToReadSystemProperties = false;
        ableToBeSuperUser = false;
        if (Gestalt.isNetscapeSecurityModelAvailable()) {
            Gestalt.isAbleToExecuteFiles();
            Gestalt.isAbleToCreateFiles();
            Gestalt.isAbleToReadSystemProperties();
        }
        pathChecked = false;
        checkPathResult = false;
    }
}

