/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.download.downloaders.macexecutils;

import java.io.IOException;
import java.io.Reader;

public class MacQuotStrmTok {
    private Reader in;
    private char quoteChar = (char)34;
    private char delimiter = (char)32;
    private boolean delimiting = true;
    private int type = -1;
    public static final int NOTHING = -1;
    public static final int WORDS = -10;
    public static final int FULL_QUOTED = -11;
    public static final int HALF_QUOTED = -12;
    private boolean drained = false;
    private boolean quoting = false;

    public MacQuotStrmTok(Reader in) {
        this.in = in;
    }

    public int getType() {
        return this.type;
    }

    public void setQuoteChar(char c) {
        this.quoteChar = c;
    }

    public char getQuoteChar() {
        return this.quoteChar;
    }

    public void setDelimiter(char c) {
        this.delimiter = c;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public boolean isDelimiting() {
        return this.delimiting;
    }

    public void setDelimiting(boolean delimiting) {
        this.delimiting = delimiting;
    }

    public String getNextToken() {
        StringBuffer buf = new StringBuffer();
        boolean gotSlash = false;
        if (this.drained) {
            this.type = -1;
            return null;
        }
        try {
            int piece;
            while ((piece = this.in.read()) != -1) {
                if (piece == 92) {
                    if (gotSlash) {
                        buf.append("\\");
                        gotSlash = false;
                        continue;
                    }
                    gotSlash = true;
                    continue;
                }
                if (piece == this.quoteChar) {
                    if (gotSlash) {
                        buf.append("\"");
                        gotSlash = false;
                        continue;
                    }
                    if (this.quoting) {
                        this.type = -11;
                        this.quoting = false;
                        return buf.toString();
                    }
                    this.quoting = true;
                    if (buf.length() <= 0) continue;
                    this.type = -10;
                    return buf.toString();
                }
                if (this.isDelimiting() && piece == this.delimiter && !this.quoting) {
                    if (gotSlash) {
                        buf.append("\\");
                        gotSlash = false;
                    }
                    if (buf.length() <= 0) continue;
                    this.type = -10;
                    return buf.toString();
                }
                if (gotSlash) {
                    buf.append("\\");
                    gotSlash = false;
                }
                buf.append(String.valueOf((char)piece));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.drained = true;
        this.type = this.quoting ? -12 : -10;
        if (buf.length() > 0) {
            return buf.toString();
        }
        return null;
    }

    public void close() {
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

