/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.download.downloaders.macexecutils;

import com.apple.mrj.MRJFileUtils;
import com.apple.mrj.MRJOSType;
import com.zerog.ia.download.downloaders.FileDownloader;
import com.zerog.ia.download.downloaders.macexecutils.MacComLineExec;
import com.zerog.ia.download.downloaders.macexecutils.MacDecoder;
import com.zerog.ia.download.utility.Util;
import java.io.File;

public class MacFileRunner {
    FileDownloader download;
    File fileToRun;

    public MacFileRunner(File _fileToRun, FileDownloader _download) {
        this.fileToRun = _fileToRun;
        this.download = _download;
    }

    public void runMacFile() {
        int extensionIndex = this.fileToRun.getName().indexOf(".bin");
        String exeName = extensionIndex != -1 ? this.fileToRun.getName().substring(0, extensionIndex) : "";
        try {
            String tempHome = Util.prepFileName(this.fileToRun.getParent());
            if (!tempHome.endsWith(File.separator)) {
                tempHome = tempHome + File.separator;
            }
            File binCopyFile = new File(tempHome, exeName);
            try {
                this.download.notifyOutputDiagnosticMessage("MacTryInstaller: MacBinaried File to Exec: " + this.fileToRun.getCanonicalPath());
                this.download.notifyOutputDiagnosticMessage("MacTryInstaller: Copy of MacBinary File: " + binCopyFile.getCanonicalPath());
            }
            catch (Exception e) {
                // empty catch block
            }
            this.download.notifyOutputDiagnosticMessage("Decoding MacBinary file...");
            String decodedTo = MacDecoder.decode(this.fileToRun, tempHome);
            this.download.notifyOutputDiagnosticMessage("Decoded to " + decodedTo);
            this.download.notifyOutputDiagnosticMessage("Debugging Info:");
            if (new File(binCopyFile.getAbsolutePath()).exists()) {
                this.download.notifyOutputDiagnosticMessage("   File (binCopyFile): " + binCopyFile.getAbsolutePath() + " exists.");
                this.setFileTypeAndCreator(binCopyFile, "APPL", "IAse");
            } else {
                this.download.notifyOutputDiagnosticMessage("   File (binCopyFile): " + binCopyFile.getAbsolutePath() + " does not exist.");
            }
            if (new File(this.fileToRun.getAbsolutePath()).exists()) {
                this.download.notifyOutputDiagnosticMessage("   File (exe): " + this.fileToRun.getAbsolutePath() + " exists.");
            } else {
                this.download.notifyOutputDiagnosticMessage("   File (exe):" + this.fileToRun.getAbsolutePath() + " does not exist.");
            }
            try {
                this.setFileTypeAndCreator(binCopyFile, "APPL", "IAse");
                MacComLineExec.execCommandLine("\"" + binCopyFile.getCanonicalPath() + "\"", false);
            }
            catch (Exception e) {
                this.download.notifyOutputDiagnosticMessage("First attempt to exec failed.  Trying again...");
                e.printStackTrace();
                MacComLineExec.execCommandLine("\"" + binCopyFile.getAbsolutePath() + "\"", false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setFileTypeAndCreator(File file, String type, String creator) {
        if (file == null) {
            System.err.println("setFileTypeAndCreator: No File Specified...");
            return;
        }
        System.err.println("setFileTypeAndCreator: File = " + file.getAbsolutePath());
        if (!file.exists()) {
            System.err.println("setFileTypeAndCreator: Specified File does not exist...");
            return;
        }
        MRJOSType tempType = null;
        MRJOSType tempCreator = null;
        try {
            tempType = MRJFileUtils.getFileType((File)file);
            tempCreator = MRJFileUtils.getFileCreator((File)file);
            if (tempType != null && tempType.toString().equals(type) && tempCreator != null && tempCreator.toString().equals(creator)) {
                System.err.println("setFileTypeAndCreator: File already has correct type and creator...");
            }
        }
        catch (Exception e) {
            System.err.println("setFileTypeAndCreator: Error getting current file type...");
        }
        try {
            for (int i = 0; i < 5; ++i) {
                try {
                    System.err.println("Attempting to set Mac OS file type and creator: " + file.getAbsolutePath() + ".");
                    MRJFileUtils.setFileType((File)file, (MRJOSType)new MRJOSType(type));
                    MRJFileUtils.setFileCreator((File)file, (MRJOSType)new MRJOSType(creator));
                    tempType = MRJFileUtils.getFileType((File)file);
                    tempCreator = MRJFileUtils.getFileCreator((File)file);
                    if (tempType != null && tempType.toString().equals(type) && tempCreator != null && tempCreator.toString().equals(creator)) {
                        System.err.println("setFileTypeAndCreator: File has been correctly typed...");
                        break;
                    }
                    System.err.println("Failure setting file type and creator:");
                    System.err.println("    Desired type:    " + type + ", Current type:    " + tempType.toString());
                    System.err.println("    Desired creator: " + creator + ", Current creator: " + tempCreator.toString());
                }
                catch (Exception e) {
                    System.err.println("setFileTypeAndCreator: Error setting Mac OS file type and creator.");
                }
                Thread.sleep(250L);
                System.gc();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

