/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.download.downloaders.macexecutils;

import com.zerog.ia.download.downloaders.macexecutils.MacHFSOutStrm;
import com.zerog.ia.download.downloaders.macexecutils.MacMB2InputStream;
import com.zerog.ia.download.downloaders.macexecutils.MacUtilFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class MacDecoder {
    private static final int kBufferSize = 2048;

    public static String decode(File inputFile) throws IOException {
        String destDirectory = inputFile.getParent() != null ? new String(inputFile.getParent() + File.separator) : "";
        return MacDecoder.decode(inputFile, destDirectory);
    }

    public static String decode(File inputFile, String destDirectory) throws IOException {
        FileInputStream fIn = new FileInputStream(inputFile);
        return MacDecoder.decode(fIn, destDirectory);
    }

    public static String decode(InputStream is, String destDirectory) throws IOException {
        byte[] buffer = new byte[2048];
        byte[] finderInfo = new byte[16];
        MacMB2InputStream in = new MacMB2InputStream(is);
        in.getFinderInfo(finderInfo);
        String fileName = in.getFilename();
        MacUtilFile macFile = new MacUtilFile(destDirectory + fileName);
        MacHFSOutStrm hfsOutputStream = new MacHFSOutStrm(macFile);
        int bytesRead = 0;
        while ((bytesRead = in.read(buffer, 0, buffer.length)) != -1) {
            hfsOutputStream.write(0, buffer, 0, bytesRead);
        }
        while ((bytesRead = in.readRF(buffer, 0, buffer.length)) != -1) {
            hfsOutputStream.write(1, buffer, 0, bytesRead);
        }
        hfsOutputStream.write(2, finderInfo, 0, finderInfo.length);
        hfsOutputStream.close();
        return fileName;
    }
}

