/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.download.downloaders.macexecutils;

import com.zerog.ia.download.downloaders.macexecutils.MacQuotStrmTok;
import com.zerog.ia.download.downloaders.macexecutils.MacURLEncoder;
import java.io.IOException;
import java.io.StringReader;
import java.util.Vector;

public class MacComLineExec {
    public static final boolean MRJ_20 = System.getProperty("java.version").equals("1.1.3");

    public static boolean execCommandLine(String arg, boolean verbose) {
        String[] finalArgs = MacComLineExec.formatCommandLine(arg);
        Process p = null;
        try {
            if (verbose) {
                System.err.println("EXEC 2----------------------------- BEGIN");
            }
            p = Runtime.getRuntime().exec(finalArgs, new String[]{""});
        }
        catch (IOException e) {
            System.err.println("EXEC ------------------------------ ERROR");
            System.err.println("Your arguments were " + finalArgs);
            e.printStackTrace();
            System.err.println("EXEC ------------------------------ END");
            return false;
        }
        System.err.println("not waiting for process to complete.");
        if (verbose) {
            System.err.println("EXEC ------------------------------ END");
        }
        return true;
    }

    public static String[] formatCommandLine(String line) {
        String[] commandsArray = MacComLineExec.getArgArray(line);
        MacComLineExec.formatCommandsForPlatform(commandsArray);
        return commandsArray;
    }

    public static void formatCommandsForPlatform(String[] commands) {
        for (int i = 0; i < commands.length; ++i) {
            if (!MRJ_20) continue;
            commands[i] = MacURLEncoder.encode(commands[i]);
        }
    }

    public static String[] getArgArray(String line) {
        Vector<String> commands = new Vector<String>();
        MacQuotStrmTok st = new MacQuotStrmTok(new StringReader(line));
        try {
            String token;
            while ((token = st.getNextToken()) != null) {
                if (st.getType() == -10) {
                    commands.addElement(token);
                    continue;
                }
                if (st.getType() == -11) {
                    commands.addElement(token);
                    continue;
                }
                if (st.getType() != -12) continue;
                commands.addElement(token);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Object[] commandsArray = new String[commands.size()];
        commands.copyInto(commandsArray);
        return commandsArray;
    }
}

