/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.common.java.lang;

import java.text.Collator;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class StringUtil {
    private static char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static char[] hexvalues = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static boolean contains(String string, char c) {
        return string.indexOf(c) != -1;
    }

    public static String[] orderStrings(Enumeration strings) {
        return StringUtil.orderStrings(strings, false);
    }

    public static String[] orderStrings(String[] strings) {
        return StringUtil.orderStrings(strings, false);
    }

    public static String[] orderStrings(Enumeration strings, boolean caseSensitive) {
        Vector<String> v = new Vector<String>();
        while (strings.hasMoreElements()) {
            v.addElement((String)strings.nextElement());
        }
        Object[] stringArray = new String[v.size()];
        v.copyInto(stringArray);
        return StringUtil.orderStrings((String[])stringArray, caseSensitive);
    }

    public static String[] orderStrings(String[] strings, boolean caseSensitive) {
        Vector<String> orderedNames = new Vector<String>(strings.length);
        for (int i = 0; i < strings.length; ++i) {
            int j;
            String name = strings[i];
            for (j = orderedNames.size(); j > 0; --j) {
                String lower_elem;
                String lower_name;
                String elem = (String)orderedNames.elementAt(j - 1);
                if (caseSensitive) {
                    lower_name = name;
                    lower_elem = elem;
                } else {
                    lower_name = name.toLowerCase();
                    lower_elem = elem.toLowerCase();
                }
                int result = caseSensitive ? lower_name.compareTo(lower_elem) : Collator.getInstance().compare(lower_name, lower_elem);
                if (result < 0) continue;
                orderedNames.insertElementAt(name, j);
                j = -1;
            }
            if (j != 0) continue;
            orderedNames.insertElementAt(name, 0);
        }
        Object[] returnStrings = new String[strings.length];
        orderedNames.copyInto(returnStrings);
        return returnStrings;
    }

    private static String getEscUnicodeRepresentation(char character) {
        StringBuffer encoded = new StringBuffer();
        StringUtil.appendEscUnicodeRepresentation(character, encoded);
        return encoded.toString();
    }

    private static void appendEscUnicodeRepresentation(char character, StringBuffer buf) {
        if (character == '\\') {
            buf.append("\\\\");
        } else {
            buf.append("\\u");
            buf.append(hexDigit[character >> 12 & 0xF]);
            buf.append(hexDigit[character >> 8 & 0xF]);
            buf.append(hexDigit[character >> 4 & 0xF]);
            buf.append(hexDigit[character >> 0 & 0xF]);
        }
    }

    public static boolean containsUnicode(String string) {
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            char currentChar = string.charAt(i);
            if (currentChar <= '~' && currentChar >= ' ' && currentChar != '\\') continue;
            return true;
        }
        return false;
    }

    public static String convertToEscapedUnicode(String unencoded) {
        StringBuffer encoded = new StringBuffer();
        int length = unencoded.length();
        for (int i = 0; i < length; ++i) {
            char currentChar = unencoded.charAt(i);
            if (currentChar > '~' || currentChar < ' ' || currentChar == '\\') {
                StringUtil.appendEscUnicodeRepresentation(currentChar, encoded);
                continue;
            }
            encoded.append(currentChar);
        }
        return encoded.toString();
    }

    public static String convertFromEscapedUnicode(String encoded) {
        if (encoded == null) {
            return null;
        }
        int stringLength = encoded.length();
        StringBuffer decoded = new StringBuffer(stringLength);
        int formedUnicodeCharacter = -1;
        int characterOffset = 0;
        char currentChar = '\u0000';
        int i = 0;
        while (i < stringLength) {
            currentChar = encoded.charAt(i);
            if (currentChar == '\\') {
                if (++i >= stringLength) continue;
                currentChar = encoded.charAt(i);
                if (currentChar == 'u') {
                    ++i;
                    formedUnicodeCharacter = 0;
                    for (int j = 0; j < 4 && i < stringLength; ++i, ++j) {
                        currentChar = encoded.charAt(i);
                        characterOffset = StringUtil.getOffset(currentChar);
                        if (characterOffset == -1) {
                            decoded.append("\\u");
                            while (j > 0) {
                                decoded.append(encoded.charAt(i - j));
                                --j;
                            }
                            formedUnicodeCharacter = -1;
                            break;
                        }
                        formedUnicodeCharacter = (formedUnicodeCharacter << 4) + currentChar - characterOffset;
                    }
                    if (formedUnicodeCharacter == -1) continue;
                    decoded.append((char)formedUnicodeCharacter);
                    continue;
                }
                decoded.append(currentChar);
                ++i;
                continue;
            }
            decoded.append(currentChar);
            ++i;
        }
        return decoded.toString();
    }

    private static int getOffset(int c) {
        if (c >= 48 && c <= 57) {
            return 48;
        }
        if (c >= 65 && c <= 70) {
            return 55;
        }
        if (c >= 97 && c <= 102) {
            return 87;
        }
        return -1;
    }

    public static String cutOutExtension(String filePathOrURL) {
        int extPos = filePathOrURL.lastIndexOf(46);
        if (extPos > -1) {
            return filePathOrURL.substring(0, extPos);
        }
        return filePathOrURL;
    }

    public static String xor(String key, String value) {
        if (key == null || key.trim().length() == 0) {
            throw new IllegalArgumentException("The 'key' argument of the StringUtil.xorString method cannot be null, blank or empty.");
        }
        if (value == null || value.equals("")) {
            throw new IllegalArgumentException("The 'value' argument of the StringUtil.xorString method cannot be null or empty.");
        }
        StringBuffer transformedValue = new StringBuffer(value.length());
        for (int i = 0; i < value.length(); ++i) {
            char keyChar = key.charAt(i % key.length());
            char valueChar = value.charAt(i);
            char xorChar = (char)(keyChar ^ valueChar);
            transformedValue.append(xorChar);
        }
        return transformedValue.toString();
    }

    public static String byteArrayToHexString(byte[] bytes) {
        StringBuffer hex = new StringBuffer();
        for (int cx = 0; cx < bytes.length; ++cx) {
            hex.append(StringUtil.byteToHex(bytes[cx]));
        }
        return hex.toString();
    }

    public static char[] byteToHex(byte b) {
        char[] hex = new char[]{hexvalues[(b & 0xF0) >> 4], hexvalues[b & 0xF]};
        return hex;
    }

    public static String replaceNonDisplayableChars(String messageText) {
        Object output = null;
        String patternStr = "\u00a9";
        String replacementStr = "(c)";
        try {
            RE r = new RE(patternStr);
            return r.subst(messageText, replacementStr);
        }
        catch (RESyntaxException e) {
            e.printStackTrace();
            return messageText;
        }
    }
}

